/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xindice.core.indexer;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.StringTokenizer;
import org.apache.xindice.core.filer.Streamable;
import org.apache.xindice.xml.NamespaceMap;
import org.apache.xindice.xml.SymbolTable;

public final class IndexPattern
implements Streamable {
    public static final int PATTERN_NONE = -1;
    public static final int PATTERN_WILDCARD = -2;
    public static final int PATTERN_NAME = -3;
    public static final int SCORE_NONE = 0;
    public static final int SCORE_WILDCARD = 1;
    public static final int SCORE_NAME = 2;
    public static final int SCORE_NATURAL = 3;
    private SymbolTable symbols;
    private String elemName;
    private short elemID = (short)-1;
    private String attrName;
    private short attrID = (short)-1;

    public IndexPattern(SymbolTable symbols, String pattern, NamespaceMap nsMap) {
        this.symbols = symbols;
        StringTokenizer st = new StringTokenizer(pattern.trim(), "@");
        this.elemName = st.nextToken();
        this.elemID = this.elemName.equals("*") ? (short)-2 : SymbolTable.getNormalizedSymbol(symbols, this.elemName, nsMap, true);
        if (st.hasMoreTokens()) {
            this.attrName = st.nextToken();
            this.attrID = this.attrName.equals("*") ? (short)-2 : (short)(this.elemID == -2 ? -3 : (int)SymbolTable.getNormalizedSymbol(symbols, this.attrName, nsMap, true));
        }
    }

    public IndexPattern(SymbolTable symbols, short elemID) {
        this.symbols = symbols;
        this.elemID = elemID;
        this.elemName = symbols.getName(elemID);
    }

    public IndexPattern(SymbolTable symbols, short elemID, short attrID) {
        this.symbols = symbols;
        this.elemID = elemID;
        this.elemName = symbols.getName(elemID);
        this.attrID = attrID;
        this.attrName = symbols.getName(attrID);
    }

    public IndexPattern(SymbolTable symbols, short elemID, String attrName) {
        this.symbols = symbols;
        this.elemID = elemID;
        this.attrID = (short)-3;
        this.attrName = attrName;
    }

    public int getMatchLevel(IndexPattern p) {
        int result = 0;
        switch (p.elemID) {
            case -2: {
                result = 4;
                break;
            }
            case -3: {
                if (!p.elemName.equals(this.elemName)) break;
                result = 8;
                break;
            }
            default: {
                if (this.elemID != p.elemID) break;
                result = 12;
            }
        }
        if (result != 0) {
            switch (p.attrID) {
                case -2: {
                    return result + 1;
                }
                case -3: {
                    if (!p.attrName.equals(this.attrName)) break;
                    return result + 2;
                }
                default: {
                    if (this.attrID != p.attrID) break;
                    return result + 3;
                }
            }
        }
        return 0;
    }

    public short getElementID() {
        return this.elemID;
    }

    public short getAttributeID() {
        return this.attrID;
    }

    public String getElementName() {
        return this.elemName;
    }

    public String getAttributeName() {
        return this.attrName;
    }

    public void read(DataInput dis) throws IOException {
        byte[] name;
        short len;
        this.elemID = dis.readShort();
        if (this.elemID == -3) {
            len = dis.readShort();
            name = new byte[len];
            dis.readFully(name);
            this.elemName = new String(name, "utf-8");
        }
        this.attrID = dis.readShort();
        if (this.attrID == -3) {
            len = dis.readShort();
            name = new byte[len];
            dis.readFully(name);
            this.attrName = new String(name, "utf-8");
        }
    }

    public void write(DataOutput dos) throws IOException {
        byte[] name;
        dos.writeShort(this.elemID);
        if (this.elemID == -3) {
            name = this.elemName.getBytes("utf-8");
            dos.writeShort(name.length);
            dos.write(name);
        }
        dos.writeShort(this.attrID);
        if (this.attrID == -3) {
            name = this.attrName.getBytes("utf-8");
            dos.writeShort(name.length);
            dos.write(name);
        }
    }

    public int hashCode() {
        return (this.elemID << 16) + this.attrID;
    }

    public boolean equals(Object obj) {
        if (obj instanceof IndexPattern) {
            boolean eq;
            IndexPattern p = (IndexPattern)obj;
            boolean bl = eq = this.elemID == p.elemID && this.attrID == p.attrID;
            if (eq && (this.elemName != null || p.elemName != null)) {
                boolean bl2 = eq = this.elemName != null && p.elemName != null && this.elemName.equals(p.elemName);
            }
            if (eq && (this.attrName != null || p.attrName != null)) {
                eq = this.attrName != null && p.attrName != null && this.attrName.equals(p.attrName);
            }
            return eq;
        }
        return false;
    }
}

