/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.fonts;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.apache.commons.io.IOUtils;

public class Glyphs {
    public static final String NOTDEF = ".notdef";
    public static final String[] MAC_GLYPH_NAMES;
    public static final String[] TEX8R_GLYPH_NAMES;
    public static final char[] WINANSI_ENCODING;
    private static final String[] UNICODE_GLYPHS;
    private static final String[] DINGBATS_GLYPHS;
    private static final Map CHARNAME_ALTERNATIVES;
    private static final Map CHARNAMES_TO_UNICODE;
    static final /* synthetic */ boolean $assertionsDisabled;

    private static void addAlternatives(Map map, String[] alternatives) {
        int c = alternatives.length;
        for (int i = 0; i < c; ++i) {
            String[] alt = new String[c - 1];
            int idx = 0;
            for (int j = 0; j < c; ++j) {
                if (i == j) continue;
                alt[idx] = alternatives[j];
                ++idx;
            }
            map.put(alternatives[i], alt);
        }
    }

    private static String[] loadGlyphList(String filename, Map charNameToUnicodeMap) {
        ArrayList<String> lines = new ArrayList<String>();
        InputStream in = Glyphs.class.getResourceAsStream(filename);
        if (in == null) {
            throw new Error("Cannot load " + filename + ". The Glyphs class cannot properly be initialized!");
        }
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in, "US-ASCII"));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("#")) continue;
                lines.add(line);
            }
        }
        catch (UnsupportedEncodingException uee) {
            throw new Error("Incompatible JVM! US-ASCII encoding is not supported. The Glyphs class cannot properly be initialized!");
        }
        catch (IOException ioe) {
            throw new Error("I/O error while loading " + filename + ". The Glyphs class cannot properly be initialized!");
        }
        finally {
            IOUtils.closeQuietly((InputStream)in);
        }
        String[] arr = new String[lines.size() * 2];
        int pos = 0;
        StringBuffer buf = new StringBuffer();
        int c = lines.size();
        for (int i = 0; i < c; ++i) {
            String unicode;
            String line = (String)lines.get(i);
            int semicolon = line.indexOf(59);
            if (semicolon <= 0) continue;
            String charName = line.substring(0, semicolon);
            String rawUnicode = line.substring(semicolon + 1);
            buf.setLength(0);
            StringTokenizer tokenizer = new StringTokenizer(rawUnicode, " ", false);
            while (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                if (!$assertionsDisabled && token.length() != 4) {
                    throw new AssertionError();
                }
                buf.append(Glyphs.hexToChar(token));
            }
            arr[pos] = unicode = buf.toString();
            arr[++pos] = charName;
            ++pos;
            if (!$assertionsDisabled && charNameToUnicodeMap.containsKey(charName)) {
                throw new AssertionError();
            }
            charNameToUnicodeMap.put(charName, unicode);
        }
        return arr;
    }

    private static char hexToChar(String hex) {
        return (char)Integer.parseInt(hex, 16);
    }

    public static final String charToGlyphName(char ch) {
        return Glyphs.stringToGlyph(Character.toString(ch));
    }

    public static final String getUnicodeSequenceForGlyphName(String glyphName) {
        int period = glyphName.indexOf(46);
        if (period >= 0) {
            glyphName = glyphName.substring(0, period);
        }
        StringBuffer sb = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(glyphName, "_", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            String sequence = (String)CHARNAMES_TO_UNICODE.get(token);
            if (sequence == null) {
                if (token.startsWith("uni")) {
                    int len = token.length();
                    int pos = 3;
                    while (pos + 4 <= len) {
                        try {
                            sb.append(Glyphs.hexToChar(token.substring(pos, pos + 4)));
                        }
                        catch (NumberFormatException nfe) {
                            return null;
                        }
                        pos += 4;
                    }
                    continue;
                }
                if (!token.startsWith("u")) continue;
                if (token.length() > 7) {
                    return null;
                }
                try {
                    sb.append(Glyphs.hexToChar(token.substring(1, 5)));
                    continue;
                }
                catch (NumberFormatException nfe) {
                    return null;
                }
            }
            sb.append(sequence);
        }
        if (sb.length() == 0) {
            return null;
        }
        return sb.toString();
    }

    public static final String glyphToString(String name) {
        for (int i = 0; i < UNICODE_GLYPHS.length; i += 2) {
            if (!UNICODE_GLYPHS[i + 1].equals(name)) continue;
            return UNICODE_GLYPHS[i];
        }
        return "";
    }

    public static String stringToGlyph(String name) {
        int i;
        for (i = 0; i < UNICODE_GLYPHS.length; i += 2) {
            if (!UNICODE_GLYPHS[i].equals(name)) continue;
            return UNICODE_GLYPHS[i + 1];
        }
        for (i = 0; i < DINGBATS_GLYPHS.length; i += 2) {
            if (!DINGBATS_GLYPHS[i].equals(name)) continue;
            return DINGBATS_GLYPHS[i + 1];
        }
        return "";
    }

    public static String[] getCharNameAlternativesFor(String charName) {
        return (String[])CHARNAME_ALTERNATIVES.get(charName);
    }

    static {
        $assertionsDisabled = !Glyphs.class.desiredAssertionStatus();
        MAC_GLYPH_NAMES = new String[]{NOTDEF, ".null", "CR", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quotesingle", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "grave", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", "Adieresis", "Aring", "Ccedilla", "Eacute", "Ntilde", "Odieresis", "Udieresis", "aacute", "agrave", "acircumflex", "adieresis", "atilde", "aring", "ccedilla", "eacute", "egrave", "ecircumflex", "edieresis", "iacute", "igrave", "icircumflex", "idieresis", "ntilde", "oacute", "ograve", "ocircumflex", "odieresis", "otilde", "uacute", "ugrave", "ucircumflex", "udieresis", "dagger", "degree", "cent", "sterling", "section", "bullet", "paragraph", "germandbls", "registered", "copyright", "trademark", "acute", "dieresis", "notequal", "AE", "Oslash", "infinity", "plusminus", "lessequal", "greaterequal", "yen", "mu", "partialdiff", "Sigma", "Pi", "pi", "integral", "ordfeminine", "ordmasculine", "Omega", "ae", "oslash", "questiondown", "exclamdown", "logicalnot", "radical", "florin", "approxequal", "Delta", "guillemotleft", "guillemotright", "ellipsis", "nbspace", "Agrave", "Atilde", "Otilde", "OE", "oe", "endash", "emdash", "quotedblleft", "quotedblright", "quoteleft", "quoteright", "divide", "lozenge", "ydieresis", "Ydieresis", "fraction", "currency", "guilsinglleft", "guilsinglright", "fi", "fl", "daggerdbl", "periodcentered", "quotesinglbase", "quotedblbase", "perthousand", "Acircumflex", "Ecircumflex", "Aacute", "Edieresis", "Egrave", "Iacute", "Icircumflex", "Idieresis", "Igrave", "Oacute", "Ocircumflex", "applelogo", "Ograve", "Uacute", "Ucircumflex", "Ugrave", "dotlessi", "circumflex", "tilde", "macron", "breve", "dotaccent", "ring", "cedilla", "hungarumlaut", "ogonek", "caron", "Lslash", "lslash", "Scaron", "scaron", "Zcaron", "zcaron", "brokenbar", "Eth", "eth", "Yacute", "yacute", "Thorn", "thorn", "minus", "multiply", "onesuperior", "twosuperior", "threesuperior", "onehalf", "onequarter", "threequarters", "franc", "Gbreve", "gbreve", "Idot", "Scedilla", "scedilla", "Cacute", "cacute", "Ccaron", "ccaron", "dmacron"};
        TEX8R_GLYPH_NAMES = new String[]{NOTDEF, "dotaccent", "fi", "fl", "fraction", "hungarumlaut", "Lslash", "lslash", "ogonek", "ring", NOTDEF, "breve", "minus", NOTDEF, "Zcaron", "zcaron", "caron", "dotlessi", "dotlessj", "ff", "ffi", "ffl", NOTDEF, NOTDEF, NOTDEF, NOTDEF, NOTDEF, NOTDEF, NOTDEF, NOTDEF, "grave", "quotesingle", "space", "exclam", "quotedbl", "numbersign", "dollar", "percent", "ampersand", "quoteright", "parenleft", "parenright", "asterisk", "plus", "comma", "hyphen", "period", "slash", "zero", "one", "two", "three", "four", "five", "six", "seven", "eight", "nine", "colon", "semicolon", "less", "equal", "greater", "question", "at", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "bracketleft", "backslash", "bracketright", "asciicircum", "underscore", "quoteleft", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "braceleft", "bar", "braceright", "asciitilde", NOTDEF, "Euro", NOTDEF, "quotesinglbase", "florin", "quotedblbase", "ellipsis", "dagger", "daggerdbl", "circumflex", "perthousand", "Scaron", "guilsinglleft", "OE", NOTDEF, NOTDEF, NOTDEF, NOTDEF, NOTDEF, NOTDEF, "quotedblleft", "quotedblright", "bullet", "endash", "emdash", "tilde", "trademark", "scaron", "guilsinglright", "oe", NOTDEF, NOTDEF, "Ydieresis", NOTDEF, "exclamdown", "cent", "sterling", "currency", "yen", "brokenbar", "section", "dieresis", "copyright", "ordfeminine", "guillemotleft", "logicalnot", "hyphen", "registered", "macron", "degree", "plusminus", "twosuperior", "threesuperior", "acute", "mu", "paragraph", "periodcentered", "cedilla", "onesuperior", "ordmasculine", "guillemotright", "onequarter", "onehalf", "threequarters", "questiondown", "Agrave", "Aacute", "Acircumflex", "Atilde", "Adieresis", "Aring", "AE", "Ccedilla", "Egrave", "Eacute", "Ecircumflex", "Edieresis", "Igrave", "Iacute", "Icircumflex", "Idieresis", "Eth", "Ntilde", "Ograve", "Oacute", "Ocircumflex", "Otilde", "Odieresis", "multiply", "Oslash", "Ugrave", "Uacute", "Ucircumflex", "Udieresis", "Yacute", "Thorn", "germandbls", "agrave", "aacute", "acircumflex", "atilde", "adieresis", "aring", "ae", "ccedilla", "egrave", "eacute", "ecircumflex", "edieresis", "igrave", "iacute", "icircumflex", "idieresis", "eth", "ntilde", "ograve", "oacute", "ocircumflex", "otilde", "odieresis", "divide", "oslash", "ugrave", "uacute", "ucircumflex", "udieresis", "yacute", "thorn", "ydieresis"};
        WINANSI_ENCODING = new char[]{'\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', '\u0000', ' ', '!', '\"', '#', '$', '%', '&', '\'', '(', ')', '*', '+', ',', '-', '.', '/', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ':', ';', '<', '=', '>', '?', '@', 'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', '[', '\\', ']', '^', '_', '\u2018', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '{', '|', '}', '~', '\u2022', '\u20ac', '\u2022', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u2022', '\u017d', '\u2022', '\u2022', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '~', '\u2122', '\u0161', '\u203a', '\u0153', '\u2022', '\u017e', '\u0178', ' ', '\u00a1', '\u00a2', '\u00a3', '\u00a4', '\u00a5', '\u00a6', '\u00a7', '\u00a8', '\u00a9', '\u00aa', '\u00ab', '\u00ac', '\u00ad', '\u00ae', '\u00af', '\u00b0', '\u00b1', '\u00b2', '\u00b3', '\u00b4', '\u00b5', '\u00b6', '\u00b7', '\u00b8', '\u00b9', '\u00ba', '\u00bb', '\u00bc', '\u00bd', '\u00be', '\u00bf', '\u00c0', '\u00c1', '\u00c2', '\u00c3', '\u00c4', '\u00c5', '\u00c6', '\u00c7', '\u00c8', '\u00c9', '\u00ca', '\u00cb', '\u00cc', '\u00cd', '\u00ce', '\u00cf', '\u00d0', '\u00d1', '\u00d2', '\u00d3', '\u00d4', '\u00d5', '\u00d6', '\u00d7', '\u00d8', '\u00d9', '\u00da', '\u00db', '\u00dc', '\u00dd', '\u00de', '\u00df', '\u00e0', '\u00e1', '\u00e2', '\u00e3', '\u00e4', '\u00e5', '\u00e6', '\u00e7', '\u00e8', '\u00e9', '\u00ea', '\u00eb', '\u00ec', '\u00ed', '\u00ee', '\u00ef', '\u00f0', '\u00f1', '\u00f2', '\u00f3', '\u00f4', '\u00f5', '\u00f6', '\u00f7', '\u00f8', '\u00f9', '\u00fa', '\u00fb', '\u00fc', '\u00fd', '\u00fe', '\u00ff'};
        TreeMap map = new TreeMap();
        UNICODE_GLYPHS = Glyphs.loadGlyphList("glyphlist.txt", map);
        DINGBATS_GLYPHS = Glyphs.loadGlyphList("zapfdingbats.txt", map);
        CHARNAMES_TO_UNICODE = Collections.unmodifiableMap(map);
        map = new TreeMap();
        Glyphs.addAlternatives(map, new String[]{"Omega", "Omegagreek"});
        Glyphs.addAlternatives(map, new String[]{"Delta", "Deltagreek"});
        Glyphs.addAlternatives(map, new String[]{"fraction", "divisionslash"});
        Glyphs.addAlternatives(map, new String[]{"hyphen", "sfthyphen", "softhyphen"});
        Glyphs.addAlternatives(map, new String[]{"macron", "overscore"});
        Glyphs.addAlternatives(map, new String[]{"mu", "mu1", "mugreek"});
        Glyphs.addAlternatives(map, new String[]{"periodcentered", "middot", "bulletoperator", "anoteleia"});
        Glyphs.addAlternatives(map, new String[]{"space", "nonbreakingspace", "nbspace"});
        Glyphs.addAlternatives(map, new String[]{"zero", "zerooldstyle"});
        Glyphs.addAlternatives(map, new String[]{"one", "oneoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"two", "twooldstyle"});
        Glyphs.addAlternatives(map, new String[]{"three", "threeoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"four", "fouroldstyle"});
        Glyphs.addAlternatives(map, new String[]{"five", "fiveoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"six", "sixoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"seven", "sevenoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"eight", "eightoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"nine", "nineoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"cent", "centoldstyle"});
        Glyphs.addAlternatives(map, new String[]{"dollar", "dollaroldstyle"});
        CHARNAME_ALTERNATIVES = Collections.unmodifiableMap(map);
    }
}

