/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.tabcontrol.plaf;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.AWTEventListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.lang.reflect.Field;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.Popup;
import javax.swing.PopupFactory;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.swing.tabcontrol.TabData;
import org.netbeans.swing.tabcontrol.TabDisplayer;
import org.netbeans.swing.tabcontrol.plaf.TabListPopupTableModel;
import org.openide.awt.HtmlRenderer;

final class TabListPopup
extends JTable
implements MouseMotionListener,
MouseListener {
    private Component invokingComponent = null;
    private Dimension prefSize = null;
    boolean needCalcRowHeight = true;
    private TabDisplayer displayer = null;
    private static Popup currentPopup = null;
    private static AWTEventListener blistener = null;
    private static Reference instance = null;
    long invocationTime = -1L;
    private static final Border rendererBorder = BorderFactory.createEmptyBorder(2, 3, 0, 3);
    private static HtmlRenderer.Renderer renderer = null;
    static SoftReference ctx = null;

    private TabListPopup() {
        super(new TabListPopupTableModel());
        this.setBorder(BorderFactory.createLineBorder(this.getForeground()));
        this.setShowHorizontalLines(false);
        this.setBackground(UIManager.getColor("ComboBox.background"));
        if (renderer == null) {
            renderer = HtmlRenderer.createRenderer();
        }
        this.setDefaultRenderer(Object.class, renderer);
    }

    private void setSelectedTab(int n, int n2) {
        Object object = this.getTTModel().getValueAt(n, n2);
        if (object instanceof TabData) {
            int n3;
            TabData tabData = (TabData)object;
            List list = this.displayer.getModel().getTabs();
            int n4 = -1;
            for (n3 = 0; n3 < list.size(); ++n3) {
                if (!tabData.equals(list.get(n3))) continue;
                n4 = n3;
                break;
            }
            if (n4 != -1) {
                n3 = this.displayer.getSelectionModel().getSelectedIndex();
                this.displayer.getSelectionModel().setSelectedIndex(n4);
                if (this.displayer.getType() == 1 && n4 >= 0 && n4 == n3) {
                    this.displayer.getUI().makeTabVisible(n4);
                }
            }
        }
    }

    public void updateUI() {
        this.needCalcRowHeight = true;
        super.updateUI();
    }

    public void setFont(Font font) {
        this.needCalcRowHeight = true;
        super.setFont(font);
    }

    public Component prepareRenderer(TableCellRenderer tableCellRenderer, int n, int n2) {
        Object object = this.getTTModel().getValueAt(n, n2);
        int n3 = this.displayer.getSelectionModel().getSelectedIndex();
        boolean bl = n3 != -1 ? object == this.displayer.getModel().getTab(n3) : false;
        boolean bl2 = n == this.getSelectedRow() && n2 == this.getSelectedColumn() && object != null;
        JComponent jComponent = (JComponent)tableCellRenderer.getTableCellRendererComponent(this, object, bl2, bl2, n, n2);
        if (object == null) {
            jComponent.setOpaque(false);
            return jComponent;
        }
        if (bl) {
            jComponent.setFont(this.getFont().deriveFont(1));
        }
        Icon icon = ((TabData)object).getIcon();
        HtmlRenderer.Renderer renderer = (HtmlRenderer.Renderer)((Object)jComponent);
        renderer.setIcon(icon);
        if (icon.getIconWidth() > 0) {
            renderer.setIconTextGap(26 - icon.getIconWidth());
        } else {
            renderer.setIndent(26);
        }
        ((HtmlRenderer.Renderer)((Object)jComponent)).setParentFocused(true);
        jComponent.setBorder(rendererBorder);
        jComponent.setOpaque(true);
        if (bl2) {
            jComponent.setBackground(this.getSelectionBackground());
            jComponent.setForeground(this.getSelectionForeground());
        } else {
            jComponent.setBackground(this.getBackground());
            jComponent.setForeground(this.getForeground());
        }
        return jComponent;
    }

    private void calcRowHeight(Graphics graphics) {
        Font font = this.getFont();
        FontMetrics fontMetrics = graphics.getFontMetrics(font);
        int n = Math.max(fontMetrics.getHeight(), 16) + 4;
        this.needCalcRowHeight = false;
        this.setRowHeight(n);
    }

    public void attach(TabDisplayer tabDisplayer) {
        this.prefSize = null;
        this.displayer = tabDisplayer;
        this.calcRowHeight(TabListPopup.getOffscreenGraphics());
        this.getTTModel().setRowHeight(this.getRowHeight());
        this.getTTModel().attach(tabDisplayer);
        this.synchronizeColumns(this.getTTModel().getColumnCount());
        this.getSelectionModel().clearSelection();
        this.getSelectionModel().setAnchorSelectionIndex(-1);
        this.getSelectionModel().setLeadSelectionIndex(-1);
    }

    public static Graphics2D getOffscreenGraphics() {
        BufferedImage bufferedImage = null;
        if (ctx != null) {
            bufferedImage = (BufferedImage)ctx.get();
        }
        if (bufferedImage == null) {
            bufferedImage = new BufferedImage(10, 10, 1);
            ctx = new SoftReference<BufferedImage>(bufferedImage);
        }
        return (Graphics2D)bufferedImage.getGraphics();
    }

    private void synchronizeColumns(int n) {
        block3: {
            int n2;
            TableColumnModel tableColumnModel;
            block2: {
                tableColumnModel = this.getColumnModel();
                n2 = tableColumnModel.getColumnCount();
                if (n2 >= n) break block2;
                for (int i = n2; i < n; ++i) {
                    tableColumnModel.addColumn(new TableColumn(i, 75, renderer, null));
                }
                break block3;
            }
            if (n2 <= n) break block3;
            for (int i = n2 - 1; i >= n; --i) {
                tableColumnModel.removeColumn(tableColumnModel.getColumn(i));
            }
        }
    }

    public Dimension getPreferredSize() {
        if (this.prefSize == null) {
            Insets insets = this.getInsets();
            this.prefSize = new Dimension(insets.left + insets.top, insets.right + insets.bottom);
            int n = this.getColumnCount();
            int n2 = this.getRowCount();
            for (int i = 0; i < n; ++i) {
                int n3 = 0;
                for (int j = 0; j < n2; ++j) {
                    TableCellRenderer tableCellRenderer = this.getCellRenderer(j, i);
                    Component component = this.prepareRenderer(tableCellRenderer, j, i);
                    n3 = Math.max(component.getPreferredSize().width, n3);
                }
                this.prefSize.width += n3;
                this.getColumnModel().getColumn(i).setPreferredWidth(n3);
            }
            this.prefSize.height += n2 * this.getRowHeight();
        }
        return this.prefSize;
    }

    private final TabListPopupTableModel getTTModel() {
        return (TabListPopupTableModel)this.getModel();
    }

    public void detach() {
        this.displayer = null;
        this.getTTModel().detach();
    }

    public void addNotify() {
        AWTEvent aWTEvent;
        super.addNotify();
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
        if (this.getRowCount() > 0 && this.getColumnCount() > 0) {
            this.changeSelection(-1, -1, false, false);
        }
        if ((aWTEvent = EventQueue.getCurrentEvent()) != null && aWTEvent.getSource() instanceof Component) {
            this.invokingComponent = (Component)aWTEvent.getSource();
        }
        if (this.invokingComponent != null) {
            this.invokingComponent.addMouseListener(this);
            this.invokingComponent.addMouseMotionListener(this);
        }
        this.invocationTime = System.currentTimeMillis();
    }

    public void removeNotify() {
        super.removeNotify();
        this.removeMouseListener(this);
        this.removeMouseMotionListener(this);
        if (this.invokingComponent != null) {
            this.invokingComponent.removeMouseListener(this);
            this.invokingComponent.removeMouseMotionListener(this);
            this.invokingComponent = null;
        }
        this.detach();
    }

    public void paint(Graphics graphics) {
        if (this.needCalcRowHeight) {
            this.calcRowHeight(graphics);
        }
        super.paint(graphics);
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mousePressed(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this);
        if (this.contains(point)) {
            int n = this.getSelectedRow();
            int n2 = this.getSelectedColumn();
            this.setSelectedTab(n, n2);
            TabListPopup.hideCurrentPopup();
        }
        mouseEvent.consume();
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        long l;
        if (mouseEvent.getSource() == this.invokingComponent && (l = System.currentTimeMillis()) - this.invocationTime > 500L) {
            this.mousePressed(mouseEvent);
        }
        mouseEvent.consume();
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        mouseEvent.consume();
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.clearSelection();
        mouseEvent.consume();
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseMoved(mouseEvent);
        mouseEvent.consume();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        Point point = mouseEvent.getPoint();
        if (mouseEvent.getSource() != this) {
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this);
        }
        if (this.contains(point)) {
            int n = this.rowAtPoint(point);
            int n2 = this.columnAtPoint(point);
            this.changeSelection(n, n2, false, false);
        } else {
            this.clearSelection();
        }
        mouseEvent.consume();
    }

    public static synchronized void invoke(TabDisplayer tabDisplayer, int n, int n2) {
        if (currentPopup != null) {
            TabListPopup.hideCurrentPopup();
            return;
        }
        if (tabDisplayer.getModel().size() == 0) {
            return;
        }
        TabListPopup tabListPopup = TabListPopup.sharedInstance();
        tabListPopup.attach(tabDisplayer);
        TabListPopup.maybeHackPopupForAqua();
        currentPopup = PopupFactory.getSharedInstance().getPopup(tabDisplayer, tabListPopup, n - tabListPopup.getPreferredSize().width, n2);
        currentPopup.show();
        blistener = new BackupListener(tabListPopup);
    }

    public static synchronized void hideCurrentPopup() {
        if (currentPopup != null) {
            SwingUtilities.invokeLater(new PopupHider(currentPopup));
            currentPopup = null;
        }
        if (blistener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(blistener);
        }
    }

    private static TabListPopup sharedInstance() {
        TabListPopup tabListPopup = null;
        if (instance != null) {
            tabListPopup = (TabListPopup)instance.get();
        }
        if (tabListPopup == null) {
            tabListPopup = new TabListPopup();
            instance = new SoftReference<TabListPopup>(tabListPopup);
        }
        return tabListPopup;
    }

    private static void maybeHackPopupForAqua() {
        try {
            String string = System.getProperty("os.name");
            if ("Mac OS X".equals(string) || string.startsWith("Darwin")) {
                Field field = PopupFactory.class.getDeclaredField("popupType");
                field.setAccessible(true);
                field.set(PopupFactory.getSharedInstance(), new Integer(2));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private static class PopupHider
    implements Runnable {
        private Popup toHide;

        public PopupHider(Popup popup) {
            this.toHide = popup;
        }

        public void run() {
            this.toHide.hide();
        }
    }

    private static class BackupListener
    implements AWTEventListener {
        private TabListPopup tt;

        public BackupListener(TabListPopup tabListPopup) {
            this.tt = tabListPopup;
            Toolkit.getDefaultToolkit().addAWTEventListener(this, 24L);
        }

        private boolean onTabTable(MouseEvent mouseEvent) {
            Point point = mouseEvent.getPoint();
            point = SwingUtilities.convertPoint((Component)mouseEvent.getSource(), point, this.tt);
            return this.tt.contains(point);
        }

        public void eventDispatched(AWTEvent aWTEvent) {
            if (aWTEvent.getSource() == this.tt) {
                return;
            }
            if (aWTEvent instanceof MouseEvent) {
                if (aWTEvent.getID() == 502) {
                    long l = System.currentTimeMillis();
                    if (l - this.tt.invocationTime > 500L && !this.onTabTable((MouseEvent)aWTEvent)) {
                        Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                        TabListPopup.hideCurrentPopup();
                    }
                } else if (aWTEvent.getID() == 501 && !this.onTabTable((MouseEvent)aWTEvent) && aWTEvent.getSource() != this.tt.invokingComponent) {
                    Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                    TabListPopup.hideCurrentPopup();
                }
            } else if (aWTEvent instanceof KeyEvent && aWTEvent.getID() == 401) {
                Toolkit.getDefaultToolkit().removeAWTEventListener(this);
                TabListPopup.hideCurrentPopup();
            }
        }
    }
}

