/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.swing.plaf;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.URL;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.LookAndFeel;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.metal.MetalLookAndFeel;
import org.netbeans.swing.plaf.AllLFCustoms;
import org.netbeans.swing.plaf.LFCustoms;
import org.netbeans.swing.plaf.util.NbTheme;
import org.netbeans.swing.plaf.util.UIUtils;

public final class Startup {
    private static final String FORCED_CUSTOMS = System.getProperty("nb.forceui");
    private static final boolean NO_CUSTOMIZATIONS = Boolean.getBoolean("netbeans.plaf.disable.ui.customizations");
    private static Startup instance = null;
    private LFCustoms curCustoms = null;
    private LFCustoms globalCustoms = null;
    private static URL themeURL = null;
    private static Class uiClass = null;
    private boolean installed = false;
    private LFListener listener = null;

    private Startup() {
        this.initialize();
    }

    private void initialize() {
        LookAndFeel lookAndFeel = this.getLookAndFeel();
        if (lookAndFeel instanceof MetalLookAndFeel) {
            this.installTheme(lookAndFeel);
        }
        UIManager.put("Nb.MetalLFCustoms", new UIDefaults.ProxyLazyValue("org.netbeans.swing.plaf.metal.MetalLFCustoms"));
        UIManager.put("Nb.WindowsLFCustoms", new UIDefaults.ProxyLazyValue("org.netbeans.swing.plaf.winclassic.WindowsLFCustoms"));
        UIManager.put("Nb.WindowsXPLFCustoms", new UIDefaults.ProxyLazyValue("org.netbeans.swing.plaf.winxp.XPLFCustoms"));
        UIManager.put("Nb.AquaLFCustoms", new UIDefaults.ProxyLazyValue("org.netbeans.swing.plaf.aqua.AquaLFCustoms"));
        UIManager.put("Nb.GTKLFCustoms", new UIDefaults.ProxyLazyValue("org.netbeans.swing.plaf.gtk.GtkLFCustoms"));
        try {
            if (lookAndFeel != UIManager.getLookAndFeel()) {
                UIManager.setLookAndFeel(lookAndFeel);
            }
        }
        catch (Exception exception) {
            System.err.println("Could not install look and feel " + lookAndFeel);
        }
    }

    private LookAndFeel getLookAndFeel() {
        Object object;
        if (uiClass == null) {
            if (this.isWindows()) {
                object = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
            } else if (this.isMac()) {
                object = "apple.laf.AquaLookAndFeel";
            } else if (this.shouldUseMetal()) {
                object = "javax.swing.plaf.metal.MetalLookAndFeel";
            } else {
                object = UIManager.getSystemLookAndFeelClassName();
                if (((String)object).indexOf("gtk") >= 0 && !Boolean.getBoolean("useGtk")) {
                    object = "javax.swing.plaf.metal.MetalLookAndFeel";
                }
            }
            try {
                uiClass = Class.forName((String)object);
            }
            catch (Exception exception) {
                System.out.println("Custom ui class " + (String)object + " not on classpath.");
            }
        }
        object = null;
        if (uiClass != null) {
            try {
                LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
                if (uiClass != lookAndFeel.getClass()) {
                    object = (LookAndFeel)uiClass.newInstance();
                    UIManager.setLookAndFeel(lookAndFeel);
                } else {
                    object = UIManager.getLookAndFeel();
                }
            }
            catch (Exception exception) {
                System.out.println("Cannot load custom ui  " + uiClass);
                object = UIManager.getLookAndFeel();
            }
        }
        return object;
    }

    private void installTheme(LookAndFeel lookAndFeel) {
        if (themeURL != null) {
            NbTheme nbTheme = new NbTheme();
            MetalLookAndFeel.setCurrentTheme(nbTheme);
        }
    }

    private void install() {
        if (this.installed) {
            return;
        }
        this.globalCustoms = new AllLFCustoms();
        this.installLFCustoms(new AllLFCustoms());
        this.installPerLFDefaults();
        LookAndFeel lookAndFeel = UIManager.getLookAndFeel();
        if (!(lookAndFeel instanceof MetalLookAndFeel)) {
            this.installTheme(UIManager.getLookAndFeel());
        }
        this.attachListener();
    }

    private void installPerLFDefaults() {
        this.curCustoms = this.findCustoms();
        if (this.curCustoms != null) {
            this.installLFCustoms(this.curCustoms);
            this.curCustoms.disposeValues();
            Integer n = (Integer)UIManager.get("customFontSize");
            if (n == null && UIManager.getLookAndFeel().getClass() == MetalLookAndFeel.class) {
                n = new Integer(11);
            }
            if (n != null) {
                AllLFCustoms.initCustomFontSize(n);
            }
        }
    }

    private void uninstallPerLFDefaults() {
        if (this.curCustoms != null) {
            HashSet<Object> hashSet = new HashSet<Object>(Arrays.asList(this.globalCustoms.allKeys()));
            Object[] objectArray = this.curCustoms.allKeys();
            for (int i = 0; i < objectArray.length; ++i) {
                Object object = objectArray[i];
                if (hashSet.contains(object)) continue;
                UIManager.put(object, null);
            }
        }
        this.curCustoms = null;
    }

    private void attachListener() {
        this.listener = new LFListener();
        UIManager.addPropertyChangeListener(this.listener);
    }

    private void installLFCustoms(LFCustoms lFCustoms) {
        UIDefaults uIDefaults = UIManager.getDefaults();
        uIDefaults.putDefaults(lFCustoms.getGuaranteedKeysAndValues());
        uIDefaults.putDefaults(lFCustoms.getApplicationSpecificKeysAndValues());
        if (!NO_CUSTOMIZATIONS) {
            uIDefaults.putDefaults(lFCustoms.getLookAndFeelCustomizationKeysAndValues());
        }
    }

    private LFCustoms findCustoms() {
        StringBuffer stringBuffer = new StringBuffer(40);
        stringBuffer.append("Nb.");
        if (FORCED_CUSTOMS != null) {
            System.err.println("Using explicitly set UI customizations: " + FORCED_CUSTOMS);
            stringBuffer.append(FORCED_CUSTOMS);
        } else {
            stringBuffer.append(UIManager.getLookAndFeel().getID());
            if (UIUtils.isXPLF()) {
                stringBuffer.append("XPLFCustoms");
            } else {
                stringBuffer.append("LFCustoms");
            }
        }
        LFCustoms lFCustoms = (LFCustoms)UIManager.get(stringBuffer.toString());
        return lFCustoms;
    }

    public static void run(Class clazz, int n, URL uRL) {
        if (instance == null) {
            if (n > 0) {
                Integer n2 = new Integer(n);
                UIManager.put("customFontSize", n2);
            }
            uiClass = clazz;
            themeURL = uRL;
            instance = new Startup();
            instance.install();
        }
    }

    private boolean isWindows() {
        String string = System.getProperty("os.name");
        return string.startsWith("Windows");
    }

    private boolean isMac() {
        String string = System.getProperty("os.name");
        boolean bl = string.startsWith("Darwin") || "Mac OS X".equals(string);
        return bl;
    }

    private boolean shouldUseMetal() {
        String string = System.getProperty("os.name");
        boolean bl = !"Solaris".equals(string) && !string.startsWith("SunOS") && !string.endsWith("Linux") || UIManager.getSystemLookAndFeelClassName().indexOf("Motif") > -1;
        return bl;
    }

    private class LFListener
    implements PropertyChangeListener {
        private LFListener() {
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if ("lookAndFeel".equals(propertyChangeEvent.getPropertyName())) {
                System.err.println("\n\n\nLOOK AND FEEL CHANGED!\n\n");
                Thread.dumpStack();
                Startup.this.uninstallPerLFDefaults();
                Startup.this.installPerLFDefaults();
            } else {
                System.err.println("Look and feel property change: " + propertyChangeEvent.getPropertyName() + " old " + propertyChangeEvent.getOldValue() + " new " + propertyChangeEvent.getNewValue());
            }
        }
    }
}

