/*
 * Decompiled with CFR 0.152.
 */
package org.jaxen.saxpath.helpers;

import org.jaxen.saxpath.SAXPathException;
import org.jaxen.saxpath.XPathReader;

public class XPathReaderFactory {
    public static XPathReader createReader() throws SAXPathException {
        String string = null;
        try {
            string = System.getProperty("org.saxpath.driver");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (string == null || string.length() == 0) {
            string = "org.jaxen.saxpath.base.XPathReader";
        }
        return XPathReaderFactory.createReader(string);
    }

    public static XPathReader createReader(String string) throws SAXPathException {
        Class<?> clazz = null;
        XPathReader xPathReader = null;
        try {
            clazz = Class.forName(string, true, XPathReaderFactory.class.getClassLoader());
            if (!XPathReader.class.isAssignableFrom(clazz)) {
                throw new SAXPathException("Class [" + string + "] does not implement the org.jaxen.saxpath.XPathReader interface.");
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new SAXPathException(classNotFoundException);
        }
        try {
            xPathReader = (XPathReader)clazz.newInstance();
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new SAXPathException(illegalAccessException);
        }
        catch (InstantiationException instantiationException) {
            throw new SAXPathException(instantiationException);
        }
        if (xPathReader == null) {
            throw new SAXPathException("Unable to create XPathReader");
        }
        return xPathReader;
    }
}

