/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.zip;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.provider.zip.ZipFileObject;
import org.apache.commons.vfs.provider.zip.ZipFileProvider;

public class ZipFileSystem
extends AbstractFileSystem
implements FileSystem {
    private static final Log log = LogFactory.getLog(ZipFileSystem.class);
    private final File file;
    private ZipFile zipFile;

    public ZipFileSystem(FileName fileName, FileObject fileObject, FileSystemOptions fileSystemOptions) throws FileSystemException {
        super(fileName, fileObject, fileSystemOptions);
        this.file = fileObject.getFileSystem().replicateFile(fileObject, Selectors.SELECT_SELF);
        if (!this.file.exists()) {
            this.zipFile = null;
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws FileSystemException {
        super.init();
        try {
            ArrayList<ZipFileObject> arrayList = new ArrayList<ZipFileObject>(100);
            Enumeration<? extends ZipEntry> enumeration = this.getZipFile().entries();
            while (enumeration.hasMoreElements()) {
                ZipFileObject zipFileObject;
                ZipEntry zipEntry = enumeration.nextElement();
                FileName fileName = this.getFileSystemManager().resolveName(this.getRootName(), UriParser.encode(zipEntry.getName()));
                if (zipEntry.isDirectory() && this.getFileFromCache(fileName) != null) {
                    zipFileObject = (ZipFileObject)this.getFileFromCache(fileName);
                    zipFileObject.setZipEntry(zipEntry);
                    continue;
                }
                zipFileObject = this.createZipFileObject(fileName, zipEntry);
                this.putFileToCache(zipFileObject);
                arrayList.add(zipFileObject);
                zipFileObject.holdObject(arrayList);
                ZipFileObject zipFileObject2 = null;
                for (FileName fileName2 = fileName.getParent(); fileName2 != null; fileName2 = fileName2.getParent()) {
                    zipFileObject2 = (ZipFileObject)this.getFileFromCache(fileName2);
                    if (zipFileObject2 == null) {
                        zipFileObject2 = this.createZipFileObject(fileName2, null);
                        this.putFileToCache(zipFileObject2);
                        arrayList.add(zipFileObject2);
                        zipFileObject2.holdObject(arrayList);
                    }
                    zipFileObject2.attachChild(zipFileObject.getName());
                    zipFileObject = zipFileObject2;
                }
            }
        }
        finally {
            this.closeCommunicationLink();
        }
    }

    protected ZipFile getZipFile() throws FileSystemException {
        if (this.zipFile == null && this.file.exists()) {
            ZipFile zipFile;
            this.zipFile = zipFile = this.createZipFile(this.file);
        }
        return this.zipFile;
    }

    protected ZipFileObject createZipFileObject(FileName fileName, ZipEntry zipEntry) throws FileSystemException {
        return new ZipFileObject(fileName, zipEntry, this, true);
    }

    protected ZipFile createZipFile(File file) throws FileSystemException {
        try {
            return new ZipFile(file);
        }
        catch (IOException iOException) {
            throw new FileSystemException("vfs.provider.zip/open-zip-file.error", file, (Throwable)iOException);
        }
    }

    protected void doCloseCommunicationLink() {
        try {
            if (this.zipFile != null) {
                this.zipFile.close();
                this.zipFile = null;
            }
        }
        catch (IOException iOException) {
            VfsLog.warn(this.getLogger(), log, "vfs.provider.zip/close-zip-file.error :" + this.file, iOException);
        }
    }

    protected void addCapabilities(Collection collection) {
        collection.addAll(ZipFileProvider.capabilities);
    }

    protected FileObject createFile(FileName fileName) throws FileSystemException {
        return new ZipFileObject(fileName, null, this, false);
    }
}

