/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import org.apache.commons.httpclient.Cookie;
import org.apache.commons.vfs.FileSystemConfigBuilder;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.provider.http.HttpFileSystem;

public class HttpFileSystemConfigBuilder
extends FileSystemConfigBuilder {
    private static final HttpFileSystemConfigBuilder builder = new HttpFileSystemConfigBuilder();

    public static HttpFileSystemConfigBuilder getInstance() {
        return builder;
    }

    private HttpFileSystemConfigBuilder() {
    }

    public void setUrlCharset(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "urlCharset", string);
    }

    public String getUrlCharset(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, "urlCharset");
    }

    public void setProxyHost(FileSystemOptions fileSystemOptions, String string) {
        this.setParam(fileSystemOptions, "proxyHost", string);
    }

    public void setProxyPort(FileSystemOptions fileSystemOptions, int n) {
        this.setParam(fileSystemOptions, "proxyPort", new Integer(n));
    }

    public String getProxyHost(FileSystemOptions fileSystemOptions) {
        return (String)this.getParam(fileSystemOptions, "proxyHost");
    }

    public int getProxyPort(FileSystemOptions fileSystemOptions) {
        if (!this.hasParam(fileSystemOptions, "proxyPort")) {
            return 0;
        }
        return ((Number)this.getParam(fileSystemOptions, "proxyPort")).intValue();
    }

    public void setProxyAuthenticator(FileSystemOptions fileSystemOptions, UserAuthenticator userAuthenticator) {
        this.setParam(fileSystemOptions, "proxyAuthenticator", userAuthenticator);
    }

    public UserAuthenticator getProxyAuthenticator(FileSystemOptions fileSystemOptions) {
        return (UserAuthenticator)this.getParam(fileSystemOptions, "proxyAuthenticator");
    }

    public void setCookies(FileSystemOptions fileSystemOptions, Cookie[] cookieArray) {
        this.setParam(fileSystemOptions, "cookies", cookieArray);
    }

    public Cookie[] getCookies(FileSystemOptions fileSystemOptions) {
        return (Cookie[])this.getParam(fileSystemOptions, "cookies");
    }

    protected Class getConfigClass() {
        return HttpFileSystem.class;
    }
}

