/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider.http;

import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;
import org.apache.commons.httpclient.util.DateParser;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.provider.AbstractFileObject;
import org.apache.commons.vfs.provider.URLFileName;
import org.apache.commons.vfs.provider.http.HttpFileContentInfoFactory;
import org.apache.commons.vfs.provider.http.HttpFileSystem;
import org.apache.commons.vfs.provider.http.HttpFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.http.HttpRandomAccesContent;
import org.apache.commons.vfs.util.MonitorInputStream;
import org.apache.commons.vfs.util.RandomAccessMode;

public class HttpFileObject
extends AbstractFileObject {
    private final HttpFileSystem fileSystem;
    private final String urlCharset;
    private HeadMethod method;

    protected HttpFileObject(FileName fileName, HttpFileSystem httpFileSystem) {
        super(fileName, httpFileSystem);
        this.fileSystem = httpFileSystem;
        this.urlCharset = HttpFileSystemConfigBuilder.getInstance().getUrlCharset(this.getFileSystem().getFileSystemOptions());
    }

    protected void doDetach() throws Exception {
        this.method = null;
    }

    protected FileType doGetType() throws Exception {
        this.method = new HeadMethod();
        this.setupMethod((HttpMethod)this.method);
        HttpClient httpClient = this.fileSystem.getClient();
        int n = httpClient.executeMethod((HttpMethod)this.method);
        this.method.releaseConnection();
        if (n == 200) {
            return FileType.FILE;
        }
        if (n == 404 || n == 410) {
            return FileType.IMAGINARY;
        }
        throw new FileSystemException("vfs.provider.http/head.error", this.getName());
    }

    protected String[] doListChildren() throws Exception {
        throw new Exception("Not implemented.");
    }

    protected long doGetContentSize() throws Exception {
        Header header = this.method.getResponseHeader("content-length");
        if (header == null) {
            return 0L;
        }
        return Integer.parseInt(header.getValue());
    }

    protected long doGetLastModifiedTime() throws Exception {
        Header header = this.method.getResponseHeader("last-modified");
        if (header == null) {
            throw new FileSystemException("vfs.provider.http/last-modified.error", this.getName());
        }
        return DateParser.parseDate((String)header.getValue()).getTime();
    }

    protected InputStream doGetInputStream() throws Exception {
        GetMethod getMethod = new GetMethod();
        this.setupMethod((HttpMethod)getMethod);
        int n = this.fileSystem.getClient().executeMethod((HttpMethod)getMethod);
        if (n != 200) {
            throw new FileSystemException("vfs.provider.http/get.error", this.getName());
        }
        return new HttpInputStream(getMethod);
    }

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        return new HttpRandomAccesContent(this, randomAccessMode);
    }

    void setupMethod(HttpMethod httpMethod) throws FileSystemException, URIException {
        String string = ((URLFileName)this.getName()).getPathQueryEncoded(this.urlCharset);
        httpMethod.setPath(string);
        httpMethod.setFollowRedirects(true);
        httpMethod.setRequestHeader("User-Agent", "Jakarta-Commons-VFS");
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return new HttpFileContentInfoFactory();
    }

    HeadMethod getHeadMethod() {
        return this.method;
    }

    static class HttpInputStream
    extends MonitorInputStream {
        private final GetMethod method;

        public HttpInputStream(GetMethod getMethod) throws IOException {
            super(getMethod.getResponseBodyAsStream());
            this.method = getMethod;
        }

        protected void onClose() throws IOException {
            this.method.releaseConnection();
        }
    }
}

