/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.provider;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.vfs.Capability;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileContentInfoFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.FileUtil;
import org.apache.commons.vfs.NameScope;
import org.apache.commons.vfs.RandomAccessContent;
import org.apache.commons.vfs.Selectors;
import org.apache.commons.vfs.operations.DefaultFileOperations;
import org.apache.commons.vfs.operations.FileOperations;
import org.apache.commons.vfs.provider.AbstractFileName;
import org.apache.commons.vfs.provider.AbstractFileSystem;
import org.apache.commons.vfs.provider.DefaultFileContent;
import org.apache.commons.vfs.provider.DefaultFileSelectorInfo;
import org.apache.commons.vfs.provider.DefaultURLStreamHandler;
import org.apache.commons.vfs.provider.UriParser;
import org.apache.commons.vfs.util.FileObjectUtils;
import org.apache.commons.vfs.util.RandomAccessMode;

public abstract class AbstractFileObject
implements FileObject {
    private static final FileName[] EMPTY_FILE_ARRAY = new FileName[0];
    private final AbstractFileName name;
    private final AbstractFileSystem fs;
    private DefaultFileContent content;
    private boolean attached;
    private FileType type;
    private FileObject parent;
    private FileName[] children;
    private List objects;
    private FileOperations operations;

    protected AbstractFileObject(FileName fileName, AbstractFileSystem abstractFileSystem) {
        this.name = (AbstractFileName)fileName;
        this.fs = abstractFileSystem;
        abstractFileSystem.fileObjectHanded(this);
    }

    protected void doAttach() throws Exception {
    }

    protected void doDetach() throws Exception {
    }

    protected abstract FileType doGetType() throws Exception;

    protected boolean doIsHidden() throws Exception {
        return false;
    }

    protected boolean doIsReadable() throws Exception {
        return true;
    }

    protected boolean doIsWriteable() throws Exception {
        return true;
    }

    protected abstract String[] doListChildren() throws Exception;

    protected FileObject[] doListChildrenResolved() throws Exception {
        return null;
    }

    protected void doDelete() throws Exception {
        throw new FileSystemException("vfs.provider/delete-not-supported.error");
    }

    protected void doRename(FileObject fileObject) throws Exception {
        throw new FileSystemException("vfs.provider/rename-not-supported.error");
    }

    protected void doCreateFolder() throws Exception {
        throw new FileSystemException("vfs.provider/create-folder-not-supported.error");
    }

    protected void onChildrenChanged(FileName fileName, FileType fileType) throws Exception {
    }

    protected void onChange() throws Exception {
    }

    protected long doGetLastModifiedTime() throws Exception {
        throw new FileSystemException("vfs.provider/get-last-modified-not-supported.error");
    }

    protected void doSetLastModifiedTime(long l) throws Exception {
        throw new FileSystemException("vfs.provider/set-last-modified-not-supported.error");
    }

    protected Map doGetAttributes() throws Exception {
        return Collections.EMPTY_MAP;
    }

    protected void doSetAttribute(String string, Object object) throws Exception {
        throw new FileSystemException("vfs.provider/set-attribute-not-supported.error");
    }

    protected Certificate[] doGetCertificates() throws Exception {
        return null;
    }

    protected abstract long doGetContentSize() throws Exception;

    protected abstract InputStream doGetInputStream() throws Exception;

    protected RandomAccessContent doGetRandomAccessContent(RandomAccessMode randomAccessMode) throws Exception {
        throw new FileSystemException("vfs.provider/random-access-not-supported.error");
    }

    protected OutputStream doGetOutputStream(boolean bl) throws Exception {
        throw new FileSystemException("vfs.provider/write-not-supported.error");
    }

    public String toString() {
        return this.name.getURI();
    }

    public FileName getName() {
        return this.name;
    }

    public FileSystem getFileSystem() {
        return this.fs;
    }

    public URL getURL() throws FileSystemException {
        final StringBuffer stringBuffer = new StringBuffer();
        try {
            return (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws MalformedURLException {
                    return new URL(UriParser.extractScheme(AbstractFileObject.this.name.getURI(), stringBuffer), "", -1, stringBuffer.toString(), new DefaultURLStreamHandler(AbstractFileObject.this.fs.getContext(), AbstractFileObject.this.fs.getFileSystemOptions()));
                }
            });
        }
        catch (PrivilegedActionException privilegedActionException) {
            throw new FileSystemException("vfs.provider/get-url.error", this.name, (Throwable)privilegedActionException.getException());
        }
    }

    public boolean exists() throws FileSystemException {
        return this.getType() != FileType.IMAGINARY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileType getType() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            this.attach();
            return this.type;
        }
    }

    public boolean isHidden() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsHidden();
            }
            return false;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/check-is-hidden.error", this.name, (Throwable)exception);
        }
    }

    public boolean isReadable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsReadable();
            }
            return false;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/check-is-readable.error", this.name, (Throwable)exception);
        }
    }

    public boolean isWriteable() throws FileSystemException {
        try {
            if (this.exists()) {
                return this.doIsWriteable();
            }
            FileObject fileObject = this.getParent();
            if (fileObject != null) {
                return fileObject.isWriteable();
            }
            return true;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/check-is-writeable.error", this.name, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getParent() throws FileSystemException {
        if (this == this.fs.getRoot()) {
            if (this.fs.getParentLayer() != null) {
                return this.fs.getParentLayer().getParent();
            }
            return null;
        }
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.parent == null) {
                this.parent = this.fs.resolveFile(this.name.getParent());
            }
        }
        return this.parent;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject[] getChildren() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            String[] stringArray;
            FileObject[] fileObjectArray;
            if (!this.getType().hasChildren()) {
                throw new FileSystemException("vfs.provider/list-children-not-folder.error", this.name);
            }
            if (this.children != null) {
                return this.resolveFiles(this.children);
            }
            try {
                fileObjectArray = this.doListChildrenResolved();
                this.children = this.extractNames(fileObjectArray);
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exception);
            }
            if (fileObjectArray != null) {
                return fileObjectArray;
            }
            try {
                stringArray = this.doListChildren();
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/list-children.error", new Object[]{this.name}, (Throwable)exception);
            }
            if (stringArray == null) {
                return null;
            }
            if (stringArray.length == 0) {
                this.children = EMPTY_FILE_ARRAY;
            } else {
                this.children = new FileName[stringArray.length];
                for (int i = 0; i < stringArray.length; ++i) {
                    String string = stringArray[i];
                    this.children[i] = this.getFileSystem().getFileSystemManager().resolveName(this.name, string, NameScope.CHILD);
                }
            }
            return this.resolveFiles(this.children);
        }
    }

    private FileName[] extractNames(FileObject[] fileObjectArray) {
        if (fileObjectArray == null) {
            return null;
        }
        FileName[] fileNameArray = new FileName[fileObjectArray.length];
        for (int i = 0; i < fileObjectArray.length; ++i) {
            fileNameArray[i] = fileObjectArray[i].getName();
        }
        return fileNameArray;
    }

    private FileObject[] resolveFiles(FileName[] fileNameArray) throws FileSystemException {
        if (fileNameArray == null) {
            return null;
        }
        FileObject[] fileObjectArray = new FileObject[fileNameArray.length];
        for (int i = 0; i < fileNameArray.length; ++i) {
            fileObjectArray[i] = this.resolveFile(fileNameArray[i]);
        }
        return fileObjectArray;
    }

    private FileObject resolveFile(FileName fileName) throws FileSystemException {
        return this.fs.resolveFile(fileName);
    }

    public FileObject getChild(String string) throws FileSystemException {
        FileObject[] fileObjectArray = this.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            FileName fileName = fileObjectArray[i].getName();
            if (!fileName.getBaseName().equals(string)) continue;
            return this.resolveFile(fileName);
        }
        return null;
    }

    public FileObject resolveFile(String string, NameScope nameScope) throws FileSystemException {
        return this.fs.resolveFile(this.getFileSystem().getFileSystemManager().resolveName(this.name, string, nameScope));
    }

    public FileObject resolveFile(String string) throws FileSystemException {
        FileName fileName = this.getFileSystem().getFileSystemManager().resolveName(this.name, string);
        return this.fs.resolveFile(fileName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean deleteSelf() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.getType() == FileType.IMAGINARY) {
                return false;
            }
            try {
                this.doDelete();
                this.handleDelete();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/delete.error", new Object[]{this.name}, (Throwable)exception);
            }
            return true;
        }
    }

    public boolean delete() throws FileSystemException {
        return this.delete(Selectors.SELECT_SELF) > 0;
    }

    public int delete(FileSelector fileSelector) throws FileSystemException {
        int n = 0;
        if (this.getType() == FileType.IMAGINARY) {
            return n;
        }
        ArrayList arrayList = new ArrayList();
        this.findFiles(fileSelector, true, arrayList);
        int n2 = arrayList.size();
        for (int i = 0; i < n2; ++i) {
            boolean bl;
            AbstractFileObject abstractFileObject = FileObjectUtils.getAbstractFileObject((FileObject)arrayList.get(i));
            if (abstractFileObject.getType().hasChildren() && abstractFileObject.getChildren().length != 0 || !(bl = abstractFileObject.deleteSelf())) continue;
            ++n;
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFile() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            try {
                if (this.exists() && !FileType.FILE.equals(this.getType())) {
                    throw new FileSystemException("vfs.provider/create-file.error", this.name);
                }
                if (!this.exists()) {
                    this.getOutputStream().close();
                    this.endOutput();
                }
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/create-file.error", this.name, (Throwable)exception);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createFolder() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.getType().hasChildren()) {
                return;
            }
            if (this.getType() != FileType.IMAGINARY) {
                throw new FileSystemException("vfs.provider/create-folder-mismatched-type.error", this.name);
            }
            if (!this.isWriteable()) {
                throw new FileSystemException("vfs.provider/create-folder-read-only.error", this.name);
            }
            FileObject fileObject = this.getParent();
            if (fileObject != null) {
                fileObject.createFolder();
            }
            try {
                this.doCreateFolder();
                this.handleCreate(FileType.FOLDER);
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/create-folder.error", this.name, (Throwable)exception);
            }
        }
    }

    public void copyFrom(FileObject fileObject, FileSelector fileSelector) throws FileSystemException {
        if (!fileObject.exists()) {
            throw new FileSystemException("vfs.provider/copy-missing-file.error", fileObject);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/copy-read-only.error", new Object[]{fileObject.getType(), fileObject.getName(), this}, null);
        }
        ArrayList arrayList = new ArrayList();
        fileObject.findFiles(fileSelector, false, arrayList);
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            FileObject fileObject2 = (FileObject)arrayList.get(i);
            String string = fileObject.getName().getRelativeName(fileObject2.getName());
            FileObject fileObject3 = this.resolveFile(string, NameScope.DESCENDENT_OR_SELF);
            if (fileObject3.exists() && fileObject3.getType() != fileObject2.getType()) {
                fileObject3.delete(Selectors.SELECT_ALL);
            }
            try {
                if (fileObject2.getType().hasContent()) {
                    FileUtil.copyContent(fileObject2, fileObject3);
                    continue;
                }
                if (!fileObject2.getType().hasChildren()) continue;
                fileObject3.createFolder();
                continue;
            }
            catch (IOException iOException) {
                throw new FileSystemException("vfs.provider/copy-file.error", new Object[]{fileObject2, fileObject3}, (Throwable)iOException);
            }
        }
    }

    public void moveTo(FileObject fileObject) throws FileSystemException {
        if (this.canRenameTo(fileObject)) {
            if (!this.getParent().isWriteable()) {
                throw new FileSystemException("vfs.provider/rename-parent-read-only.error", new FileName[]{this.getName(), this.getParent().getName()});
            }
        } else if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/rename-read-only.error", this.getName());
        }
        if (fileObject.exists() && !this.isSameFile(fileObject)) {
            fileObject.delete(Selectors.SELECT_ALL);
        }
        if (this.canRenameTo(fileObject)) {
            try {
                this.attach();
                this.doRename(fileObject);
                FileObjectUtils.getAbstractFileObject(fileObject).handleCreate(this.getType());
                fileObject.close();
                this.handleDelete();
            }
            catch (RuntimeException runtimeException) {
                throw runtimeException;
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/rename.error", new Object[]{this.getName(), fileObject.getName()}, (Throwable)exception);
            }
        } else {
            fileObject.copyFrom(this, Selectors.SELECT_SELF);
            if ((fileObject.getType().hasContent() && fileObject.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FILE) || fileObject.getType().hasChildren() && fileObject.getFileSystem().hasCapability(Capability.SET_LAST_MODIFIED_FOLDER)) && this.getFileSystem().hasCapability(Capability.GET_LAST_MODIFIED)) {
                fileObject.getContent().setLastModifiedTime(this.getContent().getLastModifiedTime());
            }
            this.deleteSelf();
        }
    }

    protected boolean isSameFile(FileObject fileObject) throws FileSystemException {
        this.attach();
        return this.doIsSameFile(fileObject);
    }

    protected boolean doIsSameFile(FileObject fileObject) throws FileSystemException {
        return false;
    }

    public boolean canRenameTo(FileObject fileObject) {
        return this.getFileSystem() == fileObject.getFileSystem();
    }

    public FileObject[] findFiles(FileSelector fileSelector) throws FileSystemException {
        if (!this.exists()) {
            return null;
        }
        ArrayList arrayList = new ArrayList();
        this.findFiles(fileSelector, true, arrayList);
        return arrayList.toArray(new FileObject[arrayList.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileContent getContent() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            this.attach();
            if (this.content == null) {
                this.content = new DefaultFileContent(this, this.getFileContentInfoFactory());
            }
            return this.content;
        }
    }

    public void refresh() throws FileSystemException {
        try {
            this.detach();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/resync.error", this.name, (Throwable)exception);
        }
    }

    public void close() throws FileSystemException {
        FileSystemException fileSystemException = null;
        if (this.content != null) {
            try {
                this.content.close();
            }
            catch (FileSystemException fileSystemException2) {
                fileSystemException = fileSystemException2;
            }
        }
        try {
            this.detach();
        }
        catch (Exception exception) {
            fileSystemException = new FileSystemException("vfs.provider/close.error", this.name, (Throwable)exception);
        }
        if (fileSystemException != null) {
            throw fileSystemException;
        }
    }

    public InputStream getInputStream() throws FileSystemException {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.name);
        }
        if (!this.isReadable()) {
            throw new FileSystemException("vfs.provider/read-not-readable.error", this.name);
        }
        try {
            return this.doGetInputStream();
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/read.error", this.name, (Throwable)exception);
        }
    }

    public RandomAccessContent getRandomAccessContent(RandomAccessMode randomAccessMode) throws FileSystemException {
        if (!this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/read-not-file.error", this.name);
        }
        if (randomAccessMode.requestRead()) {
            if (!this.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_READ)) {
                throw new FileSystemException("vfs.provider/random-access-read-not-supported.error");
            }
            if (!this.isReadable()) {
                throw new FileSystemException("vfs.provider/read-not-readable.error", this.name);
            }
        }
        if (randomAccessMode.requestWrite()) {
            if (!this.getFileSystem().hasCapability(Capability.RANDOM_ACCESS_WRITE)) {
                throw new FileSystemException("vfs.provider/random-access-write-not-supported.error");
            }
            if (!this.isWriteable()) {
                throw new FileSystemException("vfs.provider/write-read-only.error", this.name);
            }
        }
        try {
            return this.doGetRandomAccessContent(randomAccessMode);
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/random-access.error", this.name, (Throwable)exception);
        }
    }

    public OutputStream getOutputStream() throws FileSystemException {
        return this.getOutputStream(false);
    }

    public OutputStream getOutputStream(boolean bl) throws FileSystemException {
        FileObject fileObject;
        if (this.getType() != FileType.IMAGINARY && !this.getType().hasContent()) {
            throw new FileSystemException("vfs.provider/write-not-file.error", this.name);
        }
        if (!this.isWriteable()) {
            throw new FileSystemException("vfs.provider/write-read-only.error", this.name);
        }
        if (bl && !this.getFileSystem().hasCapability(Capability.APPEND_CONTENT)) {
            throw new FileSystemException("vfs.provider/write-append-not-supported.error", this.name);
        }
        if (this.getType() == FileType.IMAGINARY && (fileObject = this.getParent()) != null) {
            fileObject.createFolder();
        }
        try {
            return this.doGetOutputStream(bl);
        }
        catch (RuntimeException runtimeException) {
            throw runtimeException;
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/write.error", new Object[]{this.name}, (Throwable)exception);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void detach() throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                try {
                    this.doDetach();
                }
                finally {
                    this.attached = false;
                    this.setFileType(null);
                    this.parent = null;
                    this.removeChildrenCache();
                }
            }
        }
    }

    private void removeChildrenCache() {
        this.children = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attach() throws FileSystemException {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                return;
            }
            try {
                this.doAttach();
                this.attached = true;
                if (this.type == null) {
                    this.setFileType(this.doGetType());
                }
                if (this.type == null) {
                    this.setFileType(FileType.IMAGINARY);
                }
            }
            catch (Exception exception) {
                throw new FileSystemException("vfs.provider/get-type.error", new Object[]{this.name}, (Throwable)exception);
            }
        }
    }

    protected void endOutput() throws Exception {
        if (this.getType() == FileType.IMAGINARY) {
            this.handleCreate(FileType.FILE);
        } else {
            this.onChange();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleCreate(FileType fileType) throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                this.injectType(fileType);
                this.removeChildrenCache();
                this.onChange();
            }
            this.notifyParent(this.getName(), fileType);
            this.fs.fireFileCreated(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void handleDelete() throws Exception {
        AbstractFileSystem abstractFileSystem = this.fs;
        synchronized (abstractFileSystem) {
            if (this.attached) {
                this.injectType(FileType.IMAGINARY);
                this.removeChildrenCache();
                this.onChange();
            }
            this.notifyParent(this.getName(), FileType.IMAGINARY);
            this.fs.fireFileDeleted(this);
        }
    }

    protected void handleChanged() throws Exception {
        this.fs.fireFileChanged(this);
    }

    protected void childrenChanged(FileName fileName, FileType fileType) throws Exception {
        if (this.children != null && fileName != null && fileType != null) {
            ArrayList<FileName> arrayList = new ArrayList<FileName>(Arrays.asList(this.children));
            if (fileType.equals(FileType.IMAGINARY)) {
                arrayList.remove(fileName);
            } else {
                arrayList.add(fileName);
            }
            this.children = new FileName[arrayList.size()];
            arrayList.toArray(this.children);
        }
        this.onChildrenChanged(fileName, fileType);
    }

    private void notifyParent(FileName fileName, FileType fileType) throws Exception {
        FileName fileName2;
        if (this.parent == null && (fileName2 = this.name.getParent()) != null) {
            this.parent = this.fs.getFileFromCache(fileName2);
        }
        if (this.parent != null) {
            FileObjectUtils.getAbstractFileObject(this.parent).childrenChanged(fileName, fileType);
        }
    }

    public void findFiles(FileSelector fileSelector, boolean bl, List list) throws FileSystemException {
        try {
            if (this.exists()) {
                DefaultFileSelectorInfo defaultFileSelectorInfo = new DefaultFileSelectorInfo();
                defaultFileSelectorInfo.setBaseFolder(this);
                defaultFileSelectorInfo.setDepth(0);
                defaultFileSelectorInfo.setFile(this);
                AbstractFileObject.traverse(defaultFileSelectorInfo, fileSelector, bl, list);
            }
        }
        catch (Exception exception) {
            throw new FileSystemException("vfs.provider/find-files.error", this.name, (Throwable)exception);
        }
    }

    private static void traverse(DefaultFileSelectorInfo defaultFileSelectorInfo, FileSelector fileSelector, boolean bl, List list) throws Exception {
        FileObject fileObject = defaultFileSelectorInfo.getFile();
        int n = list.size();
        if (fileObject.getType().hasChildren() && fileSelector.traverseDescendents(defaultFileSelectorInfo)) {
            int n2 = defaultFileSelectorInfo.getDepth();
            defaultFileSelectorInfo.setDepth(n2 + 1);
            FileObject[] fileObjectArray = fileObject.getChildren();
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FileObject fileObject2 = fileObjectArray[i];
                defaultFileSelectorInfo.setFile(fileObject2);
                AbstractFileObject.traverse(defaultFileSelectorInfo, fileSelector, bl, list);
            }
            defaultFileSelectorInfo.setFile(fileObject);
            defaultFileSelectorInfo.setDepth(n2);
        }
        if (fileSelector.includeFile(defaultFileSelectorInfo)) {
            if (bl) {
                list.add(fileObject);
            } else {
                list.add(n, fileObject);
            }
        }
    }

    public boolean isContentOpen() {
        if (this.content == null) {
            return false;
        }
        return this.content.isOpen();
    }

    public boolean isAttached() {
        return this.attached;
    }

    protected FileContentInfoFactory getFileContentInfoFactory() {
        return this.getFileSystem().getFileSystemManager().getFileContentInfoFactory();
    }

    protected void injectType(FileType fileType) {
        this.setFileType(fileType);
    }

    private void setFileType(FileType fileType) {
        if (fileType != null && fileType != FileType.IMAGINARY) {
            try {
                this.name.setType(fileType);
            }
            catch (FileSystemException fileSystemException) {
                throw new RuntimeException(fileSystemException.getMessage());
            }
        }
        this.type = fileType;
    }

    public void holdObject(Object object) {
        if (this.objects == null) {
            this.objects = new ArrayList(5);
        }
        this.objects.add(object);
    }

    protected void notifyAllStreamsClosed() {
    }

    public FileOperations getFileOperations() throws FileSystemException {
        if (this.operations == null) {
            this.operations = new DefaultFileOperations(this);
        }
        return this.operations;
    }

    protected void finalize() throws Throwable {
        this.fs.fileObjectDestroyed(this);
        super.finalize();
    }
}

