/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.vfs.cache;

import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections.map.AbstractLinkedMap;
import org.apache.commons.collections.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.commons.vfs.FileName;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystem;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.VfsLog;
import org.apache.commons.vfs.cache.AbstractFilesCache;
import org.apache.commons.vfs.util.Messages;

public class LRUFilesCache
extends AbstractFilesCache {
    private Log log = LogFactory.getLog(LRUFilesCache.class);
    private final Map filesystemCache = new HashMap(10);
    private final int lruSize;

    public LRUFilesCache() {
        this(100);
    }

    public LRUFilesCache(int n) {
        this.lruSize = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void putFile(FileObject fileObject) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map map = this.getOrCreateFilesystemCache(fileObject.getFileSystem());
            map.put(fileObject.getName(), fileObject);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FileObject getFile(FileSystem fileSystem, FileName fileName) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map map = this.getOrCreateFilesystemCache(fileSystem);
            return (FileObject)map.get(fileName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(FileSystem fileSystem) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map map = this.getOrCreateFilesystemCache(fileSystem);
            map.clear();
            this.filesystemCache.remove(fileSystem);
        }
    }

    protected Map getOrCreateFilesystemCache(FileSystem fileSystem) {
        Object object = (Map)this.filesystemCache.get(fileSystem);
        if (object == null) {
            object = new MyLRUMap(fileSystem, this.lruSize);
            this.filesystemCache.put(fileSystem, object);
        }
        return object;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        super.close();
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            this.filesystemCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFile(FileSystem fileSystem, FileName fileName) {
        LRUFilesCache lRUFilesCache = this;
        synchronized (lRUFilesCache) {
            Map map = this.getOrCreateFilesystemCache(fileSystem);
            map.remove(fileName);
            if (map.size() < 1) {
                this.filesystemCache.remove(fileSystem);
            }
        }
    }

    public void touchFile(FileObject fileObject) {
        this.getFile(fileObject.getFileSystem(), fileObject.getName());
    }

    private class MyLRUMap
    extends LRUMap {
        final FileSystem filesystem;

        public MyLRUMap(FileSystem fileSystem, int n) {
            super(n, true);
            this.filesystem = fileSystem;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected boolean removeLRU(AbstractLinkedMap.LinkEntry linkEntry) {
            LRUFilesCache lRUFilesCache = LRUFilesCache.this;
            synchronized (lRUFilesCache) {
                FileObject fileObject = (FileObject)linkEntry.getValue();
                if (fileObject.isAttached() || fileObject.isContentOpen()) {
                    return false;
                }
                if (super.removeLRU(linkEntry)) {
                    try {
                        fileObject.close();
                    }
                    catch (FileSystemException fileSystemException) {
                        VfsLog.warn(LRUFilesCache.this.getLogger(), LRUFilesCache.this.log, Messages.getString("vfs.impl/LRUFilesCache-remove-ex.warn"), fileSystemException);
                    }
                    Map map = (Map)LRUFilesCache.this.filesystemCache.get(this.filesystem);
                    if (map.size() < 1) {
                        LRUFilesCache.this.filesystemCache.remove(this.filesystem);
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

