/*
 * Decompiled with CFR 0.152.
 */
package com.jgoodies.looks.plastic;

import com.jgoodies.looks.plastic.PlasticInternalFrameTitlePane;
import java.awt.Color;
import java.awt.Container;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JInternalFrame;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.plaf.basic.BasicInternalFrameUI;

public final class PlasticInternalFrameUI
extends BasicInternalFrameUI {
    private static final Border EMPTY_BORDER = new EmptyBorder(0, 0, 0, 0);
    private PlasticInternalFrameTitlePane titlePane;
    private PropertyChangeListener paletteListener;
    private PropertyChangeListener contentPaneListener;

    public PlasticInternalFrameUI(JInternalFrame jInternalFrame) {
        super(jInternalFrame);
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new PlasticInternalFrameUI((JInternalFrame)jComponent);
    }

    public void installUI(JComponent jComponent) {
        this.frame = (JInternalFrame)jComponent;
        this.paletteListener = new PaletteListener(this);
        this.contentPaneListener = new ContentPaneListener(this);
        jComponent.addPropertyChangeListener(this.paletteListener);
        jComponent.addPropertyChangeListener(this.contentPaneListener);
        super.installUI(jComponent);
        Object object = jComponent.getClientProperty("JInternalFrame.isPalette");
        if (object != null) {
            this.setPalette((Boolean)object);
        }
        Container container = this.frame.getContentPane();
        this.stripContentBorder(container);
    }

    public void uninstallUI(JComponent jComponent) {
        JComponent jComponent2;
        this.frame = (JInternalFrame)jComponent;
        jComponent.removePropertyChangeListener(this.paletteListener);
        jComponent.removePropertyChangeListener(this.contentPaneListener);
        Container container = ((JInternalFrame)jComponent).getContentPane();
        if (container instanceof JComponent && (jComponent2 = (JComponent)container).getBorder() == EMPTY_BORDER) {
            jComponent2.setBorder(null);
        }
        super.uninstallUI(jComponent);
    }

    protected void installDefaults() {
        Color color;
        super.installDefaults();
        JComponent jComponent = (JComponent)this.frame.getContentPane();
        if (jComponent != null && (color = jComponent.getBackground()) instanceof UIResource) {
            jComponent.setBackground(null);
        }
        this.frame.setBackground(UIManager.getLookAndFeelDefaults().getColor("control"));
    }

    protected void installKeyboardActions() {
    }

    protected void uninstallKeyboardActions() {
    }

    private void stripContentBorder(Object object) {
        JComponent jComponent;
        Border border;
        if (object instanceof JComponent && ((border = (jComponent = (JComponent)object).getBorder()) == null || border instanceof UIResource)) {
            jComponent.setBorder(EMPTY_BORDER);
        }
    }

    protected JComponent createNorthPane(JInternalFrame jInternalFrame) {
        this.titlePane = new PlasticInternalFrameTitlePane(jInternalFrame);
        return this.titlePane;
    }

    public void setPalette(boolean bl) {
        String string = bl ? "InternalFrame.paletteBorder" : "InternalFrame.border";
        LookAndFeel.installBorder(this.frame, string);
        this.titlePane.setPalette(bl);
    }

    private void setFrameType(String string) {
        boolean bl = string.equals("palette");
        String string2 = string.equals("optionDialog") ? "InternalFrame.optionDialogBorder" : (bl ? "InternalFrame.paletteBorder" : "InternalFrame.border");
        LookAndFeel.installBorder(this.frame, string2);
        this.titlePane.setPalette(bl);
    }

    private static class ContentPaneListener
    implements PropertyChangeListener {
        private final PlasticInternalFrameUI ui;

        private ContentPaneListener(PlasticInternalFrameUI plasticInternalFrameUI) {
            this.ui = plasticInternalFrameUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("contentPane")) {
                this.ui.stripContentBorder(propertyChangeEvent.getNewValue());
            }
        }
    }

    private static class PaletteListener
    implements PropertyChangeListener {
        private final PlasticInternalFrameUI ui;

        private PaletteListener(PlasticInternalFrameUI plasticInternalFrameUI) {
            this.ui = plasticInternalFrameUI;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            Object object = propertyChangeEvent.getNewValue();
            if (string.equals("JInternalFrame.frameType")) {
                if (object instanceof String) {
                    this.ui.setFrameType((String)object);
                }
            } else if (string.equals("JInternalFrame.isPalette")) {
                this.ui.setPalette(Boolean.TRUE.equals(object));
            }
        }
    }
}

