/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xquery;

import com.japisoft.editix.ui.xslt.Factory;
import com.japisoft.editix.ui.xslt.LineSelectionListener;
import com.japisoft.editix.ui.xslt.Preference;
import com.japisoft.editix.ui.xslt.SingleFactoryImpl;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.dockable.InnerWindowProperties;
import com.japisoft.framework.dockable.JDock;
import com.japisoft.framework.dockable.JDockEvent;
import com.japisoft.framework.dockable.JDockListener;
import com.japisoft.framework.dockable.action.ActionModel;
import com.japisoft.framework.dockable.action.BasicActionModel;
import com.japisoft.framework.dockable.action.common.MaxMinAction;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.XMLDocumentInfo;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import com.japisoft.xmlpad.editor.XMLEditor;
import com.japisoft.xquery.ResultPanel;
import com.japisoft.xquery.XMLDataSourcePanel;
import com.japisoft.xquery.XQueryEditor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;

public class XQueryContainer
extends JDock
implements IXMLPanel,
ActionListener,
JDockListener,
LineSelectionListener {
    private XMLContainer mainContainer = null;
    private XMLDataSourcePanel xmlData = null;
    private ResultPanel resPanel = null;
    private Factory factory;
    public static String DEF_XSLTFile = null;
    public static String DEF_DATAFile = null;
    public static String DEF_RESULTFile = null;
    public static String DEBUG_PROPERTY = "xslt.debug";
    public static String PROFILER_PROPERTY = "xslt.profiler";
    public static String ENCODING = "encoding";
    public static String LOADRES_CMD = "reload.res";
    public static String MAXIMIZED_CMD = "maximized.editor";
    private Action parseAction = null;
    private boolean debugMode;
    private Preference preference;
    private String fileEncoding = null;
    private String mustLoadDataFile = null;
    private boolean mustRefresh = false;
    private List listOfXPathResult = null;
    private int xpathCursor = -1;
    private XMLEditor editorTmp = null;

    public XQueryContainer(Factory factory, boolean bl, Action action) {
        this.parseAction = action;
        this.factory = factory;
        this.debugMode = bl;
        this.initUI();
    }

    public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
        this.mainContainer.setDocumentInfo(xMLDocumentInfo);
    }

    public Action getAction(String string) {
        if ("parse".equals(string)) {
            return this.parseAction;
        }
        return null;
    }

    protected void setUIReady(boolean bl) {
        if (bl) {
            this.addJDockListener(this);
        } else {
            this.removeJDockListener(this);
        }
        try {
            if (Preferences.getPreference("xquery", "editing-maximized", false)) {
                this.maximizeInnerWindow("xquery");
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public void showSourceLine(int n) {
        this.xmlData.showSourceLine(n);
    }

    public void showXSLTLine(String string, int n) {
        this.mainContainer.getEditor().highlightLine(n);
    }

    public void showXSLTLine(int n) {
        this.mainContainer.getEditor().highlightLine(n);
    }

    protected JDock.InnerPanel createInnerView() {
        return new CustomInnerPanel();
    }

    public void setPreference(Preference preference) {
        this.preference = preference;
        this.xmlData.file.setCurrentDirectory(preference.getPreference("defaultXQueryPath"));
    }

    public XMLContainer getMainContainer() {
        return this.mainContainer;
    }

    public XMLContainer getSelectedContainer() {
        return null;
    }

    public XMLContainer getSubContainer(String string) {
        return this.xmlData.xmlContainer;
    }

    public String getXSLTFile() {
        return this.mainContainer.getDocumentInfo().getCurrentDocumentLocation();
    }

    public String getDataFile() {
        return this.xmlData.file.getText();
    }

    public void prepareToSave() {
    }

    public void postLoad() {
    }

    public boolean reload() {
        return this.mainContainer.reload();
    }

    public void setProperty(String string, Object object) {
        if ("system-end".equals(string) && this.mustLoadDataFile != null) {
            this.loadDataFile(this.mustLoadDataFile);
        }
        if (object == null) {
            this.mainContainer.setProperty(string, null);
            return;
        }
        this.mainContainer.setProperty(string, object);
        if (DEBUG_PROPERTY.equals(string)) {
            this.resPanel.tpResultDebug.setSelectedIndex(1);
        } else if (PROFILER_PROPERTY.equals(string)) {
            this.resPanel.tpResultDebug.setSelectedIndex(2);
        } else if ("xquery.data.file".equals(string)) {
            if (this.mustLoadDataFile != null) {
                this.mustLoadDataFile = object.toString();
            } else {
                this.loadDataFile(object.toString());
            }
        } else if (ENCODING.equals(string)) {
            this.fileEncoding = (String)object;
        }
    }

    public Object getProperty(String string) {
        if (MAXIMIZED_CMD.equals(string)) {
            return "" + this.isMaximizedInnerWindow("xquery");
        }
        return this.mainContainer.getProperty(string);
    }

    public Object getProperty(String string, Object object) {
        return this.mainContainer.getProperty(string, object);
    }

    public BookmarkContext getBookmarkContext() {
        return null;
    }

    public Iterator getProperties() {
        if (this.xmlData.file.getText().length() > 0) {
            this.mainContainer.setProperty("xquery.data.file", this.xmlData.file.getText());
        }
        return this.mainContainer.getProperties();
    }

    public void loadResultFile() {
        String string = (String)this.mainContainer.getProperty("xquery.result.file");
        this.resPanel.loadResultFile(string, this.fileEncoding);
    }

    public void loadDataFile(String string) {
        if (!this.mustRefresh && string.equals(this.xmlData.xmlContainer.getCurrentDocumentLocation())) {
            return;
        }
        if (this.isMaximized()) {
            this.mustLoadDataFile = string;
            return;
        }
        this.xmlData.file.setText(string);
        try {
            ApplicationModel.debug("Load DataFile " + string);
            String string2 = XMLToolkit.getContentFromURI(string, Toolkit.getCurrentFileEncoding()).getContent();
            this.xmlData.xmlContainer.getDocumentInfo().setCurrentDocumentLocation(string);
            this.xmlData.xmlContainer.setText(string2);
            this.mainContainer.setProperty("xquery.data.file", string);
            if (this.preference != null) {
                this.preference.setPreference("defaultXqueryPath", new File(string).getParent());
            }
        }
        catch (Throwable throwable) {
            this.xmlData.xmlContainer.setText("Can't load " + string + ":\n" + throwable.getMessage());
            this.xmlData.tp.setSelectedIndex(1);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.xmlData.file.getText();
        this.setProperty("xquery.data.file", string);
    }

    public void dispose() {
        super.dispose();
        this.mainContainer.dispose();
        this.xmlData.dispose();
        this.resPanel.dispose();
        this.editorTmp = null;
    }

    public void setAutoDisposeMode(boolean bl) {
        this.mainContainer.setAutoDisposeMode(bl);
        this.xmlData.setAutoDisposeMode(bl);
    }

    private void initUI() {
        this.setLayout(new GridBagLayout());
        this.mainContainer = new XQueryEditor();
        this.addInnerWindow(new InnerWindowProperties("xquery", "XQuery Document", this.mainContainer.getView()), (Object)new GridBagConstraints(0, 0, 2, 2, 1.0, 2.0, 10, 1, new Insets(1, 1, 0, 2), 0, 0));
        this.xmlData = new XMLDataSourcePanel(this.factory);
        this.xmlData.file.setActionListener(this);
        this.xmlData.setPreferredSize(new Dimension(300, 200));
        BasicActionModel basicActionModel = new BasicActionModel(new Action[]{new RefreshAction(), ActionModel.SEPARATOR, new MaxMinAction()});
        this.addInnerWindow(new InnerWindowProperties("data", "XML Data source", null, basicActionModel, this.xmlData), (Object)new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 1, 1, 0), 0, 0));
        this.resPanel = new ResultPanel(this.factory, this.debugMode, this);
        this.addInnerWindow(new InnerWindowProperties("result", "XQuery Result Preview", this.resPanel), (Object)new GridBagConstraints(1, 2, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 1, 2), 0, 0));
    }

    public void jdockAction(JDockEvent jDockEvent) {
        if ("xquery".equals(jDockEvent.getId())) {
            if (jDockEvent.getType() == 1) {
                if (this.mainContainer != null) {
                    this.mainContainer.setProperty(MAXIMIZED_CMD, "true");
                }
            } else if (jDockEvent.getType() == 7) {
                if (this.mainContainer != null) {
                    this.mainContainer.setProperty(MAXIMIZED_CMD, "false");
                }
                if (this.mustLoadDataFile != null) {
                    this.loadDataFile(this.mustLoadDataFile);
                    this.mustLoadDataFile = null;
                }
            }
        }
    }

    boolean isMaximized() {
        if (this.mainContainer == null) {
            return false;
        }
        return "true".equals(this.mainContainer.getProperty(MAXIMIZED_CMD));
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        jFrame.setBounds(10, 10, 500, 500);
        jFrame.getContentPane().add(new XQueryContainer(new SingleFactoryImpl(), false, null).getView());
        jFrame.setVisible(true);
    }

    class RefreshAction
    extends AbstractAction {
        public RefreshAction() {
            ImageIcon imageIcon = new ImageIcon(this.getClass().getResource("refresh.png"));
            this.putValue("SmallIcon", imageIcon);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (XQueryContainer.this.getProperty("xquery.data.file") != null) {
                XQueryContainer.this.mustRefresh = true;
                XQueryContainer.this.setProperty("xquery.data.file", XQueryContainer.this.getProperty("xquery.data.file"));
                XQueryContainer.this.mustRefresh = false;
            }
        }
    }

    class CustomInnerPanel
    extends JDock.InnerPanel
    implements IXMLPanel {
        CustomInnerPanel() {
        }

        public void dispose() {
        }

        public void setAutoDisposeMode(boolean bl) {
            XQueryContainer.this.setAutoDisposeMode(bl);
        }

        public Action getAction(String string) {
            return XQueryContainer.this.getAction(string);
        }

        public XMLContainer getMainContainer() {
            return XQueryContainer.this.mainContainer;
        }

        public XMLContainer getSelectedContainer() {
            return null;
        }

        public BookmarkContext getBookmarkContext() {
            return null;
        }

        public void setDocumentInfo(XMLDocumentInfo xMLDocumentInfo) {
            XQueryContainer.this.mainContainer.setDocumentInfo(xMLDocumentInfo);
        }

        public Iterator getProperties() {
            return XQueryContainer.this.getProperties();
        }

        public Object getProperty(String string, Object object) {
            return XQueryContainer.this.getProperty(string, object);
        }

        public Object getProperty(String string) {
            return XQueryContainer.this.getProperty(string);
        }

        public XMLContainer getSubContainer(String string) {
            return XQueryContainer.this.getSubContainer(string);
        }

        public void prepareToSave() {
        }

        public void postLoad() {
        }

        public boolean reload() {
            return XQueryContainer.this.reload();
        }

        public JComponent getView() {
            return this;
        }

        public void setProperty(String string, Object object) {
            if (LOADRES_CMD.equals(string)) {
                XQueryContainer.this.loadResultFile();
            } else {
                XQueryContainer.this.setProperty(string, object);
            }
            if (MAXIMIZED_CMD.equals(string)) {
                if ("true".equals(object)) {
                    XQueryContainer.this.maximizeInnerWindow("xquery");
                } else {
                    XQueryContainer.this.restoreInnerWindow("xquery");
                }
            }
        }
    }
}

