/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlsearch;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NamespacePrefixCriteria;
import com.japisoft.fastparser.walker.NamespaceURICriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.TextCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.fastparser.walker.ValidCriteria;
import com.japisoft.framework.dialog.BasicOKDialogComponent;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableModel;

public class CriteriaDialog
extends BasicOKDialogComponent
implements ActionListener,
ListSelectionListener {
    private XMLContainer container = null;
    JLabel lblCriteria = new JLabel();
    JComboBox cbCriteria = new JComboBox<String>(new String[]{"TAG", "ATTRIBUTE NAME", "ATTRIBUTE VALUE", "TEXT", "NAMESPACE PREFIX", "NAMESPACE URI"});
    JLabel lblSearch = new JLabel();
    JTextField jTextField1 = new JTextField();
    JButton btnApplyFromRoot = new JButton();
    JButton btnApplyFromCurrent = new JButton();
    JScrollPane spResult = new JScrollPane();
    JTable tbResult = new JTable();
    GridBagLayout gridBagLayout1 = new GridBagLayout();

    public CriteriaDialog(Frame frame, XMLContainer xMLContainer) {
        super(frame, "Mutliple criteria", "Search element", "Search tag, attribute, namespace...\nThis research doesn't include the root node", null);
        this.container = xMLContainer;
        this.init();
    }

    public CriteriaDialog(Dialog dialog, XMLContainer xMLContainer) {
        super(dialog, "Mutliple criteria", "Search element", "Search tag, attribute, namespace...\nThis research doesn't include the root node", null);
        this.container = xMLContainer;
        this.init();
    }

    private void init() {
        this.jbInit();
        this.setSize(500, 500);
    }

    private void jbInit() {
        this.lblCriteria.setText("Criteria");
        this.getContentPane().setLayout(this.gridBagLayout1);
        this.lblSearch.setText("Search");
        this.jTextField1.setText("");
        this.btnApplyFromRoot.setText("Apply from Root");
        this.btnApplyFromCurrent.setText("Apply from current");
        this.tbResult.setToolTipText("Click on a line for selecting the same one in the editor");
        this.getContentPane().add((Component)this.lblCriteria, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 0, new Insets(2, 9, 0, 0), 15, 0));
        this.getContentPane().add((Component)this.cbCriteria, new GridBagConstraints(1, 0, 2, 1, 1.0, 0.0, 10, 2, new Insets(2, 0, 0, 56), 234, 0));
        this.getContentPane().add((Component)this.lblSearch, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 17, 0, new Insets(22, 9, 0, 13), 5, 0));
        this.getContentPane().add((Component)this.jTextField1, new GridBagConstraints(1, 1, 2, 1, 1.0, 0.0, 17, 2, new Insets(19, 0, 0, 56), 262, 0));
        this.getContentPane().add((Component)this.btnApplyFromCurrent, new GridBagConstraints(2, 2, 1, 1, 0.0, 0.0, 17, 0, new Insets(22, 0, 0, 79), 0, 0));
        this.getContentPane().add((Component)this.btnApplyFromRoot, new GridBagConstraints(0, 2, 2, 1, 0.0, 0.0, 10, 0, new Insets(22, 9, 0, 0), 3, 0));
        this.getContentPane().add((Component)this.spResult, new GridBagConstraints(0, 3, 3, 1, 1.0, 1.0, 10, 1, new Insets(13, 9, 14, 13), -131, -257));
        this.spResult.getViewport().add((Component)this.tbResult, null);
    }

    public void beforeShowing() {
        super.beforeShowing();
        this.btnApplyFromCurrent.addActionListener(this);
        this.btnApplyFromRoot.addActionListener(this);
        this.tbResult.getSelectionModel().addListSelectionListener(this);
    }

    public void beforeClosing() {
        super.beforeClosing();
        this.btnApplyFromCurrent.removeActionListener(this);
        this.btnApplyFromRoot.removeActionListener(this);
        this.tbResult.getSelectionModel().removeListSelectionListener(this);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SimpleNode simpleNode = null;
        if (this.container == null) {
            System.err.println("No XMLContainer ???????????? Bad usage !");
            return;
        }
        if (actionEvent.getSource() == this.btnApplyFromCurrent) {
            simpleNode = this.container.getCurrentNode();
        } else if (actionEvent.getSource() == this.btnApplyFromRoot) {
            simpleNode = (SimpleNode)this.container.getTree().getModel().getRoot();
        } else {
            return;
        }
        if (simpleNode == null) {
            JOptionPane.showMessageDialog(this.container.getView(), "No node");
        } else {
            this.unshowResult();
            TreeWalker treeWalker = new TreeWalker(simpleNode);
            ValidCriteria validCriteria = null;
            if (this.cbCriteria.getSelectedIndex() == 0) {
                validCriteria = new NodeNameCriteria(this.jTextField1.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 1) {
                validCriteria = new AttributeCriteria(this.jTextField1.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 2) {
                validCriteria = new AttributeCriteria(AttributeCriteria.ANY_ATTRIBUTE, this.jTextField1.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 3) {
                validCriteria = new TextCriteria(this.jTextField1.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 4) {
                validCriteria = new NamespacePrefixCriteria(this.jTextField1.getText());
            } else if (this.cbCriteria.getSelectedIndex() == 5) {
                validCriteria = new NamespaceURICriteria(this.jTextField1.getText());
            }
            this.showResult(treeWalker.getNodeByCriteria(validCriteria, true));
        }
    }

    private void showResult(Enumeration enumeration) {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{" Result(s)"}, 0);
        while (enumeration.hasMoreElements()) {
            defaultTableModel.addRow(new Object[]{enumeration.nextElement()});
        }
        this.tbResult.setModel(defaultTableModel);
    }

    private void unshowResult() {
        DefaultTableModel defaultTableModel = new DefaultTableModel(new String[]{" No result "}, 0);
        this.tbResult.setModel(defaultTableModel);
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        SimpleNode simpleNode;
        int n = this.tbResult.getSelectedRow();
        if (n > -1 && (simpleNode = (SimpleNode)this.tbResult.getModel().getValueAt(n, 0)).getStartingLine() > 0) {
            this.container.getEditor().highlightLine(simpleNode.getStartingLine());
        }
    }

    public void dispose() {
        super.dispose();
        this.container = null;
    }
}

