/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.bookmark;

import com.japisoft.framework.toolkit.FileToolkit;
import com.japisoft.xmlpad.XMLContainer;
import com.japisoft.xmlpad.bookmark.BookmarkContext;
import com.japisoft.xmlpad.bookmark.BookmarkModel;
import com.japisoft.xmlpad.bookmark.BookmarkPosition;
import com.japisoft.xmlpad.bookmark.DefaultBookmarkModel;
import com.japisoft.xmlpad.editor.XMLDocument;
import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Shape;
import javax.swing.Icon;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;

public class DefaultBookmarkContext
implements BookmarkContext {
    private Icon icon;
    private Color lineColor;
    BookmarkModel model = null;
    private DefaultHighlighter defaultHighlight;

    public DefaultBookmarkContext(Icon icon, Color color) {
        this.icon = icon;
        this.lineColor = color;
    }

    public Icon getIcon() {
        return this.icon;
    }

    public BookmarkModel getModel() {
        if (this.model == null) {
            this.model = new DefaultBookmarkModel();
        }
        return this.model;
    }

    public boolean matchLine(String string, int n, XMLContainer xMLContainer) {
        if (this.model == null) {
            return false;
        }
        for (int i = 0; i < this.model.getBookmarkCount(); ++i) {
            XMLDocument xMLDocument;
            int n2;
            BookmarkPosition bookmarkPosition = this.model.getBookmarkPositionAt(i);
            int n3 = bookmarkPosition.getOffset();
            XMLContainer xMLContainer2 = xMLContainer;
            if (bookmarkPosition.getSource() instanceof XMLContainer && !FileToolkit.sameFileName((xMLContainer2 = (XMLContainer)bookmarkPosition.getSource()).getCurrentDocumentLocation(), string) || n != (n2 = (xMLDocument = xMLContainer2.getDocument()).getDefaultRootElement().getElementIndex(n3))) continue;
            return true;
        }
        return false;
    }

    public Highlighter.HighlightPainter getHighlightPainter() {
        if (this.defaultHighlight == null) {
            this.defaultHighlight = new DefaultHighlighter();
        }
        return this.defaultHighlight;
    }

    class DefaultHighlighter
    implements Highlighter.HighlightPainter {
        DefaultHighlighter() {
        }

        public void paint(Graphics graphics, int n, int n2, Shape shape, JTextComponent jTextComponent) {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Document document = jTextComponent.getDocument();
            int n3 = document.getDefaultRootElement().getElementIndex(n);
            Rectangle rectangle = (Rectangle)shape;
            int n4 = fontMetrics.getHeight();
            int n5 = rectangle.x;
            int n6 = rectangle.y + n4 * n3;
            int n7 = jTextComponent.getWidth();
            graphics.setColor(DefaultBookmarkContext.this.lineColor);
            graphics.fillRect(n5, n6, n7, n4);
        }
    }
}

