/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlpad.action.search;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.xmlpad.action.XMLAction;

public class SearchElement
extends XMLAction {
    public static final String ID = SearchElement.class.getName();
    private int type;

    public SearchElement(int n) {
        this.type = n;
    }

    protected boolean autoRequestFocus() {
        return false;
    }

    public boolean notifyAction() {
        SimpleNode simpleNode = (SimpleNode)this.container.getTree().getModel().getRoot();
        if (simpleNode == null) {
            return INVALID_ACTION;
        }
        SimpleNode simpleNode2 = this.container.getCurrentNode();
        if (simpleNode2 == null) {
            switch (this.type) {
                case 1: {
                    return INVALID_ACTION;
                }
                case 0: {
                    this.highlightLine(simpleNode.getStartingLine());
                    return VALID_ACTION;
                }
                case 2: 
                case 3: {
                    return INVALID_ACTION;
                }
            }
        }
        Document document = simpleNode.getDocument();
        FastVector fastVector = document.getFlatNodes();
        int n = fastVector.indexOf(simpleNode2);
        switch (this.type) {
            case 1: {
                if (n > 0) {
                    SimpleNode simpleNode3 = (SimpleNode)fastVector.get(n - 1);
                    this.highlightLine(simpleNode3.getStartingLine());
                    return VALID_ACTION;
                }
                return INVALID_ACTION;
            }
            case 0: {
                if (n + 1 < fastVector.size()) {
                    SimpleNode simpleNode4 = (SimpleNode)fastVector.get(n + 1);
                    this.highlightLine(simpleNode4.getStartingLine());
                    return VALID_ACTION;
                }
                return INVALID_ACTION;
            }
            case 2: {
                this.highlightLine(simpleNode2.getStartingLine());
                return VALID_ACTION;
            }
            case 3: {
                this.highlightLine(simpleNode2.getStoppingLine());
                return VALID_ACTION;
            }
        }
        return VALID_ACTION;
    }

    private void highlightLine(int n) {
        this.container.getEditor().asynchronousHighlightLine(n);
    }
}

