/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.xmlform.designer;

import com.japisoft.xmlform.Toolkit;
import com.japisoft.xmlform.UIToolkit;
import com.japisoft.xmlform.component.AbstractXMLFormComponent;
import com.japisoft.xmlform.component.ComponentContext;
import com.japisoft.xmlform.component.XMLDeserizalizer;
import com.japisoft.xmlform.component.XMLFormComponentFactory;
import com.japisoft.xmlform.component.container.XMLFormContainer;
import com.japisoft.xmlform.designer.XmlFormModel;
import com.japisoft.xmlform.designer.data.DataPanel;
import com.japisoft.xmlform.designer.data.DataPanelListener;
import com.japisoft.xmlform.designer.data.GrammarNodeTreeNode;
import com.japisoft.xmlform.designer.library.ComponentsPanel;
import com.japisoft.xmlform.designer.properties.PropertiesPanel;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Point;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URL;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DesignerComponent
extends JPanel
implements DataPanelListener {
    private XMLFormContainer form = null;
    private DataPanel dp = null;
    private PropertiesPanel pp = null;
    private ComponentsPanel cp = null;
    private JSplitPane sp = null;
    private JScrollPane scrollPane = null;
    private int version = 1;

    public DesignerComponent() {
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BorderLayout());
        this.sp = new JSplitPane(1);
        this.dp = new DataPanel(this);
        this.form = this.dp.getComponentFactory().newRootContainer();
        this.scrollPane = new JScrollPane(this.form);
        this.sp.setLeftComponent(this.scrollPane);
        JTabbedPane jTabbedPane = new JTabbedPane(1);
        jTabbedPane.setPreferredSize(new Dimension(250, 0));
        this.cp = new ComponentsPanel();
        this.pp = new PropertiesPanel();
        jTabbedPane.addTab("Data", com.japisoft.framework.app.toolkit.Toolkit.getImageIcon("images/data.png"), this.dp);
        jTabbedPane.addTab("Components", com.japisoft.framework.app.toolkit.Toolkit.getImageIcon("images/component.png"), this.cp);
        jTabbedPane.addTab("Properties", com.japisoft.framework.app.toolkit.Toolkit.getImageIcon("images/palette2.png"), this.pp);
        this.sp.setOneTouchExpandable(true);
        this.sp.setRightComponent(jTabbedPane);
        this.add(this.sp);
        this.sp.setDividerLocation(700);
    }

    public void setCurrentComponent(AbstractXMLFormComponent abstractXMLFormComponent) {
        this.pp.init(abstractXMLFormComponent.getProperties());
        GrammarNodeTreeNode grammarNodeTreeNode = abstractXMLFormComponent.getGrammarNode();
        if (grammarNodeTreeNode != null) {
            this.dp.selectNode(grammarNodeTreeNode);
        }
    }

    public void cut() {
        this.form.cut();
    }

    public void scrollTo(AbstractXMLFormComponent abstractXMLFormComponent) {
        Point point = UIToolkit.getLocation(abstractXMLFormComponent);
        this.scrollPane.getViewport().setViewPosition(point);
    }

    public void newRoot(String string) {
        this.form.setXpath("/" + string);
    }

    public void newForm() {
        int n = this.sp.getDividerLocation();
        this.dp.resetSchema(null);
        this.sp.setLeftComponent(null);
        this.form = this.dp.getComponentFactory().newRootContainer();
        this.scrollPane = new JScrollPane(this.form);
        this.sp.setLeftComponent(this.scrollPane);
        this.sp.setDividerLocation(n);
        XmlFormModel.CURRENT_DOCUMENT = null;
    }

    public void save(Document document) {
        Element element = document.createElementNS(null, "xf");
        element.setAttribute("appVersion", XmlFormModel.getAppVersion());
        element.setAttribute("version", "" + this.version);
        if (XmlFormModel.CURRENT_SPELLCHECK != null) {
            element.setAttribute("spell", XmlFormModel.CURRENT_SPELLCHECK);
        }
        if (this.dp.getSchemaLocation() != null) {
            element.setAttribute("schema", "" + this.dp.getSchemaLocation());
        }
        if (this.dp.getRoot() != null) {
            element.setAttribute("root", this.dp.getRoot());
        }
        Element element2 = document.createElementNS(null, "fields");
        element.appendChild(element2);
        this.form.save(element2);
        document.appendChild(element);
    }

    public void load(File file) throws Exception {
        this.load(file.toString(), new FileInputStream(file));
    }

    public void load(String string) throws Exception {
        if (string.indexOf("://") > -1) {
            this.load(string, new URL(string).openStream());
        } else {
            this.load(new File(string));
        }
    }

    public void load(String string, InputStream inputStream) {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.parse(inputStream);
            this.load(string, document);
        }
        catch (Exception exception) {
            XmlFormModel.debug(exception);
            UIToolkit.dispatchError("Can't load " + string + " : " + exception.getMessage());
        }
    }

    public void load(String string, Document document) throws Exception {
        XMLFormContainer xMLFormContainer;
        AbstractXMLFormComponent abstractXMLFormComponent;
        String string2;
        Element element = document.getDocumentElement();
        if (element.hasAttribute("spell")) {
            XmlFormModel.CURRENT_SPELLCHECK = element.getAttribute("spell");
        }
        if (!"".equals(string2 = element.getAttribute("schema"))) {
            string2 = Toolkit.getAbsolutePath(string, string2);
            this.dp.resetSchema(string2);
        } else {
            UIToolkit.warn("No schema found ?");
        }
        String string3 = element.getAttribute("root");
        if (!"".equals(string3)) {
            this.dp.resetRoot(string3);
        }
        if (!((abstractXMLFormComponent = XMLDeserizalizer.build(document, true, this.dp.getGrammarNodeTreeNodeRoot(), null, new ComponentContext(){

            public XMLFormComponentFactory getComponentFactory() {
                return DesignerComponent.this.dp.getComponentFactory();
            }

            public GrammarNodeTreeNode getCurrentTreeNode() {
                return DesignerComponent.this.dp.getCurrentTreeNode();
            }

            public Document getDocument() {
                return null;
            }

            public void action(int n, Object object) {
                DesignerComponent.this.dp.action(n, object);
            }
        })) instanceof XMLFormContainer)) {
            throw new Exception("Illegal root component");
        }
        this.form = xMLFormContainer = (XMLFormContainer)abstractXMLFormComponent;
        int n = this.sp.getDividerLocation();
        this.sp.setLeftComponent(null);
        this.scrollPane = new JScrollPane(xMLFormContainer);
        this.sp.setLeftComponent(this.scrollPane);
        this.sp.setDividerLocation(n);
        xMLFormContainer.resetRootContainerSize();
        XmlFormModel.CURRENT_DOCUMENT = string;
    }
}

