/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.universalbrowser;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import javax.swing.tree.TreeNode;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;

class FileObjectTreeNode
implements TreeNode,
Comparable {
    private FileObject fo;
    FileType currentType = null;
    private ArrayList children = null;
    private TreeNode parent = null;
    String cachedName = null;

    FileObjectTreeNode(FileObject fileObject) {
        this.fo = fileObject;
    }

    public Enumeration children() {
        this.prepareChildren();
        return Collections.enumeration(this.children);
    }

    public boolean getAllowsChildren() {
        return true;
    }

    public boolean isFolder() {
        try {
            if (this.currentType != null) {
                return this.currentType == FileType.FOLDER;
            }
            this.currentType = this.fo.getType();
            return this.currentType == FileType.FOLDER;
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    public int compareTo(Object object) {
        FileObjectTreeNode fileObjectTreeNode = (FileObjectTreeNode)object;
        if (this.isFolder()) {
            if (fileObjectTreeNode.isFolder()) {
                return this.fo.getName().compareTo(fileObjectTreeNode.fo.getName());
            }
            return 1;
        }
        if (fileObjectTreeNode.isFolder()) {
            return -1;
        }
        return this.fo.getName().compareTo(fileObjectTreeNode.fo.getName());
    }

    private void prepareChildren() {
        if (this.children == null) {
            this.children = new ArrayList();
            try {
                FileObject[] fileObjectArray = this.fo.getChildren();
                if (fileObjectArray != null) {
                    for (int i = 0; i < fileObjectArray.length; ++i) {
                        this.children.add(new FileObjectTreeNode(fileObjectArray[i]));
                    }
                }
                Collections.sort(this.children);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
    }

    public TreeNode getChildAt(int n) {
        this.prepareChildren();
        return (TreeNode)this.children.get(n);
    }

    public int getChildCount() {
        this.prepareChildren();
        return this.children.size();
    }

    public int getIndex(TreeNode treeNode) {
        this.prepareChildren();
        return this.children.indexOf(treeNode);
    }

    public TreeNode getParent() {
        try {
            if (this.parent == null) {
                this.parent = new FileObjectTreeNode(this.fo.getParent());
            }
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
        return this.parent;
    }

    public boolean isLeaf() {
        this.prepareChildren();
        return this.children.size() == 0;
    }

    boolean isRoot() {
        return "/".equals(this.fo.getName().getPath());
    }

    public String toString() {
        if (this.isRoot()) {
            if (this.cachedName == null) {
                this.cachedName = this.fo.getName().getURI();
                int n = this.cachedName.indexOf("file:///");
                int n2 = this.cachedName.lastIndexOf("!");
                if (n > -1) {
                    this.cachedName = n2 > -1 ? this.cachedName.substring(n + 8, n2) : this.cachedName.substring(n + 8);
                }
                if ((n = this.cachedName.lastIndexOf("/")) > -1 && n + 1 < this.cachedName.length()) {
                    this.cachedName = this.cachedName.substring(n + 1);
                }
            }
            return this.cachedName;
        }
        return this.fo.getName().getBaseName();
    }

    FileObject getSource() {
        return this.fo;
    }
}

