/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser.action;

import com.japisoft.treefilebrowser.action.FileBrowserAction;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;

public class DeleteAction
extends FileBrowserAction {
    public DeleteAction() {
        this.putValue("ShortDescription", "Delete the current file");
        this.putValue("SmallIcon", new ImageIcon(this.getClass().getResource("document_delete.png")));
    }

    public void actionPerformed(ActionEvent actionEvent) {
        int n;
        File[] fileArray = this.browser.getSelectedFiles();
        ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < fileArray.length; ++i) {
            if (!fileArray[i].isFile()) continue;
            arrayList.add(fileArray[i]);
        }
        File[] fileArray2 = new File[arrayList.size()];
        for (n = 0; n < arrayList.size(); ++n) {
            fileArray2[n] = (File)arrayList.get(n);
        }
        arrayList = new ArrayList();
        for (n = 0; n < fileArray.length; ++n) {
            if (!fileArray[n].isDirectory()) continue;
            arrayList.add(fileArray[n]);
        }
        File[] fileArray3 = new File[arrayList.size()];
        for (int i = 0; i < arrayList.size(); ++i) {
            fileArray3[i] = (File)arrayList.get(i);
        }
        String string = null;
        string = fileArray2.length == 1 && fileArray3.length == 0 ? fileArray2[0].toString() : (fileArray2.length == 0 && fileArray3.length == 1 ? fileArray3[0].toString() : (fileArray2.length > 0 && fileArray3.length == 0 ? fileArray2.length + " files" : (fileArray3.length > 0 && fileArray2.length == 0 ? fileArray3.length + " directories" : fileArray2.length + " files and " + fileArray3.length + " directories")));
        if (JOptionPane.showConfirmDialog(this.browser, "Delete " + string + " ?") == 0) {
            boolean bl = false;
            for (int i = 0; i < fileArray2.length; ++i) {
                File file = fileArray2[i];
                if (!file.delete()) {
                    JOptionPane.showMessageDialog(this.browser, "Can't delete " + file);
                    continue;
                }
                bl = true;
            }
            if (bl && fileArray3.length == 0) {
                this.browser.refreshParent();
            } else if (fileArray3.length > 0) {
                DeleteDirectoryDialog deleteDirectoryDialog = new DeleteDirectoryDialog(fileArray3);
                deleteDirectoryDialog.setVisible(true);
                deleteDirectoryDialog.start();
            }
        }
    }

    class DeleteDirectoryDialog
    extends JDialog
    implements Runnable {
        JLabel lbl;
        File[] dir;

        public DeleteDirectoryDialog(File[] fileArray) {
            super((Frame)null, "Delete a directory");
            this.lbl = null;
            this.dir = null;
            this.lbl = new JLabel("Deleting " + fileArray);
            this.getContentPane().add(this.lbl);
            this.pack();
            this.setSize(this.getWidth() + 50, this.getHeight());
            this.dir = fileArray;
        }

        public void start() {
            Thread thread = new Thread(this);
            thread.start();
        }

        public void run() {
            try {
                for (int i = 0; i < this.dir.length; ++i) {
                    if (this.deleteDir(this.dir[i])) continue;
                    JOptionPane.showMessageDialog(DeleteAction.this.browser, "Can't delete " + this.dir[i]);
                }
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
            }
            DeleteAction.this.browser.refreshParent();
            this.setVisible(false);
        }

        boolean deleteDir(File file) throws InterruptedException {
            File[] fileArray = file.listFiles();
            boolean bl = false;
            if (fileArray != null) {
                for (int i = 0; i < fileArray.length; ++i) {
                    final File file2 = fileArray[i];
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            DeleteDirectoryDialog.this.lbl.setText("Deleting " + file2);
                        }
                    });
                    Thread.sleep(50L);
                    if (file2.isFile()) {
                        boolean bl2 = bl = !file2.delete();
                        if (!bl) continue;
                        break;
                    }
                    if (this.deleteDir(file2)) continue;
                    return false;
                }
            }
            if (!bl) {
                return file.delete();
            }
            return false;
        }
    }
}

