/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.treefilebrowser;

import com.japisoft.treefilebrowser.FileTree;
import com.japisoft.treefilebrowser.FileTreeNode;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.TransferHandler;

class FileTreeTransferHandler
extends TransferHandler {
    private static final DataFlavor[] flavors = new DataFlavor[]{DataFlavor.javaFileListFlavor};
    File[] files = null;

    FileTreeTransferHandler() {
    }

    public int getSourceActions(JComponent jComponent) {
        return 2;
    }

    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        if (jComponent instanceof FileTree) {
            FileTreeNode fileTreeNode = ((FileTree)jComponent).getNodeDragged();
            if (!fileTreeNode.content.canWrite()) {
                return false;
            }
            for (int i = 0; i < this.files.length; ++i) {
                if (!this.files[i].getParentFile().equals(fileTreeNode.content)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    protected Transferable createTransferable(JComponent jComponent) {
        FileTree fileTree = (FileTree)jComponent;
        this.files = fileTree.getSelectedFiles();
        if (this.files == null) {
            return null;
        }
        final ArrayList<File> arrayList = new ArrayList<File>();
        for (int i = 0; i < this.files.length; ++i) {
            arrayList.add(this.files[i]);
        }
        Transferable transferable = new Transferable(){

            public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                if (this.isDataFlavorSupported(dataFlavor)) {
                    return arrayList;
                }
                return null;
            }

            public DataFlavor[] getTransferDataFlavors() {
                return flavors;
            }

            public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                return dataFlavor.equals(DataFlavor.javaFileListFlavor);
            }
        };
        return transferable;
    }

    public boolean importData(JComponent jComponent, Transferable transferable) {
        FileTree fileTree = (FileTree)jComponent;
        try {
            return fileTree.dndPaste((ArrayList)transferable.getTransferData(flavors[0]));
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            return false;
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

