/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.multipanes.view;

import com.japisoft.multipanes.MultiPanes;
import com.japisoft.multipanes.TitledPane;
import com.japisoft.multipanes.TitledPaneView;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.UIManager;

public class ActionTitledPaneView
implements TitledPaneView {
    private MultiPanes mp;
    private Action action;

    public ActionTitledPaneView(Action action) {
        this.action = action;
    }

    public void init(MultiPanes multiPanes) {
        this.mp = multiPanes;
    }

    public JComponent buildPanelHeader(TitledPane titledPane) {
        return new InnerComponent(titledPane);
    }

    public void updateView(JComponent jComponent, TitledPane titledPane, boolean bl) {
        if (jComponent != null) {
            ((InnerComponent)jComponent).update(titledPane);
            if (bl) {
                if (this.mp.getDefaultSelectedTitledPaneFont() != null) {
                    jComponent.setFont(this.mp.getDefaultSelectedTitledPaneFont());
                }
            } else {
                jComponent.setFont(UIManager.getFont("Label.font"));
            }
        }
    }

    class InnerComponent
    extends JComponent
    implements MouseListener {
        private Icon mainIcon;
        private int labelWidth;
        private String label;
        private String id;

        private InnerComponent(TitledPane titledPane) {
            this.update(titledPane);
        }

        private void update(TitledPane titledPane) {
            this.id = titledPane.getName();
            this.label = titledPane.getTitle();
            this.mainIcon = titledPane.getIcon();
            this.labelWidth = this.getFontMetrics(UIManager.getFont("Label.font")).stringWidth(this.label);
            this.setBackground(titledPane.getBackground());
            this.setForeground(titledPane.getForeground());
            this.setToolTipText(titledPane.getToolTip());
        }

        protected void paintComponent(Graphics graphics) {
            Icon icon;
            super.paintComponent(graphics);
            Color color = graphics.getColor();
            graphics.setColor(Color.GRAY);
            graphics.draw3DRect(1, 1, this.getWidth() - 2, this.getHeight() - 2, true);
            graphics.setColor(color);
            if (this.label != null) {
                graphics.drawString(this.label, (this.getWidth() - this.labelWidth) / 2, (this.getHeight() - this.getFontMetrics(this.getFont()).getHeight()) / 2 + this.getFontMetrics(this.getFont()).getAscent());
            }
            if (this.mainIcon != null) {
                this.mainIcon.paintIcon(this, graphics, 10, (this.getHeight() - this.mainIcon.getIconHeight()) / 2);
            }
            if (ActionTitledPaneView.this.action != null && (icon = (Icon)ActionTitledPaneView.this.action.getValue("SmallIcon")) != null) {
                icon.paintIcon(this, graphics, this.getWidth() - 10 - icon.getIconWidth(), (this.getHeight() - icon.getIconHeight()) / 2);
            }
        }

        public Dimension getPreferredSize() {
            return new Dimension(1, 30);
        }

        public void addNotify() {
            super.addNotify();
            this.addMouseListener(this);
        }

        public void removeNotify() {
            super.removeNotify();
            this.removeMouseListener(this);
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            Rectangle rectangle;
            Icon icon = (Icon)ActionTitledPaneView.this.action.getValue("SmallIcon");
            if (icon != null && (rectangle = new Rectangle(this.getWidth() - 10 - icon.getIconWidth(), (this.getHeight() - icon.getIconHeight()) / 2, icon.getIconWidth(), icon.getIconHeight())).contains(mouseEvent.getX(), mouseEvent.getY())) {
                ActionTitledPaneView.this.action.actionPerformed(new ActionEvent(this, 0, this.id));
                return;
            }
            ActionTitledPaneView.this.mp.open(this.id);
        }

        public void mouseEntered(MouseEvent mouseEvent) {
        }

        public void mouseExited(MouseEvent mouseEvent) {
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
        }
    }
}

