/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactors.elements.schema;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor.elements.AbstractRefactor;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import com.japisoft.framework.xml.refactor.ui.RefactorTable;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class AttributeRefactor
extends AbstractRefactor {
    public static String[] ACTIONS = new String[]{"(V1) RENAME TO (V2)", "DELETE (V1)"};

    public AttributeRefactor() {
        super((short)1);
    }

    protected Node refactorIt(Node node, RefactorAction refactorAction) {
        Element element = (Element)node;
        if ("attribute".equals(element.getLocalName())) {
            if ("(V1) RENAME TO (V2)".equals(refactorAction.getAction())) {
                if (refactorAction.matchOldValue(element.getAttribute("name"))) {
                    element.setAttribute("name", refactorAction.getNewValue());
                } else if (refactorAction.matchOldValue(element.getAttribute("ref"))) {
                    element.setAttribute("ref", refactorAction.getNewValue());
                }
            } else if ("DELETE (V1)".equals(refactorAction.getAction())) {
                if (refactorAction.matchOldValue(element.getAttribute("name"))) {
                    return null;
                }
                if (refactorAction.matchOldValue(element.getAttribute("ref"))) {
                    return null;
                }
            }
        }
        return node;
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public String getName() {
        return "W3C Schema attribute";
    }

    public boolean isDefault() {
        return false;
    }

    public void initTable(RefactorTable refactorTable, SimpleNode simpleNode) {
        if (simpleNode.matchContent("attribute")) {
            refactorTable.init(0, simpleNode.getAttribute("name"));
        }
    }
}

