/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml.refactor.elements;

import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.xml.refactor.elements.AbstractRefactor;
import com.japisoft.framework.xml.refactor.elements.AttrProxyNode;
import com.japisoft.framework.xml.refactor.elements.RefactorAction;
import com.japisoft.framework.xml.refactor.ui.RefactorTable;
import org.w3c.dom.Attr;
import org.w3c.dom.Node;

public class PrefixRefactor
extends AbstractRefactor {
    public static String[] ACTIONS = new String[]{"(V1) RENAME TO (V2)", "DELETE (V1)", "(V1) ADD TO ELEMENT (V2)"};

    public PrefixRefactor() {
        super(ANY);
    }

    public String[] getActions() {
        return ACTIONS;
    }

    public String getName() {
        return "Prefix";
    }

    protected Node refactorIt(Node node, RefactorAction refactorAction) {
        if ("(V1) RENAME TO (V2)".equals(refactorAction.getAction())) {
            if (refactorAction.matchOldValue(node.getPrefix())) {
                if (!refactorAction.isNewValueEmpty()) {
                    node.setPrefix(refactorAction.getNewValue());
                    return node;
                }
            } else if (node.getNodeType() == 2 && node.getNodeName().equals("xmlns:" + refactorAction.getOldValue())) {
                return new AttrProxyNode((Attr)node, "xmlns:" + refactorAction.getNewValue());
            }
        } else if ("DELETE (V1)".equals(refactorAction.getAction())) {
            if (refactorAction.matchOldValue(node.getPrefix())) {
                node.setPrefix(null);
                return node;
            }
            if (node.getNodeType() == 2 && node.getNodeName().equals("xmlns:" + refactorAction.getOldValue())) {
                return null;
            }
        } else if ("(V1) ADD TO ELEMENT (V2)".equals(refactorAction.getAction()) && refactorAction.matchNewValue(node.getLocalName())) {
            if (refactorAction.getOldValue() == null) {
                throw new RuntimeException("Prefix Refactor : Invalid oldValue for (V1) ADD TO ELEMENT (V2)");
            }
            node.setPrefix(refactorAction.getOldValue());
        }
        return node;
    }

    public void initTable(RefactorTable refactorTable, SimpleNode simpleNode) {
        if (simpleNode.getNameSpacePrefix() != null) {
            refactorTable.init(0, simpleNode.getNameSpacePrefix());
        }
    }
}

