/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.xml;

import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.xml.XMLFileData;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;

public class XMLToolkit {
    public static XMLFileData getContentFromURI(String string, String string2) throws Throwable {
        if (string.indexOf("://") == -1) {
            if (string.startsWith("file:")) {
                string = string.substring(5);
            }
            File file = new File(string);
            XMLFileData xMLFileData = XMLToolkit.getContentFromInputStream(new FileInputStream(string), string2);
            xMLFileData.modifiedDate = file.lastModified();
            xMLFileData.uri = string;
            return xMLFileData;
        }
        XMLFileData xMLFileData = XMLToolkit.getContentFromInputStream(new URL(string).openStream(), string2);
        xMLFileData.uri = string;
        return xMLFileData;
    }

    public static XMLFileData getContentFromRelativeOrAbsoluteLocation(String string, String string2) throws Throwable {
        if (string.contains("://")) {
            XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, null);
            xMLFileData.uri = string;
            return xMLFileData;
        }
        if (string2.contains("://")) {
            int n = string2.lastIndexOf("/");
            String string3 = string2.substring(0, n + 1) + string;
            XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string3, null);
            xMLFileData.uri = string3;
            return xMLFileData;
        }
        File file = new File(string);
        if (file.exists()) {
            XMLFileData xMLFileData = XMLToolkit.getContentFromURI(string, null);
            xMLFileData.uri = string;
            return xMLFileData;
        }
        file = new File(new File(string2).getParentFile(), string);
        XMLFileData xMLFileData = XMLToolkit.getContentFromURI(file.toString(), null);
        xMLFileData.uri = file.toString();
        return xMLFileData;
    }

    public static String getXMLEncoding(String string) {
        int n = 0;
        String string2 = "UTF-8";
        try {
            char c = string.charAt(n++);
            if (c == '<' && (c = string.charAt(n++)) == '?' && (c = string.charAt(n++)) == 'x' && (c = string.charAt(n++)) == 'm' && (c = string.charAt(n++)) == 'l') {
                c = string.charAt(n++);
                boolean bl = false;
                while (c != '>') {
                    c = string.charAt(n++);
                    if (bl && c == 'e') {
                        while ((c = string.charAt(n++)) != '\'' && c != '\"') {
                        }
                        StringBuffer stringBuffer = new StringBuffer();
                        c = string.charAt(n++);
                        while (c != '\'' && c != '\"') {
                            stringBuffer.append(c);
                            c = string.charAt(n++);
                        }
                        string2 = stringBuffer.toString().toUpperCase();
                        continue;
                    }
                    bl = c == ' ' || c == '\t';
                }
            }
        }
        catch (RuntimeException runtimeException) {
            string2 = null;
        }
        return string2;
    }

    public static XMLFileData getContentFromBytes(byte[] byArray, String string) throws Throwable {
        return XMLToolkit.getContentFromInputStream(new ByteArrayInputStream(byArray), string);
    }

    private static int readCharWith16bitsCase(InputStream inputStream, StringBuffer stringBuffer) throws Throwable {
        int n = inputStream.read();
        boolean bl = false;
        if (n == 0) {
            n = inputStream.read();
        }
        if (n == 0) {
            n = inputStream.read();
        }
        if (n == 0) {
            n = inputStream.read();
            bl = true;
        }
        if (n != -1) {
            stringBuffer.append((char)n);
        }
        if (!bl && n == 0 && (n = inputStream.read()) != -1) {
            stringBuffer.append((char)n);
        }
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XMLFileData getContentFromInputStream(InputStream inputStream, String string) throws Throwable {
        Object object;
        int n;
        String string2 = string;
        StringBuffer stringBuffer = new StringBuffer();
        if (string == null || "AUTOMATIC".equals(string)) {
            string2 = "UTF-8";
            n = inputStream.read();
            if (n == 239 && (n = inputStream.read()) == 187 && (n = inputStream.read()) == 191) {
                n = inputStream.read();
            }
            if (n == 255 || n == 254) {
                n = inputStream.read();
            }
            if (n == 255 || n == 254) {
                n = inputStream.read();
            }
            if (n == 0) {
                n = inputStream.read();
            }
            if (n == 0) {
                n = inputStream.read();
            }
            if (n != -1) {
                stringBuffer.append((char)n);
            }
            if (n != -1 && n == 60 && (n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer)) != -1 && n == 63 && (n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer)) != -1 && n == 120 && (n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer)) != -1 && n == 109 && (n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer)) != -1 && n == 108) {
                n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer);
                boolean bl = false;
                while (n != 62 && n != -1) {
                    n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer);
                    if (bl && n == 101) {
                        while ((n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer)) != 39 && n != 34 && n != -1) {
                        }
                        object = new StringBuffer();
                        n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer);
                        while (n != -1 && n != 39 && n != 34) {
                            ((StringBuffer)object).append((char)n);
                            n = XMLToolkit.readCharWith16bitsCase(inputStream, stringBuffer);
                        }
                        string2 = ((StringBuffer)object).toString().toUpperCase();
                        continue;
                    }
                    bl = n == 32 || n == 9;
                }
            }
            if (n == -1) {
                inputStream.close();
                return new XMLFileData(string2, stringBuffer.toString());
            }
        }
        InputStreamReader inputStreamReader = null;
        if (string2 == null || "DEFAULT".equals(string2) || "AUTOMATIC".equals(string2)) {
            inputStreamReader = new InputStreamReader(inputStream);
        } else if ("${DEFAULT-ENCODING}".equals(string2)) {
            inputStreamReader = new InputStreamReader(inputStream);
        } else {
            try {
                inputStreamReader = new InputStreamReader(inputStream, string2);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                inputStreamReader = new InputStreamReader(inputStream);
            }
        }
        object = new char[1024];
        try {
            while ((n = inputStreamReader.read((char[])object)) != -1) {
                stringBuffer.append(new String((char[])object, 0, n));
            }
        }
        finally {
            inputStreamReader.close();
        }
        try {
            if (stringBuffer.charAt(stringBuffer.length() - 3) == '\ufffd') {
                stringBuffer.setCharAt(stringBuffer.length() - 3, ' ');
            }
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return new XMLFileData(string2, stringBuffer.toString());
    }

    static ArrayList browseJars(String string) {
        ArrayList<URL> arrayList = new ArrayList<URL>();
        URL uRL = ClassLoader.getSystemResource(string);
        if (uRL != null) {
            String string2 = uRL.toExternalForm();
            if (string2.startsWith("file://")) {
                string2 = string2.substring(7);
            } else if (string2.startsWith("file:")) {
                string2 = string2.substring(5);
            }
            string2 = string2.replaceAll("%20", " ");
            File file = new File(string2);
            String[] stringArray = file.list();
            for (int i = 0; i < stringArray.length; ++i) {
                String string3 = stringArray[i];
                try {
                    arrayList.add(new File(file, string3).toURL());
                    continue;
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
        return arrayList;
    }

    static boolean check(URL[] uRLArray, String string) {
        try {
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            uRLClassLoader.loadClass(string).newInstance();
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Class loadByConfigFile(File file) throws Exception {
        if (!file.exists()) {
            return null;
        }
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        try {
            String string = bufferedReader.readLine();
            if (string == null) {
                Class clazz = null;
                return clazz;
            }
            if ("".equals(string)) {
                Class clazz = null;
                return clazz;
            }
            ArrayList<String> arrayList = new ArrayList<String>();
            String string2 = bufferedReader.readLine();
            while (string2 != null) {
                arrayList.add(string2);
                string2 = bufferedReader.readLine();
            }
            if (arrayList.size() == 0) {
                Class clazz = null;
                return clazz;
            }
            URL[] uRLArray = new URL[arrayList.size()];
            for (int i = 0; i < arrayList.size(); ++i) {
                uRLArray[i] = new URL((String)arrayList.get(i));
            }
            URLClassLoader uRLClassLoader = new URLClassLoader(uRLArray);
            ApplicationModel.debug("Load class " + string);
            Class<?> clazz = uRLClassLoader.loadClass(string);
            return clazz;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static String resolveCharEntities(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '<') {
                stringBuffer.append("&lt;");
                continue;
            }
            if (c == '>') {
                stringBuffer.append("&gt;");
                continue;
            }
            if (c == '\"') {
                stringBuffer.append("&quot;");
                continue;
            }
            if (c == '\'') {
                stringBuffer.append("&apos;");
                continue;
            }
            if (c == '&' && (i + 1 >= string.length() || string.charAt(i + 1) != '#')) {
                stringBuffer.append("&amp;");
                continue;
            }
            if (c == '\n') {
                stringBuffer.append("&#10;");
                continue;
            }
            stringBuffer.append(c);
        }
        return stringBuffer.toString();
    }

    public static String getFullProlog(String string) {
        char c;
        StringBuffer stringBuffer = new StringBuffer();
        int n = 0;
        for (int i = 0; i < string.length() && ((c = string.charAt(i)) == '?' || c == '!' || n != 60); ++i) {
            stringBuffer.append(c);
            n = c;
        }
        stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        if (stringBuffer.length() - 1 > 0 && stringBuffer.charAt(stringBuffer.length() - 1) == '\n') {
            stringBuffer.deleteCharAt(stringBuffer.length() - 1);
        }
        return stringBuffer.toString();
    }
}

