/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui.text;

import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.ui.TitleLabel;
import com.japisoft.framework.ui.text.DefaultTextFieldHandler;
import com.japisoft.framework.ui.text.FileTextFieldHandler;
import com.japisoft.framework.ui.text.PathBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.TransferHandler;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;

public class FileTextField
extends JPanel
implements ActionListener,
PopupMenuListener {
    public JComboBox combo;
    private TitleLabel lbl;
    private JButton btn;
    private JButton btn2;
    private JButton btn3;
    private String[] fileExt;
    private PathBuilder builder;
    private JPanel pnlBtns;
    private String prefGroup = null;
    private String prefName = null;
    private String currentDir;
    private boolean directoryMode = false;
    private boolean fileMode = true;
    private ActionListener customListener;
    private boolean openedMode = true;
    FileTextFieldHandler handler = null;

    public FileTextField(String string, String string2, String string3) {
        this(string, string2, new String[]{string3});
    }

    public FileTextField(String string, String string2, String[] stringArray) {
        this(string, new String[]{string2}, stringArray, null);
        this.combo.setSelectedIndex(0);
    }

    public FileTextField(String string, String[] stringArray, String string2, PathBuilder pathBuilder) {
        this(string, stringArray, new String[]{string2}, pathBuilder);
    }

    public FileTextField(String string, String[] stringArray, String[] stringArray2, PathBuilder pathBuilder) {
        this.fileExt = stringArray2;
        this.builder = pathBuilder;
        if (string != null) {
            this.lbl = new TitleLabel(string);
        }
        String[] stringArray3 = stringArray;
        if (pathBuilder != null && (stringArray3 = pathBuilder.buildPathsChoice()) == null) {
            stringArray3 = stringArray;
        }
        this.combo = stringArray3 != null ? new JComboBox<String>(stringArray3) : new JComboBox();
        this.combo.setEditable(true);
        this.setLayout(new BorderLayout());
        if (string != null) {
            this.add((Component)this.lbl, "West");
        }
        this.add((Component)this.combo, "Center");
        this.setBorder(null);
        this.pnlBtns = new JPanel();
        this.pnlBtns.setLayout(new BoxLayout(this.pnlBtns, 0));
        this.pnlBtns.setBorder(null);
        URL uRL = ClassLoader.getSystemResource("images/folder.png");
        if (uRL == null) {
            this.btn = new JButton("...");
            System.err.println("Can't find images/folder.png");
        } else {
            this.btn = new JButton(new ImageIcon(uRL));
        }
        this.btn.setMargin(null);
        this.btn.setBorder(null);
        this.btn.setToolTipText("Choose a file from the dialog filesystem");
        this.pnlBtns.add(this.btn);
        this.add((Component)this.pnlBtns, "East");
        if (this.combo.getEditor().getEditorComponent() instanceof JComponent) {
            ((JComponent)this.combo.getEditor().getEditorComponent()).setTransferHandler(new SystemTransferHandler());
        }
    }

    public FileTextField(String string, String[] stringArray) {
        this(null, string, stringArray);
    }

    public FileTextField(String string, String string2) {
        this(null, string, new String[]{string2});
    }

    public void setFilePath(String string) {
        this.combo.setSelectedItem(string);
    }

    public void setPathBuilder(PathBuilder pathBuilder) {
        this.builder = pathBuilder;
    }

    public void overrideDocument(Document document) {
        ((JTextField)this.combo.getEditor().getEditorComponent()).setDocument(document);
    }

    public void setPreferenceBinding(String string, String string2) {
        this.prefGroup = string;
        this.prefName = string2;
        if (string != null && string2 != null) {
            this.setCurrentDirectory(Preferences.getPreference(string, string2, (String)null));
        }
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.combo.setEnabled(bl);
        this.btn.setEnabled(bl);
        if (this.btn2 != null) {
            this.btn2.setEnabled(bl);
        }
        if (this.btn3 != null) {
            this.btn3.setEnabled(bl);
        }
    }

    public void setCurrentDirectory(String string) {
        this.currentDir = string;
    }

    public void setDirectoryMode(boolean bl) {
        this.directoryMode = bl;
        if (bl) {
            URL uRL = ClassLoader.getSystemResource("images/folder_new.png");
            if (uRL == null) {
                this.btn2 = new JButton("New");
                System.err.println("Can't find images/folder_new.png");
            } else {
                this.btn2 = new JButton(new ImageIcon(uRL));
            }
            this.btn2.setMargin(null);
            this.btn2.setBorder(null);
            this.btn2.setToolTipText("Create a directory");
            uRL = ClassLoader.getSystemResource("images/folder_delete.png");
            if (uRL == null) {
                this.btn3 = new JButton("Del");
                System.err.println("Can't find images/folder_delete.png");
            } else {
                this.btn3 = new JButton(new ImageIcon(uRL));
            }
            this.btn3.setToolTipText("Delete a file or an empty directory");
            this.btn3.setMargin(null);
            this.btn3.setBorder(null);
            this.pnlBtns.add(this.btn2);
            this.pnlBtns.add(this.btn3);
        }
    }

    public void setFileMode(boolean bl) {
        this.fileMode = bl;
    }

    public void setActionListener(ActionListener actionListener) {
        this.customListener = actionListener;
    }

    public void addNotify() {
        super.addNotify();
        this.btn.addActionListener(this);
        if (this.btn2 != null) {
            this.btn2.addActionListener(this);
        }
        if (this.btn3 != null) {
            this.btn3.addActionListener(this);
        }
        this.combo.addActionListener(this);
        this.combo.addPopupMenuListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.btn.removeActionListener(this);
        if (this.btn2 != null) {
            this.btn2.removeActionListener(this);
        }
        if (this.btn3 != null) {
            this.btn3.removeActionListener(this);
        }
        this.combo.removeActionListener(this);
        this.combo.removePopupMenuListener(this);
    }

    public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
    }

    public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        String[] stringArray;
        if (this.builder != null && (stringArray = this.builder.buildPathsChoice()) != null) {
            this.combo.setModel(new DefaultComboBoxModel<String>(stringArray));
            if (stringArray.length == 1) {
                this.combo.setSelectedIndex(0);
            }
        }
    }

    public void setFileExt(String[] stringArray) {
        this.fileExt = stringArray;
    }

    public void setFileExt(String string) {
        this.fileExt = new String[]{string};
    }

    public String getText() {
        String string = (String)this.combo.getSelectedItem();
        if ("".equals(string)) {
            return null;
        }
        return string;
    }

    public String getText(String string) {
        String string2 = this.getText();
        if (string2 == null) {
            return string;
        }
        return null;
    }

    public void setText(String string) {
        if (!this.directoryMode && this.fileExt != null && this.fileExt.length > 0 && this.fileExt[0] != null && string != null && !"".equals(string) && string.indexOf(".") == -1) {
            string = string + "." + this.fileExt[0];
        }
        this.combo.setSelectedItem(string);
        this.combo.getEditor().setItem(string);
        if (this.prefGroup != null && this.prefName != null && string != null) {
            File file = new File(string);
            if (file.isFile()) {
                file = file.getParentFile();
            }
            Preferences.setPreference(this.prefGroup, this.prefName, file.toString());
        }
    }

    public String getCurrentDirectory() {
        if (this.combo.getSelectedItem() != null && this.getText().length() == 0 || this.getText() == null) {
            return null;
        }
        return new File(this.getText()).getParent();
    }

    public void setOpenedMode(boolean bl) {
        this.openedMode = bl;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string;
        if (actionEvent.getSource() == this.btn2) {
            this.getFileTextFieldHandler().createResource(this.getText());
        } else if (actionEvent.getSource() == this.btn3) {
            this.getFileTextFieldHandler().deleteResource(this.getText());
        } else if (actionEvent.getSource() == this.btn && (string = this.getFileTextFieldHandler().selectResource(this, this.getText(), this.directoryMode, this.fileMode, this.openedMode, this.fileExt, this.currentDir)) != null) {
            this.combo.removeActionListener(this);
            this.setText(string);
            this.combo.addActionListener(this);
        }
        this.fireCustomEvent(actionEvent);
    }

    private void fireCustomEvent(ActionEvent actionEvent) {
        if (this.customListener != null) {
            this.customListener.actionPerformed(new ActionEvent(this, actionEvent.getID(), actionEvent.getActionCommand()));
        }
    }

    public void setFileTextFieldHandler(FileTextFieldHandler fileTextFieldHandler) {
        this.handler = fileTextFieldHandler;
        this.btn2.setEnabled(fileTextFieldHandler == null || fileTextFieldHandler.isCreateResourceManaged());
        this.btn3.setEnabled(fileTextFieldHandler == null || fileTextFieldHandler.isDeleteResourceManaged());
    }

    public FileTextFieldHandler getFileTextFieldHandler() {
        if (this.handler == null) {
            this.handler = new DefaultTextFieldHandler();
        }
        return this.handler;
    }

    class SystemTransferHandler
    extends TransferHandler {
        SystemTransferHandler() {
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return dataFlavorArray[0].isFlavorJavaFileListType() || dataFlavorArray[0].isFlavorTextType();
        }

        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                Object object;
                try {
                    object = (String)transferable.getTransferData(DataFlavor.stringFlavor);
                    if (object != null && jComponent instanceof JTextComponent) {
                        FileTextField.this.setText((String)object);
                        return true;
                    }
                }
                catch (UnsupportedFlavorException unsupportedFlavorException) {
                    // empty catch block
                }
                object = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                if (object != null && object.size() == 1) {
                    String string = object.get(0).toString();
                    if (jComponent instanceof JTextComponent) {
                        FileTextField.this.setText(string);
                    }
                    return true;
                }
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return false;
        }
    }
}

