/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.ui.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToggleButton;

public class VerticalCenterLayout
implements LayoutManager2 {
    private Insets inset;
    private int dividerSize = 0;

    public VerticalCenterLayout() {
    }

    public VerticalCenterLayout(int n) {
        this.setDividerSize(n);
    }

    public void addLayoutComponent(Component component, Object object) {
    }

    public void addLayoutComponent(String string, Component component) {
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public void invalidateLayout(Container container) {
    }

    public void layoutContainer(Container container) {
        Dimension dimension;
        Component component;
        int n;
        int n2 = container.getWidth();
        int n3 = this.dividerSize;
        Insets insets = container.getInsets();
        if (insets != null) {
            n3 += insets.top;
        }
        if (this.inset != null) {
            n3 = this.inset.bottom;
        }
        int n4 = 0;
        for (n = 0; n < container.getComponentCount(); ++n) {
            component = container.getComponent(n);
            dimension = component.getPreferredSize();
            n4 = Math.max(dimension.width, n4);
        }
        for (n = 0; n < container.getComponentCount(); ++n) {
            component = container.getComponent(n);
            dimension = component.getPreferredSize();
            component.setBounds((n2 - n4) / 2 + (insets != null ? insets.left : 0), n3, n4 - (insets != null ? insets.left + insets.right : 0), dimension.height);
            n3 += dimension.height + this.dividerSize;
        }
    }

    public Dimension maximumLayoutSize(Container container) {
        return null;
    }

    public Dimension minimumLayoutSize(Container container) {
        return null;
    }

    public Dimension preferredLayoutSize(Container container) {
        Insets insets;
        int n = container.getWidth();
        int n2 = this.dividerSize;
        if (this.inset != null) {
            n2 = this.inset.bottom;
        }
        if ((insets = container.getInsets()) != null) {
            n2 += insets.top;
        }
        int n3 = 0;
        for (int i = 0; i < container.getComponentCount(); ++i) {
            Component component = container.getComponent(i);
            Dimension dimension = component.getPreferredSize();
            n3 = Math.max(n3, dimension.width + (insets != null ? insets.left + insets.right : 0));
            n2 += dimension.height + this.dividerSize;
        }
        if (this.inset == null) {
            return new Dimension(n3, n2 - this.dividerSize);
        }
        return new Dimension(n3 + this.inset.left + this.inset.right, n2 + this.inset.top - this.dividerSize);
    }

    public void setInset(Insets insets) {
        this.inset = insets;
    }

    public void setDividerSize(int n) {
        this.dividerSize = n;
    }

    public void removeLayoutComponent(Component component) {
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        VerticalCenterLayout verticalCenterLayout = new VerticalCenterLayout();
        JPanel jPanel = new JPanel(verticalCenterLayout);
        verticalCenterLayout.setDividerSize(20);
        jFrame.getContentPane().add(new JScrollPane(jPanel));
        ButtonGroup buttonGroup = new ButtonGroup();
        ImageIcon imageIcon = new ImageIcon(ClassLoader.getSystemResource("images/bug_red.png"));
        for (int i = 0; i < 10; ++i) {
            JToggleButton jToggleButton = new JToggleButton("OK" + i);
            jToggleButton.setVerticalAlignment(3);
            jToggleButton.setHorizontalAlignment(0);
            jToggleButton.setVerticalTextPosition(3);
            jToggleButton.setHorizontalTextPosition(0);
            jToggleButton.setIcon(imageIcon);
            buttonGroup.add((AbstractButton)jPanel.add(jToggleButton));
        }
        jFrame.setBounds(0, 0, 50, 150);
        jFrame.setVisible(true);
    }
}

