/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.spellchecker;

import com.japisoft.framework.spellchecker.Dictionnary;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;

public class AFFDescription {
    private ArrayList prefix;
    private HashMap suffix = new HashMap();

    public AFFDescription(URL uRL) throws IOException {
        this.read(uRL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void read(URL uRL) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(uRL.openStream()));
        try {
            String string = null;
            while ((string = bufferedReader.readLine()) != null) {
                if (string.startsWith("PFX")) {
                    this.scanPrefix(string);
                    continue;
                }
                if (!string.startsWith("SFX")) continue;
                this.scanSuffix(string);
            }
        }
        finally {
            bufferedReader.close();
        }
    }

    public void decline(Dictionnary dictionnary, String string, String string2) {
        for (int i = 0; i < string2.length(); ++i) {
            char c = string2.charAt(i);
            List list = (List)this.suffix.get(new Character(c));
            if (list == null) continue;
            for (int j = 0; j < list.size(); ++j) {
                Rule rule = (Rule)list.get(j);
                String string3 = rule.decline(string);
                if (string3 == null) continue;
                dictionnary.storeWord(string3);
            }
        }
    }

    String removePrefix(String string) {
        if (this.prefix != null) {
            for (int i = 0; i < this.prefix.size(); ++i) {
                String string2 = (String)this.prefix.get(i);
                if (!string.startsWith(string2)) continue;
                return string.substring(string2.length());
            }
        }
        return string;
    }

    private void scanPrefix(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() == 5) {
            if (this.prefix == null) {
                this.prefix = new ArrayList();
            }
            stringTokenizer.nextToken();
            char c = stringTokenizer.nextToken().charAt(0);
            stringTokenizer.nextToken();
            this.prefix.add(stringTokenizer.nextToken());
        }
    }

    private void scanSuffix(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ");
        if (stringTokenizer.countTokens() == 5) {
            stringTokenizer.nextToken();
            char c = stringTokenizer.nextToken().charAt(0);
            ArrayList<Rule> arrayList = (ArrayList<Rule>)this.suffix.get(new Character(c));
            if (arrayList == null) {
                arrayList = new ArrayList<Rule>();
                this.suffix.put(new Character(c), arrayList);
            }
            arrayList.add(new Rule(stringTokenizer.nextToken(), stringTokenizer.nextToken()));
        }
    }

    class Rule {
        private String endPart;
        private String replace;

        Rule(String string, String string2) {
            this.endPart = string;
            this.replace = string2;
        }

        public String decline(String string) {
            if ("0".equals(this.endPart)) {
                return string + this.replace;
            }
            if (string.endsWith(this.endPart)) {
                string = string.substring(0, string.length() - this.endPart.length());
                string = string + this.replace;
                return string;
            }
            return null;
        }
    }
}

