/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.log;

import com.japisoft.framework.log.ConsoleLogger;
import com.japisoft.framework.log.LoggerListener;
import java.util.ArrayList;

public class Logger {
    private static Logger DELEGATE = null;
    private static ArrayList LISTENERS = null;

    public static void addLoggerListener(LoggerListener loggerListener) {
        if (LISTENERS == null) {
            LISTENERS = new ArrayList();
        }
        LISTENERS.add(loggerListener);
    }

    public static void removeLoggerListener(LoggerListener loggerListener) {
        if (LISTENERS != null) {
            LISTENERS.remove(loggerListener);
        }
    }

    public static void setDefaultLogger(Logger logger) {
        DELEGATE = logger;
    }

    public String log(int n, String string) {
        return DELEGATE.log(n, string);
    }

    public void log(Throwable throwable) {
        DELEGATE.log(throwable);
    }

    public static String processMessage(int n, String string) {
        if (DELEGATE == null) {
            DELEGATE = new ConsoleLogger();
        }
        return DELEGATE.log(n, string);
    }

    public static void processException(Throwable throwable) {
        if (DELEGATE == null) {
            DELEGATE = new ConsoleLogger();
        }
        DELEGATE.log(throwable);
    }

    public static void addInfo(String string) {
        string = Logger.processMessage(0, string);
        if (LISTENERS != null) {
            for (int i = 0; i < LISTENERS.size(); ++i) {
                ((LoggerListener)LISTENERS.get(i)).addInfo(string);
            }
        }
    }

    public static void addWarning(String string) {
        string = Logger.processMessage(1, string);
        if (LISTENERS != null) {
            for (int i = 0; i < LISTENERS.size(); ++i) {
                ((LoggerListener)LISTENERS.get(i)).addWarning(string);
            }
        }
    }

    public static void addError(String string) {
        string = Logger.processMessage(2, string);
        if (LISTENERS != null) {
            for (int i = 0; i < LISTENERS.size(); ++i) {
                ((LoggerListener)LISTENERS.get(i)).addError(string);
            }
        }
    }

    public static void addException(Throwable throwable) {
        Logger.processException(throwable);
        if (LISTENERS != null) {
            for (int i = 0; i < LISTENERS.size(); ++i) {
                ((LoggerListener)LISTENERS.get(i)).addException(throwable);
            }
        }
    }
}

