/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.framework.application.descriptor;

import com.japisoft.fastparser.ParseException;
import com.japisoft.fastparser.Parser;
import com.japisoft.fastparser.document.Document;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.walker.AndCriteria;
import com.japisoft.fastparser.walker.AttributeCriteria;
import com.japisoft.fastparser.walker.NodeNameCriteria;
import com.japisoft.fastparser.walker.OrCriteria;
import com.japisoft.fastparser.walker.TreeWalker;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.app.toolkit.Toolkit;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.application.descriptor.InterfaceBuilderException;
import com.japisoft.framework.application.descriptor.helpers.ActionBuilder;
import com.japisoft.framework.application.descriptor.helpers.InterfaceBuilderFactory;
import com.japisoft.framework.application.descriptor.helpers.MenuBuilderDelegate;
import com.japisoft.framework.application.descriptor.helpers.Savable;
import com.japisoft.framework.internationalization.Traductor;
import com.japisoft.framework.preferences.Preferences;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;

public class InterfaceBuilder
implements Savable {
    private URL documentURL;
    private ActionBuilder builder = null;
    private SimpleNode lastRoot = null;
    private Icon appIcon = null;
    private String name = null;
    private Properties rootProperties;
    private JMenuBar menuBar = null;
    private ArrayList builderLst = null;
    private HashMap htGroupAction = null;
    private Hashtable htActions = null;
    private HashMap pushActions = null;
    private HashMap actionIdToUI = null;
    private Hashtable htToolBarsByGroup = null;
    private Hashtable htToolBarsByID = null;
    private Hashtable htPopups = null;
    private Hashtable htActionClassAlias = null;
    private Hashtable htModels;
    public boolean treeModified = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public InterfaceBuilder(URL uRL, ActionBuilder actionBuilder, String string) throws InterfaceBuilderException {
        this.documentURL = uRL;
        this.builder = actionBuilder;
        try {
            InputStream inputStream = uRL.openStream();
            try {
                this.buildUI(inputStream, string);
            }
            finally {
                inputStream.close();
            }
            ApplicationModel.INTERFACE_BUILDER = this;
        }
        catch (IOException iOException) {
            throw new InterfaceBuilderException("Problem reading " + uRL, iOException);
        }
    }

    public InterfaceBuilder(URL uRL, String string) throws InterfaceBuilderException {
        this(uRL, null, string);
    }

    public InterfaceBuilder() {
    }

    public void buildUI(InputStream inputStream, String string) throws InterfaceBuilderException {
        Parser parser = new Parser();
        parser.setInputStream(inputStream);
        try {
            parser.parse();
        }
        catch (ParseException parseException) {
            if (string != null) {
                System.out.println("Corrupted XML descriptor, switching to the default one");
                this.buildUI(ClassLoader.getSystemResourceAsStream(string), null);
            }
            throw new InterfaceBuilderException("Error while parsing " + ApplicationModel.USERINTERFACE_FILE + " at line " + parseException.getLine() + " : " + parseException.getMessage());
        }
        this.buildUI(parser.getDocument());
    }

    private void buildUI(Document document) throws InterfaceBuilderException {
        SimpleNode simpleNode;
        this.lastRoot = simpleNode = (SimpleNode)document.getRoot();
        this.buildUI(simpleNode);
    }

    public Icon getAppIcon() {
        return this.appIcon;
    }

    public String getApplicationName() {
        return this.name;
    }

    private void buildUI(SimpleNode simpleNode) throws InterfaceBuilderException {
        try {
            this.appIcon = Toolkit.getImageIcon(simpleNode.getAttribute("icon"));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.name = simpleNode.getAttribute("name");
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("menuBar"), false);
        if (enumeration.hasMoreElements()) {
            this.buildMenuBar((SimpleNode)enumeration.nextElement());
        }
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("toolBar"), false);
        while (enumeration.hasMoreElements()) {
            this.buildToolBar((SimpleNode)enumeration.nextElement());
        }
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("popup"), false);
        while (enumeration.hasMoreElements()) {
            this.buildPopup((SimpleNode)enumeration.nextElement());
        }
        enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("model"), false);
        while (enumeration.hasMoreElements()) {
            this.buildModel((SimpleNode)enumeration.nextElement());
        }
        this.rootProperties = new Properties();
        for (int i = 0; i < simpleNode.getViewAttributeCount(); ++i) {
            String string = simpleNode.getViewAttributeAt(i);
            String string2 = simpleNode.getViewAttribute(string);
            this.rootProperties.put(string, string2);
        }
    }

    public String getRootProperty(String string) {
        if (this.rootProperties != null) {
            return this.rootProperties.getProperty(string);
        }
        return null;
    }

    private void buildMenuBar(SimpleNode simpleNode) throws InterfaceBuilderException {
        this.menuBar = new JMenuBar();
        simpleNode.setApplicationObject(this.menuBar);
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new NodeNameCriteria("menu"), false);
        while (enumeration.hasMoreElements()) {
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            this.buildMenu(this.menuBar, simpleNode2);
        }
    }

    public JMenuBar getMenuBar() {
        return this.menuBar;
    }

    private void buildMenu(JComponent jComponent, SimpleNode simpleNode) throws InterfaceBuilderException {
        Object object;
        Object object2;
        JMenu jMenu = new JMenu();
        simpleNode.setApplicationObject(jMenu);
        jMenu.setEnabled(simpleNode.childCount() > 1);
        String string = simpleNode.getAttribute("id", "");
        jMenu.setName(string);
        SimpleNode simpleNode2 = simpleNode.childAt(0);
        String string2 = simpleNode2.getAttribute("label", "");
        string2 = Traductor.traduce(string + ".label", string2);
        String string3 = simpleNode2.getAttribute("mnemonic");
        string3 = Traductor.traduce(string + ".mnemonic", string3);
        String string4 = simpleNode2.getAttribute("icon");
        if (string4 != null) {
            jMenu.setIcon(Toolkit.getImageIcon(string4));
        } else if (!(jComponent instanceof JMenuBar)) {
            jMenu.setIcon(Toolkit.getDefaultImage());
        }
        jMenu.setText(string2);
        if (string3 != null && string3.length() > 0) {
            jMenu.setMnemonic(string3.charAt(0));
        }
        if (!"true".equals(simpleNode.getAttribute("dynamic"))) {
            object2 = new TreeWalker(simpleNode);
            object = ((TreeWalker)object2).getNodeByCriteria(new OrCriteria(new OrCriteria(new NodeNameCriteria("itemRef"), new NodeNameCriteria("item")), new OrCriteria(new NodeNameCriteria("menu"), new NodeNameCriteria("separator"))), false);
            while (object.hasMoreElements()) {
                String string5;
                SimpleNode simpleNode3 = (SimpleNode)object.nextElement();
                if (simpleNode3.matchContent("item")) {
                    this.buildMenuItem(jMenu, simpleNode3);
                    continue;
                }
                if (simpleNode3.matchContent("menu")) {
                    this.buildMenu(jMenu, simpleNode3);
                    continue;
                }
                if (simpleNode3.matchContent("separator")) {
                    jMenu.addSeparator();
                    continue;
                }
                if (!simpleNode3.matchContent("itemRef") || (string5 = simpleNode3.getAttribute("ref")) == null) continue;
                if (ActionModel.hasAction(string5)) {
                    jMenu.add(ActionModel.restoreAction(string5));
                    continue;
                }
                throw new InterfaceBuilderException("Can't find action reference " + string5);
            }
        }
        if (!"false".equals(simpleNode.getAttribute("enabled"))) {
            jComponent.add(jMenu);
        }
        if (simpleNode.hasAttribute("builder")) {
            object2 = simpleNode.getAttribute("builder");
            try {
                object = (MenuBuilderDelegate)Class.forName((String)object2).newInstance();
                object.build(jMenu);
                if (this.builderLst == null) {
                    this.builderLst = new ArrayList();
                }
                this.builderLst.add(object);
            }
            catch (Throwable throwable) {
                throw new InterfaceBuilderException("Can't use the menu builder " + (String)object2, throwable);
            }
        }
    }

    public int getBuilderCount() {
        if (this.builderLst == null) {
            return 0;
        }
        return this.builderLst.size();
    }

    public MenuBuilderDelegate getBuilder(int n) {
        return (MenuBuilderDelegate)this.builderLst.get(n);
    }

    public void save() throws Exception {
        for (int i = 0; i < this.getBuilderCount(); ++i) {
            MenuBuilderDelegate menuBuilderDelegate = this.getBuilder(i);
            if (!(menuBuilderDelegate instanceof Savable)) continue;
            Savable savable = (Savable)((Object)menuBuilderDelegate);
            savable.save();
        }
    }

    private void storeActionByGroup(String string, Action action) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ";");
        while (stringTokenizer.hasMoreTokens()) {
            ArrayList<Action> arrayList;
            String string2 = stringTokenizer.nextToken();
            if (this.htGroupAction == null) {
                this.htGroupAction = new HashMap();
            }
            if ((arrayList = (ArrayList<Action>)this.htGroupAction.get(string2)) == null) {
                arrayList = new ArrayList<Action>();
                this.htGroupAction.put(string2, arrayList);
            }
            arrayList.add(action);
        }
    }

    public void setEnabledActionForGroup(String string, boolean bl) {
        if (this.htGroupAction == null) {
            throw new RuntimeException("No group found");
        }
        ArrayList arrayList = (ArrayList)this.htGroupAction.get(string);
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                Action action = (Action)arrayList.get(i);
                action.setEnabled(bl);
            }
        }
    }

    public void setEnabledActionForId(String string, boolean bl) {
        ActionModel.setEnabled(string, bl);
    }

    public boolean isEnabledActionForId(String string) {
        return ActionModel.isEnabled(string);
    }

    public void setEnabledActionForAllGroup(boolean bl) {
        Set set = this.htGroupAction.keySet();
        for (String string : set) {
            if ("*".equals(string)) continue;
            this.setEnabledActionForGroup(string, bl);
        }
    }

    public Action getActionById(String string) {
        if (this.htActions == null) {
            return null;
        }
        return (Action)this.htActions.get(string);
    }

    private Action buildItem(SimpleNode simpleNode) throws InterfaceBuilderException {
        Object object;
        Object object2;
        int n;
        SimpleNode simpleNode2 = null;
        String string = null;
        Integer n2 = null;
        String string2 = null;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        String string6 = null;
        String string7 = null;
        String string8 = null;
        String string9 = null;
        String string10 = null;
        String string11 = null;
        boolean bl = false;
        boolean bl2 = true;
        String string12 = simpleNode.getAttribute("id");
        for (n = 0; n < simpleNode.childCount(); ++n) {
            object2 = simpleNode.childAt(n);
            if (!((SimpleNode)object2).matchContent("ui")) continue;
            simpleNode2 = object2;
            string = simpleNode2.getAttribute("label", "");
            string = Traductor.traduce(string12 + ".label", string);
            object = simpleNode2.getAttribute("mnemonic");
            object = Traductor.traduce(string12 + ".mnemonic", (String)object);
            if (object != null && ((String)object).length() > 0) {
                n2 = new Integer(((String)object).charAt(0));
            }
            string2 = simpleNode2.getAttribute("shortcut");
            string3 = simpleNode2.getAttribute("icon");
            string4 = simpleNode2.getAttribute("icon2");
            string5 = simpleNode2.getAttribute("help");
            string5 = Traductor.traduce(string12 + ".help", string5);
            string6 = simpleNode2.getAttribute("action");
            string7 = simpleNode2.getAttribute("param");
            string8 = simpleNode2.getAttribute("param2");
            string9 = simpleNode2.getAttribute("param3");
            string10 = simpleNode2.getAttribute("param4");
            string11 = simpleNode2.getAttribute("type");
            bl = "true".equals(simpleNode2.getAttribute("selected"));
            if (simpleNode2.hasAttribute("enabled")) {
                bl2 = "true".equals(simpleNode2.getAttribute("enabled"));
                break;
            }
            if (!simpleNode2.getSimpleParent().hasAttribute("enabled")) break;
            bl2 = "true".equals(simpleNode2.getSimpleParent().getAttribute("enabled"));
            break;
        }
        n = 0;
        if (string6 == null) {
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                object = simpleNode.childAt(i);
                if (!((SimpleNode)object).matchContent("action")) continue;
                string6 = ((SimpleNode)object).getAttribute("class");
                if (string6 == null) {
                    throw new InterfaceBuilderException("Action defined but no class attribute at line " + ((SimpleNode)object).getStartingLine());
                }
                string11 = ((SimpleNode)object).getAttribute("type");
                bl = "true".equals(((SimpleNode)object).getAttribute("selected"));
                if (!((SimpleNode)object).hasAttribute("enabled")) break;
                n = "false".equals(((SimpleNode)object).getAttribute("enabled")) ? 1 : 0;
                break;
            }
        }
        try {
            Object object3;
            if (string6 == null) {
                throw new InterfaceBuilderException("Cannot find an action on the node at line " + simpleNode.getStartingLine());
            }
            if (this.hasActionClassName(string6)) {
                string6 = this.getActionClassName(string6);
            }
            if ((object2 = this.builder) == null) {
                object2 = InterfaceBuilderFactory.getActionBuilder();
            }
            if (object2 == null) {
                throw new InterfaceBuilderException("Odd problem : No ActionBuilder Found ??");
            }
            object = object2.buildAction(simpleNode, string6);
            if (object == null) {
                throw new InterfaceBuilderException("Cannot build the action " + string6 + " / name = " + string + " / line = " + simpleNode.getStartingLine());
            }
            if (string12 != null) {
                if (this.htActions == null) {
                    this.htActions = new Hashtable();
                }
                this.htActions.put(string12, object);
            }
            String string13 = null;
            if (simpleNode2 != null) {
                string13 = simpleNode2.getAttribute("group");
            }
            if (string13 == null) {
                string13 = simpleNode.getAttribute("group");
            }
            if (string13 != null) {
                this.storeActionByGroup(string13, (Action)object);
            }
            object.putValue("Name", string);
            if (n2 != null) {
                object.putValue("MnemonicKey", n2);
            }
            if (ApplicationModel.MACOSX_MODE && (object3 = simpleNode2.getAttribute("macShortcut")) != null) {
                string2 = object3;
            }
            if (string2 != null) {
                if (string2.length() == 1) {
                    string2 = Preferences.getPreference("shortcut", string12, string2.charAt(0)) + "";
                }
                object3 = null;
                if (string2.length() > 1) {
                    object3 = KeyStroke.getKeyStroke(string2);
                } else if (string2.length() == 1) {
                    int n3 = string2.charAt(0);
                    int n4 = java.awt.Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
                    if (n3 == 123) {
                        n3 = 37;
                        n4 = 8;
                    } else if (n3 == 125) {
                        n3 = 39;
                        n4 = 8;
                    }
                    object3 = KeyStroke.getKeyStroke(n3, n4);
                }
                object.putValue("AcceleratorKey", object3);
            }
            if (string3 != null) {
                object.putValue("SmallIcon", Toolkit.getImageIcon(string3));
            } else {
                object.putValue("SmallIcon", Toolkit.getDefaultImage());
            }
            if (string4 != null) {
                object.putValue("SmallIcon2", Toolkit.getImageIcon(string4));
            }
            if (string5 != null) {
                object.putValue("ShortDescription", string5);
            }
            if (string7 != null) {
                object.putValue("param", string7);
            }
            if (string8 != null) {
                object.putValue("param2", string8);
            }
            if (string9 != null) {
                object.putValue("param3", string9);
            }
            if (string10 != null) {
                object.putValue("param4", string10);
            }
            if (string11 != null) {
                object.putValue("type", string11);
            }
            if (bl) {
                object.putValue("selected", "true");
            }
            simpleNode.setApplicationObject(object);
            object.setEnabled(bl2);
            if (n != 0) {
                object.setEnabled(false);
            }
            object.putValue("id", simpleNode.getAttribute("id", "?"));
            return object;
        }
        catch (Throwable throwable) {
            if (throwable instanceof InterfaceBuilderException) {
                throw (InterfaceBuilderException)throwable;
            }
            throw new InterfaceBuilderException("Cannot build action " + string6, throwable);
        }
    }

    public void pushAction(Action action, String string) {
        JComponent jComponent;
        if (action == null) {
            return;
        }
        Action action2 = this.getActionById(string);
        if (action2 != null && this.actionIdToUI != null && (jComponent = (JComponent)this.actionIdToUI.get(string)) != null) {
            Stack<Action> stack;
            if (this.pushActions == null) {
                this.pushActions = new HashMap();
            }
            if ((stack = (Stack<Action>)this.pushActions.get(string)) == null) {
                stack = new Stack<Action>();
                this.pushActions.put(string, stack);
            }
            if (jComponent instanceof AbstractButton) {
                if (stack.isEmpty() || stack.peek() != action2) {
                    stack.push(action2);
                }
                ((AbstractButton)jComponent).setAction(action);
                if (action.getValue("Name") == null) {
                    action.putValue("Name", action2.getValue("Name"));
                    action.putValue("ShortDescription", action2.getValue("ShortDescription"));
                    action.putValue("SmallIcon", action2.getValue("SmallIcon"));
                }
                ActionModel.storeAction(string, action);
            }
        }
    }

    public void popAction(String string) {
        Stack stack;
        if (this.pushActions != null && (stack = (Stack)this.pushActions.get(string)) != null && !stack.isEmpty()) {
            Action action = (Action)stack.pop();
            JComponent jComponent = (JComponent)this.actionIdToUI.get(string);
            if (jComponent instanceof AbstractButton) {
                ((AbstractButton)jComponent).setAction(action);
                ActionModel.storeAction(string, action);
            }
        }
    }

    private void buildMenuItem(JMenu jMenu, SimpleNode simpleNode) throws InterfaceBuilderException {
        Action action = this.buildItem(simpleNode);
        JMenuItem jMenuItem = null;
        if ("checkbox".equals(action.getValue("type"))) {
            jMenuItem = new JCheckBoxMenuItem();
            if ("true".equals(action.getValue("selected"))) {
                jMenuItem.setSelected(true);
                jMenuItem.doClick();
            } else {
                jMenuItem.setSelected(false);
            }
        } else {
            jMenuItem = new JMenuItem();
        }
        String string = simpleNode.getAttribute("id", "");
        jMenuItem.setName(string);
        jMenuItem.setAction(action);
        if (this.actionIdToUI == null) {
            this.actionIdToUI = new HashMap();
        }
        this.actionIdToUI.put(string, jMenuItem);
        ActionModel.storeAction(string, action);
        jMenu.add(jMenuItem);
        simpleNode.childAt(0).setApplicationObject(jMenuItem);
    }

    public JToolBar getToolBarByGroup(String string) {
        if (this.htToolBarsByGroup == null) {
            return null;
        }
        return (JToolBar)this.htToolBarsByGroup.get(string);
    }

    public JToolBar getToolBarById(String string) {
        if (this.htToolBarsByID == null) {
            return null;
        }
        return (JToolBar)this.htToolBarsByID.get(string);
    }

    public void setEnabledToolBarContentById(String string, boolean bl) {
        JToolBar jToolBar = this.getToolBarById(string);
        if (jToolBar == null) {
            throw new RuntimeException("Unkonwn toolbar " + string);
        }
        for (int i = 0; i < jToolBar.getComponentCount(); ++i) {
            if (!(jToolBar.getComponent(i) instanceof AbstractButton)) continue;
            AbstractButton abstractButton = (AbstractButton)jToolBar.getComponent(i);
            abstractButton.getAction().setEnabled(bl);
        }
    }

    private void buildToolBar(SimpleNode simpleNode) throws InterfaceBuilderException {
        Object object;
        Object object2;
        if ("false".equals(simpleNode.getAttribute("enabled"))) {
            return;
        }
        String string = simpleNode.getAttribute("id", "?");
        JToolBar jToolBar = new JToolBar();
        jToolBar.setName(string);
        jToolBar.setFloatable(!"false".equals(simpleNode.getAttribute("floatable")));
        simpleNode.setApplicationObject(jToolBar);
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new OrCriteria(new NodeNameCriteria("item"), new OrCriteria(new NodeNameCriteria("separator"), new NodeNameCriteria("itemRef"))), false);
        while (enumeration.hasMoreElements()) {
            object2 = (SimpleNode)enumeration.nextElement();
            if ("item".equals(((SimpleNode)object2).getNodeContent())) {
                object = ((SimpleNode)object2).getAttribute("id", "?");
                Action action = this.buildItem((SimpleNode)object2);
                ActionModel.storeAction((String)object, action);
                jToolBar.add(action);
                continue;
            }
            if ("itemRef".equals(((SimpleNode)object2).getNodeContent())) {
                object = ((SimpleNode)object2).getAttribute("ref", "?");
                if (ActionModel.hasAction((String)object)) {
                    jToolBar.add(ActionModel.restoreAction((String)object));
                    continue;
                }
                if ("?".equals(object)) continue;
                throw new InterfaceBuilderException("Can't find the action reference " + (String)object);
            }
            if (!"separator".equals(((SimpleNode)object2).getNodeContent())) continue;
            jToolBar.addSeparator();
        }
        if (this.htToolBarsByGroup == null) {
            this.htToolBarsByGroup = new Hashtable();
        }
        if (this.htToolBarsByID == null) {
            this.htToolBarsByID = new Hashtable();
        }
        this.htToolBarsByID.put(string, jToolBar);
        object2 = simpleNode.getAttribute("group", "*");
        object = new StringTokenizer((String)object2, ";");
        while (((StringTokenizer)object).hasMoreTokens()) {
            this.htToolBarsByGroup.put(((StringTokenizer)object).nextToken(), jToolBar);
        }
    }

    public boolean hasPopup(String string) {
        if (this.htPopups == null) {
            return false;
        }
        return this.htPopups.containsKey(string);
    }

    public JPopupMenu getPopup(String string) {
        if (this.htPopups == null) {
            return null;
        }
        return (JPopupMenu)this.htPopups.get(string);
    }

    public void setActionClassAlias(String string, String string2) {
        if (this.htActionClassAlias == null) {
            this.htActionClassAlias = new Hashtable();
        }
        this.htActionClassAlias.put(string, string2);
    }

    public String getActionClassName(String string) {
        if (this.htActionClassAlias != null) {
            return (String)this.htActionClassAlias.get(string);
        }
        return null;
    }

    public boolean hasActionClassName(String string) {
        if (this.htActionClassAlias != null) {
            return this.htActionClassAlias.containsKey(string);
        }
        return false;
    }

    private void buildPopup(SimpleNode simpleNode) throws InterfaceBuilderException {
        if ("false".equals(simpleNode.getAttribute("enabled"))) {
            return;
        }
        String string = simpleNode.getAttribute("id", "?");
        JPopupMenu jPopupMenu = new JPopupMenu();
        simpleNode.setApplicationObject(jPopupMenu);
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new OrCriteria(new NodeNameCriteria("item"), new OrCriteria(new NodeNameCriteria("separator"), new OrCriteria(new NodeNameCriteria("menu"), new NodeNameCriteria("itemRef")))), false);
        while (enumeration.hasMoreElements()) {
            String string2;
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            if ("item".equals(simpleNode2.getNodeContent())) {
                string2 = simpleNode2.getAttribute("id", "?");
                Action action = this.buildItem(simpleNode2);
                ActionModel.storeAction(string2, action);
                jPopupMenu.add(action);
                continue;
            }
            if ("itemRef".equals(simpleNode2.getNodeContent())) {
                string2 = simpleNode2.getAttribute("ref", "?");
                if (ActionModel.hasAction(string2)) {
                    jPopupMenu.add(ActionModel.restoreAction(string2));
                    continue;
                }
                if ("?".equals(string2)) continue;
                throw new InterfaceBuilderException("Can't find the action reference " + string2);
            }
            if ("separator".equals(simpleNode2.getNodeContent())) {
                jPopupMenu.addSeparator();
                continue;
            }
            if (!"menu".equals(simpleNode2.getNodeContent())) continue;
            this.buildMenu(jPopupMenu, simpleNode2);
        }
        if (this.htPopups == null) {
            this.htPopups = new Hashtable();
        }
        this.htPopups.put(string, jPopupMenu);
    }

    private void buildModel(SimpleNode simpleNode) throws InterfaceBuilderException {
        ArrayList arrayList = new ArrayList();
        if (this.htModels == null) {
            this.htModels = new Hashtable();
        }
        String string = simpleNode.getAttribute("id", "?");
        ArrayList<Action> arrayList2 = new ArrayList<Action>();
        simpleNode.setApplicationObject(arrayList2);
        this.htModels.put(string, arrayList2);
        TreeWalker treeWalker = new TreeWalker(simpleNode);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new OrCriteria(new NodeNameCriteria("item"), new OrCriteria(new NodeNameCriteria("separator"), new OrCriteria(new NodeNameCriteria("menu"), new NodeNameCriteria("itemRef")))), false);
        while (enumeration.hasMoreElements()) {
            String string2;
            SimpleNode simpleNode2 = (SimpleNode)enumeration.nextElement();
            if (simpleNode2.matchContent("item")) {
                string2 = simpleNode2.getAttribute("id", "?");
                Action action = this.buildItem(simpleNode2);
                ActionModel.storeAction(string2, action);
                arrayList2.add(action);
                continue;
            }
            if (!"itemRef".equals(simpleNode2.getNodeContent()) || !ActionModel.hasAction(string2 = simpleNode2.getAttribute("ref", "?"))) continue;
            arrayList2.add(ActionModel.restoreAction(string2));
        }
    }

    public ArrayList getModel(String string) {
        if (this.htModels != null) {
            return (ArrayList)this.htModels.get(string);
        }
        return null;
    }

    public JMenu getMenu(String string) {
        SimpleNode simpleNode = this.getMenuNode(string);
        if (simpleNode != null) {
            return (JMenu)simpleNode.getApplicationObject();
        }
        return null;
    }

    public SimpleNode getMenuNode(String string) {
        TreeWalker treeWalker = new TreeWalker(this.lastRoot);
        Enumeration enumeration = treeWalker.getNodeByCriteria(new AndCriteria(new NodeNameCriteria("menu"), new AttributeCriteria("id", string)), true);
        if (enumeration.hasMoreElements()) {
            return (SimpleNode)enumeration.nextElement();
        }
        return null;
    }

    public void setEnabledMenu(String string, boolean bl) {
        SimpleNode simpleNode = this.getMenuNode(string);
        if (simpleNode != null) {
            ((JMenu)simpleNode.getApplicationObject()).setEnabled(bl);
        }
    }

    public boolean isApplicationDocumentModified() {
        return this.treeModified;
    }

    public void setApplicationDocumentModified() {
        this.treeModified = true;
    }

    public void saveApplicationDocument() throws InterfaceBuilderException {
        if (this.documentURL == null) {
            throw new InterfaceBuilderException("No Document URL, cannot save this document");
        }
        if ("file".equals(this.documentURL.getProtocol())) {
            String string = this.documentURL.toExternalForm();
            string = string.replaceAll("%20", " ");
            string = string.substring(5);
            try {
                SimpleNode simpleNode = this.getMenuNode("plugin");
                if (simpleNode != null) {
                    while (simpleNode.childCount() > 1) {
                        simpleNode.removeChildNodeAt(1);
                    }
                }
                this.lastRoot.getDocument().write(new FileOutputStream(string));
            }
            catch (Throwable throwable) {
                throw new InterfaceBuilderException("Can't store " + string, throwable);
            }
        } else {
            throw new InterfaceBuilderException("Unknown protocol for saving this document");
        }
    }

    public void removeMenuItemForParam(String string, String string2) {
        SimpleNode simpleNode = this.getMenuNode(string);
        if (simpleNode != null) {
            JMenu jMenu = (JMenu)simpleNode.getApplicationObject();
            for (int i = 0; i < simpleNode.childCount(); ++i) {
                SimpleNode simpleNode2;
                SimpleNode simpleNode3 = simpleNode.childAt(i);
                if (!"item".equals(simpleNode3.getContent()) || (simpleNode2 = simpleNode3.childAt(0)).getAttribute("param") == null || !simpleNode2.getAttribute("param").equals(string2)) continue;
                this.treeModified = true;
                if (simpleNode2.getApplicationObject() != null) {
                    jMenu.remove(i - 1);
                }
                simpleNode.removeChildNode(simpleNode3);
                break;
            }
        }
    }

    public void cleanMenuItems(String string) {
        SimpleNode simpleNode = this.getMenuNode(string);
        if (simpleNode != null) {
            SimpleNode simpleNode2 = simpleNode.childAt(0);
            simpleNode.removeChildrenNodes();
            simpleNode.addChildNode(simpleNode2);
            JMenu jMenu = (JMenu)simpleNode.getApplicationObject();
            jMenu.removeAll();
            if ("true".equals(simpleNode.getAttribute("dynamic"))) {
                jMenu.setEnabled(false);
            }
            this.setApplicationDocumentModified();
        }
    }

    public void insertMenuItemAtFirst(String string, Action action, int n) {
        SimpleNode simpleNode = this.getMenuNode(string);
        if (simpleNode != null) {
            Object object;
            int n2;
            Object object2;
            JMenu jMenu = (JMenu)simpleNode.getApplicationObject();
            this.treeModified = true;
            if (simpleNode.childCount() > n) {
                SimpleNode simpleNode2 = simpleNode.childAt(simpleNode.childCount() - 1);
                object2 = simpleNode.childAt(0);
                simpleNode.removeChildNodeAt(simpleNode.childCount() - 1);
                jMenu.remove(jMenu.getItemCount() - 1);
            }
            for (n2 = 0; n2 < simpleNode.childCount(); ++n2) {
                object2 = simpleNode.childAt(n2);
                if (!"item".equals(((SimpleNode)object2).getContent()) || ((SimpleNode)(object = ((SimpleNode)object2).childAt(0))).getAttribute("param") == null || !((SimpleNode)object).getAttribute("param").equals(action.getValue("param"))) continue;
                if (((SimpleNode)object).getApplicationObject() != null) {
                    jMenu.remove((JMenuItem)((SimpleNode)object).getApplicationObject());
                }
                simpleNode.removeChildNode((SimpleNode)object2);
                break;
            }
            n2 = 0;
            while (n2 < jMenu.getItemCount()) {
                object2 = jMenu.getItem(n2);
                object = ((AbstractButton)object2).getAction();
                if (object.getValue("param") != null && object.getValue("param").equals(action.getValue("param"))) {
                    jMenu.remove(n2);
                    continue;
                }
                ++n2;
            }
            if (action.getValue("iconPath") != null) {
                try {
                    action.putValue("SmallIcon", new ImageIcon(Thread.currentThread().getContextClassLoader().getResource((String)action.getValue("iconPath"))));
                }
                catch (Throwable throwable) {
                    System.err.println("Can't load " + action.getValue("iconPath"));
                }
            }
            object2 = new JMenuItem(action);
            jMenu.insert((JMenuItem)object2, 0);
            if (!jMenu.isEnabled()) {
                jMenu.setEnabled(true);
            }
            object = null;
            object = this.createNodeFromAction("*", action);
            simpleNode.insertChildNode(1, (SimpleNode)object);
            ((SimpleNode)object).childAt(0).setApplicationObject(object2);
        }
    }

    public SimpleNode createModel(String string, ArrayList arrayList) {
        SimpleNode simpleNode = new SimpleNode(1, "model");
        simpleNode.setAttribute("id", string);
        for (int i = 0; i < arrayList.size(); ++i) {
            Action action = (Action)arrayList.get(i);
            SimpleNode simpleNode2 = this.createNodeFromAction(string + "-" + i, action);
            simpleNode.addChildNode(simpleNode2);
        }
        return simpleNode;
    }

    private SimpleNode createNodeFromAction(String string, Action action) {
        SimpleNode simpleNode = new SimpleNode(1, "item");
        simpleNode.setAttribute("id", string);
        SimpleNode simpleNode2 = new SimpleNode(1, "ui");
        simpleNode2.setApplicationObject(action);
        simpleNode2.setAttribute("action", action.getClass().getName());
        simpleNode2.setAttribute("label", (String)action.getValue("Name"));
        if (action.getValue("param") != null) {
            simpleNode2.setAttribute("param", (String)action.getValue("param"));
        }
        if (action.getValue("param2") != null) {
            simpleNode2.setAttribute("param2", (String)action.getValue("param2"));
        }
        if (action.getValue("param3") != null) {
            simpleNode2.setAttribute("param3", (String)action.getValue("param3"));
        }
        if (action.getValue("param4") != null) {
            simpleNode2.setAttribute("param4", (String)action.getValue("param4"));
        }
        if (action.getValue("iconPath") != null) {
            simpleNode2.setAttribute("icon", (String)action.getValue("iconPath"));
        }
        if (action.getValue("type") != null) {
            simpleNode2.setAttribute("type", (String)action.getValue("type"));
        }
        if (action.getValue("selected") != null) {
            simpleNode2.setAttribute("selected", (String)action.getValue("selected"));
        }
        simpleNode.addNode(simpleNode2);
        return simpleNode;
    }
}

