/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.dom;

import com.japisoft.fastparser.dom.DOMExceptionImpl;
import com.japisoft.fastparser.dom.DocumentImpl;
import com.japisoft.fastparser.dom.NamedNodeMapImpl;
import com.japisoft.fastparser.dom.NodeListImpl;
import com.japisoft.fastparser.node.SimpleNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.UserDataHandler;

public class NodeImpl
extends SimpleNode
implements Node {
    private Document ownerDoc = null;

    protected NodeImpl() {
        super(0, null);
    }

    public NodeImpl(int n, String string) {
        super(n, string);
    }

    public NodeImpl(int n, int n2) {
        super(n, n2);
    }

    public String getNodeName() {
        return this.getNodeContent();
    }

    public String getNodeValue() throws DOMException {
        return this.getNodeContent();
    }

    public void setNodeValue(String string) throws DOMException {
        this.setNodeContent(string);
    }

    public short getNodeType() {
        if (this.isText()) {
            return 3;
        }
        if (this.isTag()) {
            return 1;
        }
        if (this.isComment()) {
            return 8;
        }
        return 2;
    }

    public Node getParentNode() {
        return (Node)((Object)this.getSimpleParent());
    }

    public NodeList getChildNodes() {
        return new NodeListImpl(this);
    }

    public Node getLastChild() {
        if (this.childCount() == 0) {
            return null;
        }
        return (Node)((Object)this.childAt(this.childCount() - 1));
    }

    public Node getPreviousSibling() {
        SimpleNode simpleNode = this.getSimpleParent();
        if (simpleNode == null) {
            return null;
        }
        int n = simpleNode.childNodeIndex(this);
        if (n > 0) {
            return (Node)((Object)simpleNode.childAt(n - 1));
        }
        return null;
    }

    public Node getFirstChild() {
        if (this.childCount() == 0) {
            return null;
        }
        return (Node)((Object)this.childAt(0));
    }

    public Node getNextSibling() {
        SimpleNode simpleNode = this.getSimpleParent();
        if (simpleNode == null) {
            return null;
        }
        int n = simpleNode.childNodeIndex(this);
        if (n + 1 <= simpleNode.childCount() - 1) {
            return (Node)((Object)simpleNode.childAt(n + 1));
        }
        return null;
    }

    public NamedNodeMap getAttributes() {
        if (this.isTag()) {
            return new NamedNodeMapImpl(this);
        }
        return null;
    }

    public Document getOwnerDocument() {
        if (this.ownerDoc != null) {
            return this.ownerDoc;
        }
        this.ownerDoc = new DocumentImpl(this.getDocument());
        return this.ownerDoc;
    }

    public void setOwnerDocument(Document document) {
        this.ownerDoc = document;
    }

    public Node insertBefore(Node node, Node node2) throws DOMException {
        SimpleNode simpleNode = this.getSimpleParent();
        if (simpleNode == null) {
            throw new DOMExceptionImpl(3, "Invalid node");
        }
        int n = simpleNode.childNodeIndex((SimpleNode)((Object)node2));
        if (n < 0) {
            throw new DOMExceptionImpl(1, "Invalid reference node");
        }
        simpleNode.insertChildNode(n, (SimpleNode)((Object)node));
        return node;
    }

    public Node replaceChild(Node node, Node node2) throws DOMException {
        this.insertBefore(node, node2);
        this.removeChild(node2);
        return node;
    }

    public Node removeChild(Node node) throws DOMException {
        this.removeChildNode((SimpleNode)((Object)node));
        return node;
    }

    public Node appendChild(Node node) throws DOMException {
        this.addChildNode((SimpleNode)((Object)node));
        return node;
    }

    public boolean hasChildNodes() {
        return !this.isLeaf();
    }

    public Node cloneNode(boolean bl) {
        return (Node)((Object)this.clone(bl));
    }

    public void normalize() {
        throw new RuntimeException("Not supported");
    }

    public boolean isSupported(String string, String string2) {
        return false;
    }

    public String getNamespaceURI() {
        return super.getNameSpaceURI();
    }

    public void setNamespaceURI(String string) {
    }

    public String getPrefix() {
        return this.getNameSpacePrefix();
    }

    public void setPrefix(String string) {
    }

    public String getLocalName() {
        return this.getContent();
    }

    public boolean hasAttributes() {
        return this.getViewAttributes() != null && this.getViewAttributes().hasMoreElements();
    }

    public short compareDocumentPosition(Node node) throws DOMException {
        return 0;
    }

    public String getBaseURI() {
        return null;
    }

    public Object getFeature(String string, String string2) {
        return null;
    }

    public String getTextContent() throws DOMException {
        return null;
    }

    public Object getUserData(String string) {
        return null;
    }

    public boolean isDefaultNamespace(String string) {
        return false;
    }

    public boolean isEqualNode(Node node) {
        return false;
    }

    public boolean isSameNode(Node node) {
        return false;
    }

    public String lookupNamespaceURI(String string) {
        return null;
    }

    public String lookupPrefix(String string) {
        return null;
    }

    public void setTextContent(String string) throws DOMException {
    }

    public Object setUserData(String string, Object object, UserDataHandler userDataHandler) {
        return null;
    }
}

