/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.fastparser.document;

import com.japisoft.fastparser.FastVector;
import com.japisoft.fastparser.node.MutableNode;
import com.japisoft.fastparser.node.NodeFactory;
import com.japisoft.fastparser.node.ViewableNode;
import com.japisoft.fastparser.swing.SwingNodeFactory;
import com.japisoft.fastparser.tools.XMLToolkit;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.Enumeration;

public class Document {
    private NodeFactory nf;
    private String[] elementDictionnary = null;
    private int idCounter = 0;
    private MutableNode root;
    private String indentPrefix = " ";
    int maj = 1;
    int min = 0;
    String encoding = null;
    boolean standalone = false;
    public static String ENCODING_UTF_8 = "UTF-8";
    public static String ENCODING_UTF_16 = "UTF-16";
    public static String ENCODING_ISO_10646_UCS_2 = "ISO-10646-UCS-2";
    public static String ENCODING_ISO_10646_UCS_4 = "ISO-10646-UCS-4";
    public static String ENCODING_ISO_8859_1 = "ISO-8859-1";
    public static String ENCODING_ISO_8859_2 = "ISO-8859-2";
    public static String ENCODING_ISO_8859_3 = "ISO-8859-3";
    public static String ENCODING_ISO_8859_4 = "ISO-8859-4";
    public static String ENCODING_ISO_8859_5 = "ISO-8859-5";
    public static String ENCODING_ISO_8859_6 = "ISO-8859-6";
    public static String ENCODING_ISO_8859_7 = "ISO-8859-7";
    public static String ENCODING_ISO_8859_8 = "ISO-8859-8";
    public static String ENCODING_ISO_8859_9 = "ISO-8859-9";
    public static String ENCODING_ISO_2022_JP = "ISO-2022-JP";
    public static String ENCODING_Shift_JIS = "Shift_JIS";
    public static String ENCODING_EUC_JP = "EUC-JP";
    private FastVector vHeader;
    private FastVector flatNodes;

    public Document() {
    }

    public Document(MutableNode mutableNode) {
        this.setRoot(mutableNode);
    }

    public int getStringId(String string) {
        if (this.elementDictionnary == null) {
            this.elementDictionnary = new String[30];
        }
        for (int i = 0; i < this.elementDictionnary.length && this.elementDictionnary[i] != null; ++i) {
            if (!this.elementDictionnary[i].equals(string)) continue;
            return i;
        }
        if (this.idCounter == this.elementDictionnary.length) {
            String[] stringArray = new String[this.elementDictionnary.length * 2];
            System.arraycopy(this.elementDictionnary, 0, stringArray, 0, this.elementDictionnary.length);
            this.elementDictionnary = stringArray;
        }
        this.elementDictionnary[this.idCounter] = string;
        ++this.idCounter;
        return this.idCounter - 1;
    }

    public String getStringById(int n) {
        return this.elementDictionnary[n];
    }

    public String[] getElementDictionnary() {
        return this.elementDictionnary;
    }

    public NodeFactory getNodeFactory() {
        if (this.nf == null) {
            this.nf = new SwingNodeFactory();
        }
        return this.nf;
    }

    public void setNodeFactory(NodeFactory nodeFactory) {
        this.nf = nodeFactory;
    }

    public void setRoot(MutableNode mutableNode) {
        this.root = mutableNode;
    }

    public MutableNode getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(OutputStream outputStream) throws IOException {
        this.checkRoot();
        String string = this.createView((ViewableNode)((Object)this.root));
        try {
            outputStream.write(string.getBytes());
            outputStream.flush();
        }
        finally {
            outputStream.close();
        }
    }

    private void checkRoot() {
        if (this.root == null) {
            throw new RuntimeException("No document root");
        }
        if (!(this.root instanceof ViewableNode)) {
            throw new RuntimeException("Need a ViewableNode type");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(Writer writer) throws IOException {
        this.checkRoot();
        String string = this.createView((ViewableNode)((Object)this.root));
        try {
            writer.write(string);
        }
        finally {
            writer.close();
        }
    }

    private String createView(ViewableNode viewableNode) {
        StringBuffer stringBuffer = new StringBuffer();
        this.writeHeader(stringBuffer);
        this.writeNode(viewableNode, stringBuffer, 0);
        return stringBuffer.toString();
    }

    public void setIndentPrefix(String string) {
        this.indentPrefix = string;
    }

    private void writeNode(ViewableNode viewableNode, StringBuffer stringBuffer, int n) {
        if (viewableNode.isViewText()) {
            stringBuffer.append(XMLToolkit.resolveCharEntities(viewableNode.getViewContent()));
        } else if (viewableNode.isViewComment()) {
            stringBuffer.append("<!-- " + viewableNode.getViewContent() + "-->");
        } else {
            String string;
            String string2;
            int n2;
            for (int i = 0; i < n; ++i) {
                stringBuffer.append(this.indentPrefix);
            }
            stringBuffer.append("<");
            if (viewableNode.getNameSpacePrefix() != null) {
                stringBuffer.append(viewableNode.getNameSpacePrefix()).append(":");
            }
            stringBuffer.append(viewableNode.getViewContent());
            Enumeration enumeration = viewableNode.getNameSpaceDeclaration();
            if (enumeration != null) {
                stringBuffer.append(" ");
                n2 = 0;
                while (enumeration.hasMoreElements()) {
                    if (n2 != 0) {
                        stringBuffer.append(" ");
                    }
                    string2 = (String)enumeration.nextElement();
                    string = viewableNode.getNameSpaceDeclarationURI(string2);
                    stringBuffer.append("xmlns:").append(string2);
                    stringBuffer.append("=\"").append(string).append("\"");
                    n2 = 1;
                }
            }
            if (viewableNode.getDefaultNamespace() != null) {
                stringBuffer.append(" xmlns=\"").append(viewableNode.getDefaultNamespace()).append("\"");
            }
            if ((enumeration = viewableNode.getViewAttributes()) != null) {
                stringBuffer.append(" ");
                n2 = 0;
                while (enumeration.hasMoreElements()) {
                    if (n2 != 0) {
                        stringBuffer.append(" ");
                    }
                    string2 = (String)enumeration.nextElement();
                    string = viewableNode.getViewAttribute(string2);
                    stringBuffer.append(string2).append("=\"").append(XMLToolkit.resolveCharEntities(string)).append("\"");
                    n2 = 1;
                }
            }
            if (viewableNode.isViewLeaf()) {
                stringBuffer.append("/>");
            } else {
                stringBuffer.append(">\n");
                for (n2 = 0; n2 < viewableNode.getViewChildCount(); ++n2) {
                    this.writeNode(viewableNode.getViewChildAt(n2), stringBuffer, n + 1);
                }
                stringBuffer.append("\n");
                for (n2 = 0; n2 < n; ++n2) {
                    stringBuffer.append(this.indentPrefix);
                }
                if (viewableNode.getNameSpacePrefix() != null) {
                    stringBuffer.append("</" + viewableNode.getNameSpacePrefix() + ":" + viewableNode.getViewContent() + ">\n");
                } else {
                    stringBuffer.append("</" + viewableNode.getViewContent() + ">\n");
                }
            }
        }
    }

    public void setXmlVersion(int n, int n2) {
        this.maj = n;
        this.min = n2;
    }

    public void setEncoding(String string) {
        this.encoding = string;
    }

    public void setStandalone(boolean bl) {
        this.standalone = bl;
    }

    public void setHeaderNode(FastVector fastVector) {
        this.vHeader = fastVector;
    }

    void setFlatNode(FastVector fastVector) {
        this.flatNodes = fastVector;
    }

    public FastVector getFlatNodes() {
        return this.flatNodes;
    }

    private void writeHeader(StringBuffer stringBuffer) {
        stringBuffer.append("<?xml version=\"").append(this.maj).append(".").append(this.min).append("\"");
        if (this.encoding != null) {
            stringBuffer.append(" encoding=\"").append(this.encoding).append("\"");
        }
        if (this.standalone) {
            stringBuffer.append(" standalone=\"").append(this.standalone).append("\"");
        }
        stringBuffer.append("?>\n");
        if (this.vHeader != null) {
            stringBuffer.append("\n");
            for (int i = 0; i < this.vHeader.size(); ++i) {
                ViewableNode viewableNode = (ViewableNode)this.vHeader.get(i);
                stringBuffer.append("<!" + viewableNode.getViewContent() + ">\n");
            }
        }
    }
}

