/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.xslt.debug;

import com.icl.saxon.TransformerFactoryImpl;
import com.japisoft.editix.action.xsl.XSLTAction;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.xslt.debug.SaxonTraceListener;
import com.japisoft.editix.xslt.debug.TracableListener;
import com.japisoft.editix.xslt.profiler.SaxonProfilerListener;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.xmlpad.IXMLPanel;
import com.japisoft.xmlpad.XMLContainer;
import java.io.File;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.SourceLocator;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import org.xml.sax.SAXParseException;

public class XSLTManager {
    static Thread ownerThread = null;
    static XSLTDebugThread thread = null;
    static TracableListener DEBUG_LISTENER = null;
    static SaxonProfilerListener PROFILER_LISTENER = null;

    public static void updateDebugListenerForFactory(IXMLPanel iXMLPanel, TransformerFactory transformerFactory) {
        DEBUG_LISTENER = new SaxonTraceListener(iXMLPanel);
        if (transformerFactory instanceof TransformerFactoryImpl) {
            transformerFactory.setAttribute("http://icl.com/saxon/feature/traceListener", DEBUG_LISTENER);
            transformerFactory.setAttribute("http://icl.com/saxon/feature/linenumbering", Boolean.TRUE);
        } else {
            transformerFactory.setAttribute("http://saxon.sf.net/feature/traceListener", DEBUG_LISTENER);
            transformerFactory.setAttribute("http://saxon.sf.net/feature/compile-with-tracing", Boolean.TRUE);
        }
    }

    public static void updateProfilerListenerForFactory(IXMLPanel iXMLPanel, TransformerFactory transformerFactory) {
        PROFILER_LISTENER = new SaxonProfilerListener(iXMLPanel);
        if (transformerFactory instanceof TransformerFactoryImpl) {
            transformerFactory.setAttribute("http://icl.com/saxon/feature/traceListener", PROFILER_LISTENER);
            transformerFactory.setAttribute("http://icl.com/saxon/feature/linenumbering", Boolean.TRUE);
        } else {
            transformerFactory.setAttribute("http://saxon.sf.net/feature/traceListener", PROFILER_LISTENER);
            transformerFactory.setAttribute("http://saxon.sf.net/feature/compile-with-tracing", Boolean.TRUE);
        }
    }

    public static void endProfiler() {
        PROFILER_LISTENER.stopResult();
        PROFILER_LISTENER = null;
    }

    public static void processError(XMLContainer xMLContainer, TransformerException transformerException) {
        if (xMLContainer == null) {
            return;
        }
        String string = xMLContainer.getCurrentDocumentLocation();
        SourceLocator sourceLocator = transformerException.getLocator();
        String string2 = null;
        int n = -1;
        int n2 = -1;
        if (sourceLocator != null) {
            string2 = sourceLocator.getSystemId();
            if (string2 != null) {
                if (string2.startsWith("file:///")) {
                    string2 = string2.substring(8);
                } else if (string2.startsWith("file://")) {
                    string2 = string2.substring(7);
                }
            } else {
                string2 = string;
            }
        }
        boolean bl = string2 != null && new File(string2).equals(new File(string)) || sourceLocator == null;
        String string3 = transformerException.getMessage();
        if (transformerException.getCause() instanceof SAXParseException) {
            SAXParseException sAXParseException = (SAXParseException)transformerException.getCause();
            n = sAXParseException.getLineNumber();
            n2 = sAXParseException.getColumnNumber();
            string3 = sAXParseException.getMessage();
            sourceLocator = null;
        }
        if (sourceLocator != null) {
            n = sourceLocator.getLineNumber();
            n2 = sourceLocator.getColumnNumber();
        }
        if ("java.lang.NullPointerException".equals(string3)) {
            string3 = "Unknown error - No message from the transformer";
        }
        xMLContainer.getErrorManager().notifyError(null, bl, string2, n, n2, -1, string3, false);
    }

    public static boolean hasBreakpoint(IXMLPanel iXMLPanel) {
        return iXMLPanel.getBookmarkContext().getModel().getBookmarkCount() != 0;
    }

    public static void startDebug(IXMLPanel iXMLPanel) {
        ownerThread = Thread.currentThread();
        if (!XSLTManager.hasBreakpoint(iXMLPanel)) {
            EditixFactory.buildAndShowErrorDialog("No breakpoint found !");
            return;
        }
        ActionModel.setEnabled("lastTransform", false);
        ActionModel.setEnabled("transformFromXSLT", false);
        ActionModel.setEnabled("xsltdebug1", false);
        ActionModel.setEnabled("xsltdebug3", true);
        ActionModel.setEnabled("xsltdebug4", true);
        ActionModel.setEnabled("xsltdebug5", true);
        if (thread != null) {
            thread.continueBreakpoint();
        } else {
            thread = new XSLTDebugThread(iXMLPanel);
            thread.start();
        }
    }

    public static void continueToBreakPoint() {
        if (thread != null) {
            thread.continueBreakpoint();
        }
    }

    public static void continueToNextElement() {
        if (thread != null) {
            thread.continueNextElement();
        }
    }

    public static void terminate() {
        if (thread != null) {
            thread.terminateAll();
        }
    }

    static class XSLTDebugThread
    extends Thread {
        IXMLPanel container = null;
        boolean status = true;

        public XSLTDebugThread(IXMLPanel iXMLPanel) {
            this.container = iXMLPanel;
        }

        public void continueBreakpoint() {
            if (DEBUG_LISTENER != null) {
                DEBUG_LISTENER.continueBreakpoint();
            }
        }

        public void continueNextElement() {
            if (DEBUG_LISTENER != null) {
                DEBUG_LISTENER.continueNextElement();
            }
        }

        public void terminateAll() {
            if (DEBUG_LISTENER != null) {
                DEBUG_LISTENER.terminateAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                this.run2();
            }
            finally {
                this.container = null;
                thread = null;
                if (DEBUG_LISTENER != null) {
                    DEBUG_LISTENER.dispose();
                }
                DEBUG_LISTENER = null;
                ActionModel.setEnabled("lastTransform", true);
                ActionModel.setEnabled("transformFromXSLT", true);
                ActionModel.setEnabled("xsltdebug1", true);
                ActionModel.setEnabled("xsltdebug3", false);
                ActionModel.setEnabled("xsltdebug4", false);
                ActionModel.setEnabled("xsltdebug5", false);
            }
        }

        public void run2() {
            ErrorListener errorListener = (ErrorListener)((Object)ActionModel.restoreAction("transformWithXSLT"));
            XSLTAction.applyTransformation(this.container, true, true, false, errorListener);
        }
    }
}

