/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.universalbrowser;

import com.japisoft.editix.action.file.BrowseZIPAction;
import com.japisoft.editix.action.file.OpenAction;
import com.japisoft.editix.action.panels.PanelAction;
import com.japisoft.editix.toolkit.Toolkit;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.panels.AbstractPanel;
import com.japisoft.editix.ui.panels.Panel;
import com.japisoft.editix.ui.panels.universalbrowser.FTPConfig;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.preferences.Preferences;
import com.japisoft.framework.toolkit.FileToolkit;
import com.japisoft.framework.xml.XMLFileData;
import com.japisoft.framework.xml.XMLToolkit;
import com.japisoft.universalbrowser.JUniversalBrowserTree;
import com.japisoft.universalbrowser.UniversalBrowserListener;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.StringTokenizer;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import org.apache.commons.vfs.FileContent;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.FileSystemOptions;
import org.apache.commons.vfs.UserAuthenticator;
import org.apache.commons.vfs.VFS;
import org.apache.commons.vfs.auth.StaticUserAuthenticator;
import org.apache.commons.vfs.impl.DefaultFileSystemConfigBuilder;
import org.apache.commons.vfs.provider.zip.ZipFileSystem;

public abstract class CommonUniversalBrowserPanel
extends AbstractPanel
implements UniversalBrowserListener {
    private static FileObject mustBrowse = null;
    private JUniversalBrowserTree browserTree = null;
    private String initURI = null;
    private FileSystemOptions initOpts = null;
    private FTPConfig initFTPConfig = null;
    private JPanel ui = null;
    private JComboBox filter = null;

    protected JComponent buildView() {
        this.initUIComponent();
        return this.ui;
    }

    public void close() {
        if (this.browserTree != null) {
            this.browserTree.close();
        }
    }

    public void select(Object object) {
        this.browse(this.initURI, null, null);
        this.browserTree.select((String)object);
    }

    public void init() {
        super.init();
        String string = Preferences.getPreference(Preferences.SYSTEM_GP, this.getClass().getName(), (String)null);
        String string2 = null;
        String string3 = null;
        if (string != null) {
            string2 = Preferences.getPreference(Preferences.SYSTEM_GP, this.getClass().getName() + ".user", (String)null);
            string3 = Preferences.getPreference(Preferences.SYSTEM_GP, this.getClass().getName() + ".password", (String)null);
        }
        this.browse(string, string2, string3);
    }

    public void browse(String string, String string2, String string3) {
        FTPConfig fTPConfig = null;
        if (string2 != null) {
            fTPConfig = new FTPConfig();
            fTPConfig.user = string2;
            fTPConfig.password = string3;
        }
        FileSystemOptions fileSystemOptions = null;
        if (string2 != null) {
            StaticUserAuthenticator staticUserAuthenticator = new StaticUserAuthenticator(null, string2, string3);
            fileSystemOptions = new FileSystemOptions();
            try {
                DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(fileSystemOptions, staticUserAuthenticator);
            }
            catch (FileSystemException fileSystemException) {
                // empty catch block
            }
        }
        this.initURI = string;
        this.initOpts = fileSystemOptions;
        this.initFTPConfig = fTPConfig;
        if (this.isVisible()) {
            this.synchronizedBrowser();
        }
    }

    protected void preShow() {
        this.synchronizedBrowser();
        if (this.browserTree != null) {
            this.browserTree.setUnivervalBrowserListener(this);
        }
    }

    private void synchronizedBrowser() {
        try {
            this.initUIComponent();
            FileSystemManager fileSystemManager = VFS.getManager();
            if (this.initOpts != null) {
                this.browserTree.browse(fileSystemManager.resolveFile(this.initURI, this.initOpts));
            } else {
                this.browserTree.browse(fileSystemManager.resolveFile(this.initURI));
            }
        }
        catch (FileSystemException fileSystemException) {
            ApplicationModel.debug(fileSystemException);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    protected boolean storeLastBrowsedFileObject() {
        return true;
    }

    public void stop() {
        FileObject fileObject;
        if (this.browserTree == null) {
            return;
        }
        if (this.storeLastBrowsedFileObject() && (fileObject = this.browserTree.getBrowsedFileObject()) != null) {
            Preferences.setPreference(Preferences.SYSTEM_GP, this.getClass().getName(), fileObject.getName().getRootURI());
            if (this.initFTPConfig != null) {
                Preferences.setPreference(Preferences.SYSTEM_GP, this.getClass().getName() + ".user", this.initFTPConfig.user);
                Preferences.setPreference(Preferences.SYSTEM_GP, this.getClass().getName() + ".password", this.initFTPConfig.password);
            }
        }
        this.browserTree.close();
    }

    protected Action[] getBrowserActions() {
        return null;
    }

    private void initUIComponent() {
        if (this.browserTree == null) {
            this.browserTree = EditixFactory.getUniversalBrowserTree();
            this.browserTree.setUnivervalBrowserListener(this);
            if (mustBrowse != null) {
                this.browserTree.browse(mustBrowse);
            }
            mustBrowse = null;
            this.ui = new JPanel();
            this.ui.setLayout(new BorderLayout());
            this.ui.add(new JScrollPane(this.browserTree));
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BorderLayout());
            jPanel.add((Component)new JButton(new OpenToolbarAction()), "East");
            this.filter = EditixFactory.getFileFilterComboBox();
            this.filter.insertItemAt("AUTOMATIC", 0);
            this.filter.setSelectedIndex(0);
            this.filter.setPreferredSize(new Dimension(100, 0));
            jPanel.add((Component)this.filter, "Center");
            jPanel.add((Component)new JLabel("Open as"), "West");
            this.ui.add((Component)jPanel, "North");
            Action[] actionArray = this.getBrowserActions();
            if (actionArray != null) {
                JToolBar jToolBar = new JToolBar();
                for (int i = 0; i < actionArray.length; ++i) {
                    jToolBar.add(actionArray[i]);
                }
                jToolBar.setFloatable(false);
                this.ui.add((Component)jToolBar, "South");
            }
        }
    }

    protected void hide() {
        super.hide();
        this.browserTree.setUnivervalBrowserListener(null);
    }

    public static boolean openFile(String string, String string2, String string3) {
        try {
            Object object;
            FileSystemManager fileSystemManager = VFS.getManager();
            FileSystemOptions fileSystemOptions = null;
            String string4 = null;
            String string5 = null;
            if (string3 != null) {
                Object object2;
                object = new StringTokenizer(string3, ";");
                while (((StringTokenizer)object).hasMoreTokens()) {
                    object2 = ((StringTokenizer)object).nextToken();
                    int n = ((String)object2).indexOf("=");
                    if (n <= -1) continue;
                    String string6 = ((String)object2).substring(0, n);
                    String string7 = ((String)object2).substring(n + 1);
                    if ("vfs.user".equals(string6)) {
                        string4 = string7;
                        continue;
                    }
                    if (!"vfs.password".equals(string6)) continue;
                    string5 = string7;
                }
                object2 = new StaticUserAuthenticator(null, string4, string5);
                fileSystemOptions = new FileSystemOptions();
                DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(fileSystemOptions, (UserAuthenticator)object2);
            }
            object = null;
            object = fileSystemOptions != null ? fileSystemManager.resolveFile(string, fileSystemOptions) : fileSystemManager.resolveFile(string);
            return CommonUniversalBrowserPanel.open((FileObject)object, string2, string4, string5);
        }
        catch (FileSystemException fileSystemException) {
            return false;
        }
    }

    public static boolean save(XMLContainer xMLContainer) {
        block15: {
            String string = xMLContainer.getDocumentInfo().getCurrentDocumentLocation();
            try {
                Object object;
                String string2;
                Object object2;
                FileSystemManager fileSystemManager = VFS.getManager();
                FileSystemOptions fileSystemOptions = null;
                if (xMLContainer.hasProperty("vfs.user")) {
                    object2 = (String)xMLContainer.getProperty("vfs.user");
                    string2 = (String)xMLContainer.getProperty("vfs.password");
                    object = new StaticUserAuthenticator(null, (String)object2, string2);
                    fileSystemOptions = new FileSystemOptions();
                    DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(fileSystemOptions, (UserAuthenticator)object);
                }
                object2 = null;
                object2 = fileSystemOptions != null ? fileSystemManager.resolveFile(string, fileSystemOptions) : fileSystemManager.resolveFile(string);
                string2 = xMLContainer.getDocumentInfo().getEncoding();
                object = xMLContainer.getText();
                if ((string2 == null || "AUTOMATIC".equals(string2)) && ((string2 = XMLToolkit.getXMLEncoding((String)object)) == null || "AUTOMATIC".equals(string2))) {
                    string2 = "UTF-8";
                }
                if (object2.isWriteable()) {
                    OutputStream outputStream = object2.getContent().getOutputStream();
                    try {
                        OutputStreamWriter outputStreamWriter = new OutputStreamWriter(outputStream, string2);
                        outputStreamWriter.write((String)object);
                        outputStreamWriter.close();
                        xMLContainer.setModifiedState(false);
                        break block15;
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {
                        return false;
                    }
                    catch (IOException iOException) {
                        ApplicationModel.debug(iOException);
                        return false;
                    }
                }
                if (object2.getFileSystem() instanceof ZipFileSystem) {
                    String string3;
                    File file;
                    int n = string.lastIndexOf("!/");
                    String string4 = string.substring(n + 2);
                    int n2 = string.lastIndexOf("file:///");
                    if (n2 > -1 && (file = new File(string3 = string.substring(n2 + 8, n))).exists()) {
                        try {
                            PanelAction panelAction = (PanelAction)ActionModel.restoreAction("openZip");
                            Panel panel = null;
                            if (panelAction != null && panelAction.isPrepared()) {
                                panel = panelAction.preparePanel();
                            }
                            if (panel != null) {
                                panel.close();
                            }
                            boolean bl = FileToolkit.writeToZip(file, string4, string2, (String)object);
                            xMLContainer.setModifiedState(false);
                            if (panel != null) {
                                panel.select(string);
                            }
                            return bl;
                        }
                        catch (IOException iOException) {
                            return false;
                        }
                    }
                }
                return false;
            }
            catch (FileSystemException fileSystemException) {
                return false;
            }
        }
        return true;
    }

    public static boolean open(FileObject fileObject, String string, String string2, String string3) {
        try {
            if (fileObject.isReadable()) {
                String string4 = fileObject.getName().getURI();
                boolean bl = false;
                if (string4.startsWith("file:///")) {
                    if ((string4 = string4.substring(8)).indexOf(":") == -1) {
                        string4 = "/" + string4;
                    }
                    bl = true;
                }
                if (bl && BrowseZIPAction.isFileArchive(string4) && OpenAction.manageZIPFile(new File(string4))) {
                    return true;
                }
                FileContent fileContent = fileObject.getContent();
                InputStream inputStream = fileContent.getInputStream();
                try {
                    XMLFileData xMLFileData = XMLToolkit.getContentFromInputStream(inputStream, Toolkit.getCurrentFileEncoding());
                    String string5 = null;
                    if (string2 != null && string3 != null) {
                        string5 = "vfs.user=" + string2 + ";" + "vfs.password=" + string3;
                    }
                    if (bl) {
                        xMLFileData.modifiedDate = new File(string4).lastModified();
                    }
                    return OpenAction.openFile(string, false, null, string4, string5, xMLFileData);
                }
                catch (Throwable throwable) {
                    EditixFactory.buildAndShowErrorDialog("Can't open " + fileObject.getName().getBaseName());
                }
            } else {
                EditixFactory.buildAndShowWarningDialog("Can't open " + fileObject.getName().getBaseName());
            }
        }
        catch (FileSystemException fileSystemException) {
            EditixFactory.buildAndShowErrorDialog("Can't open " + fileObject.getName().getBaseName());
        }
        return false;
    }

    public void doubleClick(FileObject fileObject) {
        String string = null;
        String string2 = null;
        if (this.initFTPConfig != null) {
            string = this.initFTPConfig.user;
            string2 = this.initFTPConfig.password;
        }
        CommonUniversalBrowserPanel.open(fileObject, null, string, string2);
    }

    public void select(FileObject fileObject) {
    }

    class OpenToolbarAction
    extends AbstractAction {
        public OpenToolbarAction() {
            this.putValue("ShortDescription", "Open the selected ressource");
            this.putValue("SmallIcon", ActionModel.getIconActionById("open"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = CommonUniversalBrowserPanel.this.filter.getSelectedItem();
            String string = null;
            String string2 = null;
            if (CommonUniversalBrowserPanel.this.initFTPConfig != null) {
                string = ((CommonUniversalBrowserPanel)CommonUniversalBrowserPanel.this).initFTPConfig.user;
                string2 = ((CommonUniversalBrowserPanel)CommonUniversalBrowserPanel.this).initFTPConfig.password;
            }
            if ("AUTOMATIC".equals(object)) {
                CommonUniversalBrowserPanel.open(CommonUniversalBrowserPanel.this.browserTree.getSelectedFileObject(), null, string, string2);
            } else {
                EditixFactory.XMLDocumentInfoFileFilter xMLDocumentInfoFileFilter = (EditixFactory.XMLDocumentInfoFileFilter)object;
                CommonUniversalBrowserPanel.open(CommonUniversalBrowserPanel.this.browserTree.getSelectedFileObject(), xMLDocumentInfoFileFilter.getType(), string, string2);
            }
        }
    }
}

