/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels.snippet;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.snippet.SnippetTool;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.fastparser.swing.SwingNode;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.ui.FastLabel;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.UIManager;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

public class SnippetUI
extends JPanel
implements MouseListener,
MouseMotionListener,
ActionListener,
TreeSelectionListener {
    static final String[] TOOLBAR_ACTIONS = new String[]{"insert", "add", "addd", "ren", "del"};
    static final String[] POPUP_ACTIONS = new String[]{"insert", "add", "addd", "ren", "any", "hlp", "del"};
    private JTree t;
    private JToolBar tb;
    private NodeTransfertHandler th;
    boolean dragAndDropInUse = false;
    private HashMap mapResolveOcc = null;
    DataFlavor[] flavors = new DataFlavor[]{DataFlavor.stringFlavor};

    public SnippetUI() {
        this.setLayout(new BorderLayout());
        this.tb = new JToolBar();
        for (int i = 0; i < TOOLBAR_ACTIONS.length; ++i) {
            this.tb.add(EditixFrame.ACCESSOR.getBuilder().getActionById("snp." + TOOLBAR_ACTIONS[i]));
        }
        this.add((Component)this.tb, "North");
        this.t = new JTree();
        this.add((Component)new JScrollPane(this.t), "Center");
        this.clean();
        this.t.setCellRenderer(new SnippetRenderer());
        this.th = new NodeTransfertHandler();
        this.t.setTransferHandler(this.th);
        this.setEnabledAction("del", false);
    }

    private JPopupMenu buildPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        for (int i = 0; i < POPUP_ACTIONS.length; ++i) {
            if (POPUP_ACTIONS[i] == null) {
                jPopupMenu.addSeparator();
                continue;
            }
            jPopupMenu.add(EditixFrame.ACCESSOR.getBuilder().getActionById("snp." + POPUP_ACTIONS[i]));
        }
        return jPopupMenu;
    }

    void init() {
        this.t.setSelectionPath(new TreePath(this.t.getModel().getRoot()));
        this.valueChanged(null);
    }

    public void addNotify() {
        super.addNotify();
        this.t.addMouseListener(this);
        this.t.addMouseMotionListener(this);
        this.t.addTreeSelectionListener(this);
    }

    public void removeNotify() {
        super.removeNotify();
        this.t.removeMouseListener(this);
        this.t.removeMouseMotionListener(this);
        this.t.removeTreeSelectionListener(this);
    }

    void setEnabledAction(String string, boolean bl) {
        ActionModel.setEnabled("snp." + string, bl);
    }

    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        TreePath treePath = this.t.getSelectionPath();
        if (treePath != null) {
            SimpleNode simpleNode = (SimpleNode)treePath.getLastPathComponent();
            this.setEnabledAction("del", !simpleNode.isRoot() || simpleNode.isAttribute());
            this.setEnabledAction("add", simpleNode.isRoot() || simpleNode.matchContent("group") || simpleNode.matchContent("item"));
            this.setEnabledAction("addd", simpleNode.isRoot() || simpleNode.matchContent("group"));
            this.setEnabledAction("ren", simpleNode.isRoot() || simpleNode.matchContent("group") || simpleNode.matchContent("item") || simpleNode.isAttribute());
            this.setEnabledAction("insert", simpleNode.matchContent("item"));
            this.setEnabledAction("any", simpleNode.matchContent("item") && simpleNode.isTag());
            this.setEnabledAction("hlp", simpleNode.matchContent("item") && simpleNode.isTag());
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        SimpleNode simpleNode;
        String string;
        String string2 = actionEvent.getActionCommand();
        if (this.t.getSelectionPath() == null) {
            return;
        }
        if ("add".equals(string2)) {
            this.addSnippet();
        } else if ("addd".equals(string2)) {
            this.addGroup();
        } else if ("del".equals(string2)) {
            this.delete();
        } else if ("ren".equals(string2)) {
            this.rename((SimpleNode)this.t.getSelectionPath().getLastPathComponent());
        } else if ("insert".equals(string2)) {
            this.insertSelectedItem();
        } else if ("any".equals(string2)) {
            SimpleNode simpleNode2 = (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
            String string3 = simpleNode2.getAttribute("param", "");
            int n = string3.indexOf("*");
            string3 = n > -1 ? string3.substring(0, n) + string3.substring(n + 1) : string3 + "*";
            simpleNode2.setAttribute("param", string3);
        } else if ("hlp".equals(string2) && (string = EditixFactory.buildAndShowInputDialog("Help", (simpleNode = (SimpleNode)this.t.getSelectionPath().getLastPathComponent()).getAttribute("hlp", ""))) != null) {
            simpleNode.setAttribute("hlp", string);
        }
        this.refresh();
    }

    void refresh() {
        TreePath treePath = this.t.getSelectionPath();
        ((SnippetTreeModel)this.t.getModel()).refresh();
        this.t.repaint();
        if (treePath != null) {
            this.t.setSelectionPath(treePath);
        }
    }

    private void addSnippet() {
        if (this.t.getSelectionPath() == null) {
            EditixFactory.buildAndShowWarningDialog("No selected node ?");
            return;
        }
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        SimpleNode simpleNode = (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
        if (xMLContainer == null) {
            EditixFactory.buildAndShowErrorDialog("You need to have an opened XML document for adding a snippet !");
        } else {
            SimpleNode simpleNode2 = null;
            if (xMLContainer.getTree() != null && xMLContainer.getTree().getSelectionPath() != null && (simpleNode2 = (SimpleNode)xMLContainer.getTree().getSelectionPath().getLastPathComponent()).isText()) {
                simpleNode2 = simpleNode2.getSimpleParent();
            }
            if (simpleNode2 == null) {
                EditixFactory.buildAndShowWarningDialog("Please select an element before adding");
            } else {
                String string = simpleNode2.getContent();
                if (simpleNode2.getNameSpacePrefix() != null) {
                    string = simpleNode2.getNameSpacePrefix() + ":" + string;
                }
                SwingNode swingNode = new SwingNode("item");
                swingNode.setAttribute("name", string);
                if (simpleNode2.hasTextChildNode()) {
                    swingNode.setAttribute("param", "T");
                } else {
                    swingNode.setAttribute("param", "-");
                }
                for (int i = 0; i < simpleNode2.getViewAttributeCount(); ++i) {
                    String string2 = simpleNode2.getViewAttributeAt(i);
                    swingNode.setAttribute("att" + i, string2 + "=" + simpleNode2.getAttribute(string2));
                }
                simpleNode.addChildNode(swingNode);
                this.selectNode(swingNode);
            }
        }
    }

    private void addGroup() {
        String string = EditixFactory.buildAndShowInputDialog("Group name ?");
        if (string != null) {
            SimpleNode simpleNode = (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
            SwingNode swingNode = new SwingNode("group");
            swingNode.setAttribute("name", string);
            simpleNode.addChildNode(swingNode);
            this.selectNode(swingNode);
        }
    }

    private void delete() {
        TreePath[] treePathArray = this.t.getSelectionPaths();
        if (treePathArray != null) {
            for (int i = 0; i < treePathArray.length; ++i) {
                SimpleNode simpleNode = (SimpleNode)treePathArray[i].getLastPathComponent();
                SimpleNode simpleNode2 = simpleNode.getSimpleParent();
                if (simpleNode.matchContent("group")) {
                    if (!EditixFactory.buildAndShowConfirmDialog("Please confirm you wish to delete " + simpleNode.getAttribute("name"))) {
                        continue;
                    }
                } else if (simpleNode.isAttribute()) {
                    simpleNode2.setAttribute(simpleNode.getContent(), null);
                }
                simpleNode2.removeChildNode(simpleNode);
                this.selectNode(simpleNode2);
            }
        }
    }

    private TreePath convertToTreePath(SimpleNode simpleNode) {
        ArrayList<SimpleNode> arrayList = new ArrayList<SimpleNode>();
        while (simpleNode != null) {
            arrayList.add(0, simpleNode);
            simpleNode = simpleNode.getSimpleParent();
        }
        return new TreePath(arrayList.toArray());
    }

    private void selectNode(SimpleNode simpleNode) {
        final SimpleNode simpleNode2 = simpleNode;
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                TreePath treePath = SnippetUI.this.convertToTreePath(simpleNode2);
                SnippetUI.this.t.setSelectionPath(treePath);
            }
        });
    }

    public void clean() {
        try {
            this.t.setModel(new SnippetTreeModel(SnippetTool.getRoot()));
            this.t.setSelectionPath(new TreePath(SnippetTool.getRoot()));
        }
        catch (IOException iOException) {
            EditixFactory.buildAndShowErrorDialog("Can't load the snippet file " + iOException.getMessage());
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        TreePath treePath;
        if (!this.dragAndDropInUse && (treePath = this.t.getPathForLocation(mouseEvent.getX(), mouseEvent.getY())) != null && !((SimpleNode)treePath.getLastPathComponent()).isAttribute()) {
            this.th.exportAsDrag(this.t, mouseEvent, 2);
            if (treePath != null) {
                this.t.setSelectionPath(treePath);
            }
            this.dragAndDropInUse = true;
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.dragAndDropInUse = false;
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        TreePath treePath = this.t.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
        if (treePath != null) {
            SimpleNode simpleNode = (SimpleNode)treePath.getLastPathComponent();
            String string = simpleNode.getAttribute("path");
            ((SnippetRenderer)this.t.getCellRenderer()).fastlabel.setToolTipText(string);
            this.t.setToolTipText(string);
            ((JComponent)this.t.getParent()).setToolTipText(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() || mouseEvent.getButton() >= 2) {
            JPopupMenu jPopupMenu = this.buildPopupMenu();
            jPopupMenu.show((Component)mouseEvent.getSource(), mouseEvent.getX(), mouseEvent.getY());
            return;
        }
        if (mouseEvent.getClickCount() >= 2) {
            this.insertSelectedItem();
        }
    }

    private void insertSelectedItem() {
        if (this.t.getSelectionPath() == null) {
            return;
        }
        SimpleNode simpleNode = (SimpleNode)this.t.getSelectionPath().getLastPathComponent();
        if (simpleNode.matchContent("item")) {
            XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
            if (xMLContainer == null) {
                EditixFactory.buildAndShowErrorDialog("No document found for inserting a snippet");
                return;
            }
            String string = xMLContainer.getEditor().getSelectedText();
            String string2 = this.resolveNodeToXMLText(simpleNode);
            if (string != null) {
                string2 = string2.replaceFirst("=T=", string);
                string2 = string2.replaceAll("=T=", "");
                xMLContainer.getEditor().replaceSelection(string2);
            } else {
                string2 = string2.replaceAll("=T=", "");
                xMLContainer.getEditor().insertText(string2);
            }
        }
    }

    private void rename(SimpleNode simpleNode) {
        String string = simpleNode.isAttribute() ? simpleNode.getNodeValue() : simpleNode.getAttribute("name");
        String string2 = EditixFactory.buildAndShowInputDialog("New name", string);
        if (string2 != null) {
            if (!simpleNode.isAttribute()) {
                StringBuffer stringBuffer = new StringBuffer();
                for (int i = 0; i < string2.length(); ++i) {
                    if (!Character.isLetterOrDigit(string2.charAt(i))) continue;
                    stringBuffer.append(string2.charAt(i));
                }
                if (stringBuffer.length() == 0) {
                    if (simpleNode.matchContent("group")) {
                        stringBuffer.append("My nodes");
                    } else {
                        stringBuffer.append("myElement");
                    }
                }
                string2 = stringBuffer.toString();
            } else if (string2 == null || string2.indexOf("=") == -1) {
                string2 = "myAtt=myVal";
            }
            if (simpleNode.isAttribute()) {
                simpleNode.setNodeValue(string2);
            } else if (!string2.equals(string)) {
                simpleNode.setAttribute("name", string2);
                this.refresh();
            }
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    private String resolveNodeToXMLText(SimpleNode simpleNode) {
        this.mapResolveOcc = null;
        SimpleNode simpleNode2 = this.extractXMLNode(simpleNode);
        this.resolveNodes(simpleNode, simpleNode2);
        this.mapResolveOcc = null;
        return simpleNode2.getRawXML();
    }

    private SimpleNode extractXMLNode(SimpleNode simpleNode) {
        String string;
        SimpleNode simpleNode2 = new SimpleNode(simpleNode.getAttribute("name"));
        for (int i = 0; i < 100 && (string = simpleNode.getAttribute("att" + i)) != null; ++i) {
            int n = string.indexOf("=");
            if (n <= -1) continue;
            simpleNode2.setAttribute(string.substring(0, n), string.substring(n + 1));
        }
        if (simpleNode.getAttribute("param") != null && simpleNode.getAttribute("param").startsWith("T")) {
            simpleNode2.addChildNode(new SimpleNode(0, "=T="));
        }
        return simpleNode2;
    }

    private void resolveNodes(SimpleNode simpleNode, SimpleNode simpleNode2) {
        for (int i = 0; i < simpleNode.childCount(); ++i) {
            Object object;
            SimpleNode simpleNode3 = simpleNode.childAt(i);
            String string = simpleNode3.getAttribute("param");
            int n = 1;
            if (string.indexOf("*") > -1) {
                Integer n2;
                if (this.mapResolveOcc == null) {
                    this.mapResolveOcc = new HashMap();
                }
                if ((n2 = (Integer)this.mapResolveOcc.get(simpleNode3)) == null) {
                    try {
                        object = simpleNode3.getAttribute("name");
                        String string2 = simpleNode3.getAttribute("hlp");
                        if (string2 != null) {
                            object = (String)object + " (" + string2 + ")";
                        }
                        n2 = new Integer(EditixFactory.buildAndShowInputDialog("Number of " + (String)object + " ?", "1"));
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = new Integer(1);
                    }
                    this.mapResolveOcc.put(simpleNode3, n2);
                }
                n = n2;
            }
            for (int j = 0; j < n; ++j) {
                object = this.extractXMLNode(simpleNode3);
                simpleNode2.addChildNode((SimpleNode)object);
                if (simpleNode3.isLeaf()) continue;
                this.resolveNodes(simpleNode3, (SimpleNode)object);
            }
        }
    }

    class NodeTransfertHandler
    extends TransferHandler {
        private TreePath transferedPath = null;

        NodeTransfertHandler() {
        }

        public int getSourceActions(JComponent jComponent) {
            return 2;
        }

        public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
            return jComponent instanceof JTree && this.transferedPath != null;
        }

        protected Transferable createTransferable(JComponent jComponent) {
            this.transferedPath = SnippetUI.this.t.getSelectionPath();
            Transferable transferable = new Transferable(){

                public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
                    if (this.isDataFlavorSupported(dataFlavor)) {
                        String string = null;
                        SimpleNode simpleNode = (SimpleNode)NodeTransfertHandler.this.transferedPath.getLastPathComponent();
                        string = simpleNode.matchContent("group") ? simpleNode.getAttribute("name") : SnippetUI.this.resolveNodeToXMLText(simpleNode);
                        string = string.replaceAll("=T=", "");
                        return string;
                    }
                    return null;
                }

                public DataFlavor[] getTransferDataFlavors() {
                    return SnippetUI.this.flavors;
                }

                public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
                    return dataFlavor.equals(DataFlavor.stringFlavor);
                }
            };
            return transferable;
        }

        protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
            super.exportDone(jComponent, transferable, n);
            SnippetUI.this.dragAndDropInUse = false;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean importData(JComponent jComponent, Transferable transferable) {
            try {
                TreePath treePath = SnippetUI.this.t.getSelectionPath();
                if (treePath == null) {
                    boolean bl = false;
                    return bl;
                }
                SimpleNode simpleNode = (SimpleNode)treePath.getLastPathComponent();
                SimpleNode simpleNode2 = null;
                if (this.transferedPath != null) {
                    simpleNode2 = (SimpleNode)this.transferedPath.getLastPathComponent();
                }
                if (!treePath.equals(this.transferedPath)) {
                    SimpleNode simpleNode3 = simpleNode;
                    if (this.transferedPath != null) {
                        simpleNode2.getSimpleParent().removeChildNode(simpleNode2);
                    }
                    simpleNode3.addChildNode(simpleNode2);
                    SnippetUI.this.refresh();
                    SnippetUI.this.selectNode(simpleNode2);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                SnippetUI.this.dragAndDropInUse = false;
                this.transferedPath = null;
            }
        }
    }

    class SnippetRenderer
    implements TreeCellRenderer {
        FastLabel fastlabel = new FastLabel(false);
        Icon element = null;
        Icon elementAny = null;
        Icon folder = null;
        Icon folder_closed = null;
        Icon attribute = null;

        public SnippetRenderer() {
            try {
                this.element = new ImageIcon(ClassLoader.getSystemResource("images/element.png"));
                this.elementAny = new ImageIcon(ClassLoader.getSystemResource("images/element_refresh.png"));
                this.attribute = new ImageIcon(ClassLoader.getSystemResource("images/attribute.png"));
                this.folder = new ImageIcon(ClassLoader.getSystemResource("images/folder.png"));
                this.folder_closed = new ImageIcon(ClassLoader.getSystemResource("images/folder_closed.png"));
            }
            catch (Throwable throwable) {
                System.err.println("Can't init icons ? : " + throwable.getMessage());
            }
        }

        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Object object2;
            Object object3;
            String string;
            Icon icon = null;
            if (!(object instanceof SimpleNode)) {
                this.fastlabel.setText("?");
                this.fastlabel.setIcon(null);
                return this.fastlabel;
            }
            SimpleNode simpleNode = (SimpleNode)object;
            if (simpleNode.isAttribute()) {
                string = simpleNode.getNodeValue();
                icon = this.attribute;
            } else if (simpleNode.matchContent("item")) {
                object3 = simpleNode.getAttribute("name");
                string = object3;
                icon = this.element;
                object2 = simpleNode.getAttribute("hlp");
                if (simpleNode.getAttribute("param", "").indexOf("*") > -1) {
                    icon = this.elementAny;
                }
                if (object2 != null) {
                    string = string + " (" + (String)object2 + ")";
                }
            } else {
                string = simpleNode.matchContent("group") ? simpleNode.getAttribute("name") : simpleNode.getContent();
                icon = !bl2 ? this.folder_closed : this.folder;
            }
            this.fastlabel.setIcon(icon);
            this.fastlabel.setText(string);
            if (bl) {
                this.fastlabel.setForeground(UIManager.getColor("List.selectionForeground"));
                this.fastlabel.setBackground(UIManager.getColor("List.selectionBackground"));
            } else {
                object3 = jTree.getForeground();
                object2 = jTree.getBackground();
                this.fastlabel.setForeground((Color)object3);
                this.fastlabel.setBackground((Color)object2);
            }
            if ("false".equals(simpleNode.getAttribute("test", "true"))) {
                this.fastlabel.setForeground(Color.red);
            }
            return this.fastlabel;
        }
    }

    class SnippetTreeModel
    implements TreeModel {
        private SimpleNode root;
        private ArrayList listeners;

        SnippetTreeModel(SimpleNode simpleNode) {
            this.root = simpleNode;
        }

        public void addTreeModelListener(TreeModelListener treeModelListener) {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(treeModelListener);
        }

        public void refresh() {
            if (this.listeners != null) {
                for (int i = 0; i < this.listeners.size(); ++i) {
                    TreeModelListener treeModelListener = (TreeModelListener)this.listeners.get(i);
                    treeModelListener.treeStructureChanged(new TreeModelEvent((Object)SnippetUI.this.t, new TreePath(this.root)));
                }
            }
        }

        public Object getChild(Object object, int n) {
            SwingNode swingNode = (SwingNode)object;
            if (swingNode.matchContent("group")) {
                return swingNode.childAt(n);
            }
            if (swingNode.matchContent("item")) {
                if (n < this.getAttCount(swingNode)) {
                    return swingNode.getViewAttributeNodes().get(n + 2);
                }
                return swingNode.childAt(n - this.getAttCount(swingNode));
            }
            return null;
        }

        public int getChildCount(Object object) {
            SwingNode swingNode = (SwingNode)object;
            if (swingNode.matchContent("group")) {
                return swingNode.childCount();
            }
            if (swingNode.matchContent("item")) {
                return swingNode.childCount() + this.getAttCount(swingNode);
            }
            return 0;
        }

        private int getAttCount(SimpleNode simpleNode) {
            if (simpleNode.getViewAttributeCount() > 2) {
                return simpleNode.getViewAttributeCount() - 2 - (simpleNode.hasAttribute("hlp") ? 1 : 0);
            }
            return 0;
        }

        public int getIndexOfChild(Object object, Object object2) {
            SwingNode swingNode = (SwingNode)object;
            if (swingNode.matchContent("group")) {
                return swingNode.childNodeIndex((SimpleNode)object2);
            }
            if (swingNode.matchContent("item")) {
                int n = -1;
                if (swingNode.getViewAttributeCount() > 0) {
                    n = swingNode.getViewAttributeNodes().indexOf(object2);
                }
                if (n == -1) {
                    n = this.getAttCount(swingNode) + swingNode.childNodeIndex((SimpleNode)object2);
                }
                return n;
            }
            return -1;
        }

        public Object getRoot() {
            return this.root;
        }

        public boolean isLeaf(Object object) {
            SwingNode swingNode = (SwingNode)object;
            return swingNode.getChildCount() == 0 && this.getAttCount(swingNode) == 0;
        }

        public void removeTreeModelListener(TreeModelListener treeModelListener) {
            if (this.listeners != null) {
                this.listeners.remove(treeModelListener);
            }
        }

        public void valueForPathChanged(TreePath treePath, Object object) {
        }
    }
}

