/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.ui.panels;

import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.editix.ui.panels.Panel;
import com.japisoft.editix.ui.panels.PanelManager;
import com.japisoft.xmlpad.XMLContainer;
import javax.swing.Icon;
import javax.swing.JComponent;

public abstract class AbstractPanel
implements Panel {
    private boolean shownState = false;
    protected String params = null;
    private JComponent builtView;
    private String id;
    private Icon icon;

    public void init() {
    }

    public void setParams(String string) {
        this.params = string;
    }

    public void setState(boolean bl) {
        this.shownState = bl;
    }

    public void close() {
    }

    public void select(Object object) {
    }

    public void showPanel() {
        this.shownState = true;
        this.preShow();
        this.show();
    }

    protected void preShow() {
    }

    public boolean isShown() {
        return this.shownState;
    }

    public void hidePanel() {
        this.shownState = false;
        this.hide();
    }

    public void showHidePanel() {
        if (EditixFrame.dockingSpace.isHiddenPanes()) {
            this.shownState = false;
        }
        if (!this.shownState) {
            this.showPanel();
        } else {
            this.hidePanel();
        }
    }

    protected void show() {
        if (!EditixFrame.dockingSpace.hasPane(this.getId())) {
            EditixFrame.dockingSpace.setPane(this.getId(), this.getTitle(), this.getIcon(), this.getView());
        }
        EditixFrame.dockingSpace.showPane(this.getId());
        this.postShow();
    }

    protected void postShow() {
    }

    protected void hide() {
        this.preHide();
        PanelManager.saveState(true);
        EditixFrame.dockingSpace.hidePane(this.getId());
    }

    protected void preHide() {
    }

    protected abstract String getTitle();

    public JComponent getView() {
        if (this.builtView == null) {
            this.builtView = this.buildView();
        }
        return this.builtView;
    }

    protected abstract JComponent buildView();

    public void setId(String string) {
        this.id = string;
    }

    protected String getId() {
        return this.id;
    }

    protected Icon getIcon() {
        return this.icon;
    }

    public void setIcon(Icon icon) {
        this.icon = icon;
    }

    public boolean isVisible() {
        return this.shownState;
    }

    public void setCurrentXMLContainer(XMLContainer xMLContainer) {
    }
}

