/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.plugin;

import com.japisoft.editix.plugin.EditixPlugin;
import com.japisoft.editix.plugin.PluginContext;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.xmlpad.XMLContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;

public class PluginManager {
    static ArrayList pluginList = null;

    public static void loadPlugin() {
        URL uRL = ClassLoader.getSystemClassLoader().getResource("plugin");
        if (uRL == null) {
            System.out.println("Can't find plugin directory");
            return;
        }
        String string = uRL.toExternalForm();
        if (string.startsWith("file://")) {
            string = string.substring(7);
        } else if (string.startsWith("file:")) {
            string = string.substring(5);
        }
        File file = new File(string);
        String[] stringArray = file.list();
        if (stringArray == null) {
            return;
        }
        int n = 0;
        while (n < stringArray.length) {
            String string2;
            if (!(string2 = stringArray[n++]).endsWith(".jar")) continue;
            PluginManager.load(new File(file, string2));
        }
    }

    static void storeInBuffer(HashMap hashMap, String string, InputStream inputStream) {
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        int n = 0;
        boolean bl = false;
        try {
            while ((n = inputStream.read(byArray)) > 0) {
                if (byArray2 == null) {
                    byArray2 = new byte[n];
                    System.arraycopy(byArray, 0, byArray2, 0, n);
                    continue;
                }
                byte[] byArray3 = new byte[byArray2.length + n];
                System.arraycopy(byArray2, 0, byArray3, 0, byArray2.length);
                System.arraycopy(byArray, 0, byArray3, byArray3.length - n, n);
            }
            if (byArray2 != null) {
                if (string.endsWith(".class")) {
                    string = string.replace('/', '.').substring(0, string.length() - 6);
                }
                hashMap.put(string, byArray2);
            }
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void load(File file) {
        HashMap hashMap = new HashMap();
        try {
            JarInputStream jarInputStream = new JarInputStream(new FileInputStream(file));
            Attributes attributes = jarInputStream.getManifest().getMainAttributes();
            if (attributes == null) {
                System.out.println("No manifest attributes");
                return;
            }
            String string = attributes.getValue("Main-Class");
            if (string == null) {
                System.out.println("Cannot find Main-Class value in MANIFEST.MF");
                return;
            }
            try {
                JarEntry jarEntry = null;
                while ((jarEntry = jarInputStream.getNextJarEntry()) != null) {
                    String string2 = jarEntry.getName();
                    PluginManager.storeInBuffer(hashMap, string2, jarInputStream);
                }
            }
            finally {
                try {
                    jarInputStream.close();
                }
                catch (Throwable throwable) {}
                if (!hashMap.containsKey(string)) {
                    System.out.println("Cannot find main class " + string);
                    return;
                }
                PluginManager.addPlugin(string, hashMap);
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public static Iterator getPlugins() {
        if (pluginList == null) {
            return null;
        }
        return pluginList.iterator();
    }

    public static void start(int n) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        ((EditixPlugin)pluginList.get(n)).start(new PluginContext(xMLContainer.getDocument(), xMLContainer.getEditor().getCaretPosition(), xMLContainer.getDocumentInfo().getCurrentDocumentLocation()));
    }

    static void addPlugin(String string, HashMap hashMap) {
        CustomClassLoader customClassLoader = new CustomClassLoader(hashMap);
        try {
            EditixPlugin editixPlugin = (EditixPlugin)customClassLoader.loadClass(string).newInstance();
            editixPlugin.init();
            if (pluginList == null) {
                pluginList = new ArrayList();
            }
            pluginList.add(editixPlugin);
            System.out.println("add plugin " + editixPlugin.getName());
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    static class CustomClassLoader
    extends ClassLoader {
        private HashMap map;

        public CustomClassLoader(HashMap hashMap) {
            this.map = hashMap;
        }

        public Class findClass(String string) throws ClassNotFoundException {
            byte[] byArray = this.loadClassData(string);
            if (byArray == null) {
                throw new ClassNotFoundException(string);
            }
            return this.defineClass(string, byArray, 0, byArray.length);
        }

        private byte[] loadClassData(String string) {
            byte[] byArray = (byte[])this.map.get(string);
            return byArray;
        }
    }
}

