/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.db.berkley;

import com.japisoft.editix.db.AbstractNodeDb;
import com.japisoft.editix.db.FileNodeDb;
import com.japisoft.editix.db.berkley.BerkleyContainerDbImpl;
import com.japisoft.editix.db.ui.Editable;
import com.sleepycat.dbxml.XmlDocument;
import com.sleepycat.dbxml.XmlException;

public class BerkleyFileNodeImpl
extends AbstractNodeDb
implements FileNodeDb,
Editable {
    private XmlDocument doc;
    private boolean editable = true;

    public BerkleyFileNodeImpl(XmlDocument xmlDocument) {
        this.doc = xmlDocument;
    }

    public BerkleyFileNodeImpl(XmlDocument xmlDocument, boolean bl) {
        this.doc = xmlDocument;
        this.setEdit(bl);
    }

    public String getContent() throws Exception {
        BerkleyContainerDbImpl berkleyContainerDbImpl = (BerkleyContainerDbImpl)this.getParent();
        return berkleyContainerDbImpl.getContent(this.name);
    }

    public boolean delete() throws Exception {
        BerkleyContainerDbImpl berkleyContainerDbImpl = (BerkleyContainerDbImpl)this.getParent();
        if (berkleyContainerDbImpl.delete(this.doc.getName())) {
            super.delete();
            return true;
        }
        return false;
    }

    public void setContent(String string) throws Exception {
        BerkleyContainerDbImpl berkleyContainerDbImpl = (BerkleyContainerDbImpl)this.getParent();
        this.doc.setContent(string);
        berkleyContainerDbImpl.setContent(this.doc);
    }

    protected void prepareName() {
        try {
            this.name = this.doc.getName();
        }
        catch (XmlException xmlException) {
            this.name = "error";
        }
    }

    public void setEdit(boolean bl) {
        this.editable = bl;
    }

    public boolean canEdit() {
        return this.editable;
    }

    public void refresh() throws Exception {
    }
}

