/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml.format;

import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.editix.ui.EditixFrame;
import com.japisoft.fastparser.node.SimpleNode;
import com.japisoft.framework.ApplicationModel;
import com.japisoft.framework.job.Job;
import com.japisoft.framework.job.JobManager;
import com.japisoft.framework.ui.toolkit.BrowserCaller;
import com.japisoft.framework.xml.format.Formatter;
import com.japisoft.framework.xml.format.FormatterConfig;
import com.japisoft.framework.xml.refactor2.AbstractRefactor;
import com.japisoft.p2.Manager;
import com.japisoft.xmlpad.XMLContainer;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;

public class FormatAction
extends AbstractAction {
    public static AbstractRefactor LAST_REFACTOR = null;

    protected FormatterConfig getFormatterConfig() {
        return new FormatterConfig();
    }

    protected AbstractRefactor getRefactor() {
        return null;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        XMLContainer xMLContainer = EditixFrame.ACCESSOR.getSelectedContainer();
        if (xMLContainer == null) {
            EditixFactory.buildAndShowErrorDialog("No document");
            return;
        }
        FormatAction.format(xMLContainer, this.getRefactor(), this.getFormatterConfig(), (String)this.getValue("param"));
    }

    public static void format(XMLContainer xMLContainer, AbstractRefactor abstractRefactor, FormatterConfig formatterConfig, String string) {
        block7: {
            String string2 = xMLContainer.getAccessibility().getText();
            try {
                if (abstractRefactor != null) {
                    if (Manager.isFree()) {
                        EditixFactory.buildAndShowInformationDialog("This action is not available inside the Free Edition.\nPlease look at http://www.editix.com");
                        BrowserCaller.displayURL("http://www.editix.com");
                        return;
                    }
                    LAST_REFACTOR = abstractRefactor;
                }
                if (formatterConfig == null) {
                    formatterConfig = new FormatterConfig();
                }
                String string3 = null;
                SimpleNode simpleNode = xMLContainer.getCurrentNode();
                if (simpleNode != null) {
                    string3 = simpleNode.getXPathLocation();
                }
                string2 = Formatter.format(string2, null, formatterConfig, abstractRefactor);
                xMLContainer.getAccessibility().setText(string2);
                xMLContainer.setModifiedState(true);
                if (string3 != null) {
                    JobManager.addJob(new RestoreLocationJob(xMLContainer, string3));
                }
            }
            catch (Throwable throwable) {
                ApplicationModel.debug(throwable);
                if ("".equals(throwable.getMessage()) || "silence".equals(string)) break block7;
                EditixFactory.buildAndShowErrorDialog("Can't format : " + throwable.getMessage());
            }
        }
    }

    static class RestoreLocationJob
    implements Job {
        private XMLContainer container;
        private String location;

        RestoreLocationJob(XMLContainer xMLContainer, String string) {
            this.container = xMLContainer;
            this.location = string;
        }

        public void dispose() {
            this.container = null;
        }

        public Object getSource() {
            return null;
        }

        public boolean isAlone() {
            return false;
        }

        public void stopIt() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                SimpleNode simpleNode;
                SimpleNode simpleNode2 = (SimpleNode)this.container.getTree().getModel().getRoot();
                if (simpleNode2 != null && (simpleNode = simpleNode2.getNodeForXPathLocation(this.location, true)) != null) {
                    this.container.getEditor().setCaretPosition(simpleNode.getStartingOffset() + 1);
                }
            }
            finally {
                this.dispose();
            }
        }
    }
}

