/*
 * Decompiled with CFR 0.152.
 */
package com.japisoft.editix.action.xml;

import com.japisoft.editix.EditixEntityResolver;
import com.japisoft.editix.action.xml.XMLCatalogAction;
import com.japisoft.editix.ui.EditixDialog;
import com.japisoft.editix.ui.EditixFactory;
import com.japisoft.framework.application.descriptor.ActionModel;
import com.japisoft.framework.dialog.actions.OKAction;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.DefaultTableModel;

public class XMLCatalogDialog
extends EditixDialog {
    DefaultTableModel tableModel = null;
    JTable tb;

    public XMLCatalogDialog() {
        super("XML Catalog", "XML Catalog", "Use your OASIS XML Catalogs for Parsing...\nNote that if you modify a catalog you must reload EditiX");
        this.initUI();
    }

    private void initUI() {
        this.tableModel = new DefaultTableModel(new String[]{"Catalog path"}, 0);
        this.tb = new JTable(this.tableModel);
        this.getContentPane().add(new JScrollPane(this.tb));
        JToolBar jToolBar = new JToolBar();
        jToolBar.setFloatable(false);
        jToolBar.add(new AddAction());
        jToolBar.add(new RemoveAction());
        jToolBar.addSeparator();
        jToolBar.add(new EditAction());
        this.getContentPane().add((Component)jToolBar, "South");
    }

    protected Dimension getDefaultSize() {
        return new Dimension(500, 400);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeClosing() {
        super.beforeClosing();
        if (this.getLastAction() == OKAction.ID) {
            File file = XMLCatalogAction.getCatalogLstPath();
            try {
                BufferedWriter bufferedWriter = new BufferedWriter(new FileWriter(file));
                try {
                    for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
                        bufferedWriter.write((String)this.tableModel.getValueAt(i, 0));
                        bufferedWriter.newLine();
                    }
                }
                finally {
                    bufferedWriter.close();
                }
                EditixEntityResolver.getInstance().loadCatalogs();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void beforeShowing() {
        super.beforeShowing();
        File file = XMLCatalogAction.getCatalogLstPath();
        if (file.exists()) {
            try {
                BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
                try {
                    String string = null;
                    while ((string = bufferedReader.readLine()) != null) {
                        this.tableModel.addRow(new Object[]{string});
                    }
                }
                finally {
                    bufferedReader.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    class EditAction
    extends AbstractAction {
        public EditAction() {
            this.putValue("Name", "Edit");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = XMLCatalogDialog.this.tb.getSelectedRow();
            if (n > -1) {
                String string = (String)XMLCatalogDialog.this.tableModel.getValueAt(n, 0);
                ActionModel.activeActionById("open", actionEvent, string, "XML");
            }
        }
    }

    class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", "Remove");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = XMLCatalogDialog.this.tb.getSelectedRow();
            if (n > -1) {
                XMLCatalogDialog.this.tableModel.removeRow(n);
            }
        }
    }

    class AddAction
    extends AbstractAction {
        public AddAction() {
            this.putValue("Name", "Add");
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JFileChooser jFileChooser = EditixFactory.buildFileChooserForDocumentType("XML");
            if (jFileChooser.showOpenDialog(XMLCatalogDialog.this) == 0) {
                XMLCatalogDialog.this.tableModel.addRow(new Object[]{jFileChooser.getSelectedFile().toString()});
            }
        }
    }
}

