/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.util;

import java.util.HashMap;
import org.exist.dom.DocumentSet;
import org.exist.dom.NodeSet;
import org.exist.dom.QName;
import org.exist.indexing.IndexWorker;
import org.exist.indexing.OrderedValuesIndex;
import org.exist.storage.Indexable;
import org.exist.util.Occurrences;
import org.exist.util.ValueOccurrences;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.IntegerValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class IndexKeyDocuments
extends BasicFunction {
    public static final FunctionSignature[] signatures = new FunctionSignature[]{new FunctionSignature(new QName("index-key-documents", "http://exist-db.org/xquery/util", "util"), "Return the number of documents for an indexed value. The first argument specifies the nodes whose content is indexed. The second argument specifies the value. ", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(20, 2)}, new SequenceType(31, 3)), new FunctionSignature(new QName("index-key-documents", "http://exist-db.org/xquery/util", "util"), "Return the number of documents for an indexed value. The first argument specifies the nodes whose content is indexed. The second argument specifies the value. The third argument specifies the index in which the search is made", new SequenceType[]{new SequenceType(-1, 7), new SequenceType(20, 2), new SequenceType(22, 2)}, new SequenceType(31, 3))};

    public IndexKeyDocuments(XQueryContext context, FunctionSignature signature) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        Sequence result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = Sequence.EMPTY_SEQUENCE;
        } else {
            NodeSet nodes = args[0].toNodeSet();
            DocumentSet docs = nodes.getDocumentSet();
            if (this.getArgumentCount() == 3) {
                IndexWorker indexWorker = this.context.getBroker().getIndexController().getWorkerByIndexName(args[2].itemAt(0).getStringValue());
                if (indexWorker == null) {
                    throw new XPathException("Unknown index: " + args[2].itemAt(0).getStringValue());
                }
                HashMap<String, Sequence> hints = new HashMap<String, Sequence>();
                if (indexWorker instanceof OrderedValuesIndex) {
                    hints.put("start_value", args[1]);
                } else {
                    LOG.info((Object)(indexWorker + " isn't an instance of org.exist.indexing.OrderedIndexWorker. " + args[1] + " ignored."));
                }
                Occurrences[] occur = indexWorker.scanIndex(this.context, docs, nodes, hints);
                result = occur.length == 0 ? Sequence.EMPTY_SEQUENCE : new IntegerValue(occur[0].getDocuments());
            } else {
                ValueOccurrences[] occur = this.context.getBroker().getValueIndex().scanIndexKeys(docs, nodes, (Indexable)((Object)args[1]));
                result = occur.length == 0 ? Sequence.EMPTY_SEQUENCE : new IntegerValue(occur[0].getDocuments());
            }
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

