/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions.text;

import org.exist.dom.ExtArrayNodeSet;
import org.exist.dom.NodeProxy;
import org.exist.dom.NodeSetIterator;
import org.exist.dom.QName;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;

public class FilterNested
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("filter-nested", "http://exist-db.org/xquery/text", "text"), "Filters out all nodes in the node set $a, which do have descendant nodes in the same node set.  This is useful if you do a combined query like //(a|b)[. &= $terms] and some 'b' nodes are nested within 'a' nodes, but you only want to see the innermost matches, i.e. the 'b' nodes, not the 'a' nodes containing 'b' nodes.", new SequenceType[]{new SequenceType(-1, 7)}, new SequenceType(-1, 7));

    public FilterNested(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        if (args[0].isEmpty()) {
            return Sequence.EMPTY_SEQUENCE;
        }
        ExtArrayNodeSet inSet = (ExtArrayNodeSet)args[0].toNodeSet();
        ExtArrayNodeSet filtered = new ExtArrayNodeSet();
        NodeSetIterator i = inSet.iterator();
        while (i.hasNext()) {
            NodeProxy p = (NodeProxy)i.next();
            if (inSet.hasDescendantsInSet(p.getDocument(), p.getNodeId(), false, -1) != null) continue;
            filtered.add(p);
        }
        return filtered;
    }
}

