/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import java.util.Iterator;
import java.util.List;
import org.exist.dom.QName;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.Function;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.Error;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;
import org.exist.xquery.value.Type;

public class FunConcat
extends Function {
    public static final FunctionSignature signature = new FunctionSignature(new QName("concat", "http://www.w3.org/2005/xpath-functions"), "Accepts two or more xdt:anyAtomicType arguments and converts them to xs:string. Returns the xs:string that is the concatenation of the values of its arguments after conversion. If any of the arguments is the empty sequence, the argument is treated as the zero-length string.", new SequenceType[]{new SequenceType(20, 3)}, new SequenceType(22, 3), true);

    public FunConcat(XQueryContext context) {
        super(context, signature);
    }

    public int returnsType() {
        return 22;
    }

    public void setArguments(List arguments) throws XPathException {
        Iterator i = arguments.iterator();
        while (i.hasNext()) {
            Expression next = (Expression)i.next();
            if (!Type.subTypeOf((next = new DynamicCardinalityCheck(this.context, 3, next, new Error("D02", "1", this.mySignature))).returnsType(), 20)) {
                next = new Atomize(this.context, next);
            }
            this.steps.add(next);
        }
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.inPredicate = (contextInfo.getFlags() & 2) > 0;
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            this.getArgument(i).analyze(contextInfo);
        }
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        if (this.getArgumentCount() < 2) {
            throw new XPathException("concat requires at least two arguments");
        }
        StringBuffer concat = new StringBuffer();
        for (int i = 0; i < this.getArgumentCount(); ++i) {
            concat.append(this.getArgument(i).eval(contextSequence, contextItem).getStringValue());
        }
        StringValue result = new StringValue(concat.toString());
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

