/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery.functions;

import org.exist.dom.QName;
import org.exist.util.XMLChar;
import org.exist.xquery.BasicFunction;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.FunctionSignature;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.value.NumericValue;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.SequenceType;
import org.exist.xquery.value.StringValue;

public class FunCodepointsToString
extends BasicFunction {
    public static final FunctionSignature signature = new FunctionSignature(new QName("codepoints-to-string", "http://www.w3.org/2005/xpath-functions", ""), "Creates an xs:string from a sequence of code points. Returns the zero-length string if $a is the empty sequence. If any of the code points in $a is not a legal XML character, an error is raised", new SequenceType[]{new SequenceType(31, 7)}, new SequenceType(22, 2));

    public FunCodepointsToString(XQueryContext context) {
        super(context, signature);
    }

    public Sequence eval(Sequence[] args, Sequence contextSequence) throws XPathException {
        StringValue result;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
        }
        if (args[0].isEmpty()) {
            result = StringValue.EMPTY_STRING;
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = args[0].iterate();
            while (i.hasNext()) {
                long next = ((NumericValue)i.nextItem()).getLong();
                if (next > Integer.MAX_VALUE || !XMLChar.isValid((int)next)) {
                    throw new XPathException(this.getASTNode(), "Codepoint " + next + " is not a valid character.");
                }
                if (next < 65536L) {
                    buf.append((char)next);
                    continue;
                }
                buf.append(XMLChar.highSurrogate((int)next));
                buf.append(XMLChar.lowSurrogate((int)next));
            }
            result = new StringValue(buf.toString());
        }
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }
}

