/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import org.exist.memtree.MemTreeBuilder;
import org.exist.memtree.NodeImpl;
import org.exist.util.XMLChar;
import org.exist.xquery.AnalyzeContextInfo;
import org.exist.xquery.Atomize;
import org.exist.xquery.Dependency;
import org.exist.xquery.Expression;
import org.exist.xquery.NodeConstructor;
import org.exist.xquery.Profiler;
import org.exist.xquery.XPathException;
import org.exist.xquery.XQueryContext;
import org.exist.xquery.util.ExpressionDumper;
import org.exist.xquery.value.Item;
import org.exist.xquery.value.Sequence;
import org.exist.xquery.value.SequenceIterator;
import org.exist.xquery.value.Type;

public class DynamicPIConstructor
extends NodeConstructor {
    private Expression name;
    private Expression content;

    public DynamicPIConstructor(XQueryContext context) {
        super(context);
    }

    public void setNameExpr(Expression nameExpr) {
        this.name = new Atomize(this.context, nameExpr);
    }

    public void setContentExpr(Expression contentExpr) {
        this.content = new Atomize(this.context, contentExpr);
    }

    public void analyze(AnalyzeContextInfo contextInfo) throws XPathException {
        contextInfo.setParent(this);
        this.name.analyze(contextInfo);
        this.content.analyze(contextInfo);
    }

    public Sequence eval(Sequence contextSequence, Item contextItem) throws XPathException {
        String contentString;
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().start(this);
            this.context.getProfiler().message((Expression)this, Profiler.DEPENDENCIES, "DEPENDENCIES", Dependency.getDependenciesName(this.getDependencies()));
            if (contextSequence != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT SEQUENCE", contextSequence);
            }
            if (contextItem != null) {
                this.context.getProfiler().message((Expression)this, Profiler.START_SEQUENCES, "CONTEXT ITEM", contextItem.toSequence());
            }
        }
        MemTreeBuilder builder = this.context.getDocumentBuilder();
        this.context.proceed(this, builder);
        Sequence nameSeq = this.name.eval(contextSequence, contextItem);
        if (!nameSeq.hasOne()) {
            throw new XPathException(this.getASTNode(), "The name expression should evaluate to a single value");
        }
        Item nameItem = nameSeq.itemAt(0);
        if (nameItem.getType() != 22 && nameItem.getType() != 65 && nameItem.getType() != 21) {
            throw new XPathException(this.getASTNode(), "The name expression should evaluate to a " + Type.getTypeName(22) + " or a " + Type.getTypeName(65) + " or a " + Type.getTypeName(21) + ". Got: " + Type.getTypeName(nameItem.getType()));
        }
        if (!XMLChar.isValidNCName(nameSeq.getStringValue())) {
            throw new XPathException("XQDY0041 '" + nameSeq.getStringValue() + "' is not a valid processing instruction name");
        }
        if (nameSeq.getStringValue().equalsIgnoreCase("XML")) {
            throw new XPathException("XQDY0064 '" + nameSeq.getStringValue() + "' is not a valid processing instruction name");
        }
        Sequence contentSeq = this.content.eval(contextSequence, contextItem);
        if (contentSeq.isEmpty()) {
            contentString = "";
        } else {
            StringBuffer buf = new StringBuffer();
            SequenceIterator i = contentSeq.iterate();
            while (i.hasNext()) {
                this.context.proceed(this, builder);
                Item next = i.nextItem();
                if (buf.length() > 0) {
                    buf.append(' ');
                }
                buf.append(next.getStringValue());
            }
            while (buf.length() > 0 && Character.isWhitespace(buf.charAt(0))) {
                buf.deleteCharAt(0);
            }
            contentString = buf.toString();
        }
        if (contentString.indexOf("?>") != -1) {
            throw new XPathException("XQDY0026 '" + contentString + "' is not a valid processing intruction content");
        }
        int nodeNr = builder.processingInstruction(nameSeq.getStringValue(), contentString);
        NodeImpl result = builder.getDocument().getNode(nodeNr);
        if (this.context.getProfiler().isEnabled()) {
            this.context.getProfiler().end(this, "", result);
        }
        return result;
    }

    public void dump(ExpressionDumper dumper) {
        dumper.display("processing-instruction {");
        this.name.dump(dumper);
        dumper.display("} {");
        dumper.startIndent();
        this.content.dump(dumper);
        dumper.endIndent().nl().display("}");
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("processing-instruction {");
        result.append(this.name.toString());
        result.append("} {");
        result.append(this.content.toString());
        result.append("} ");
        return result.toString();
    }

    public void resetState(boolean postOptimization) {
        super.resetState(postOptimization);
        this.name.resetState(postOptimization);
        this.content.resetState(postOptimization);
    }
}

