/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xquery;

import java.util.ArrayList;
import java.util.List;
import org.exist.xquery.Atomize;
import org.exist.xquery.CastExpression;
import org.exist.xquery.ConditionalExpression;
import org.exist.xquery.DynamicCardinalityCheck;
import org.exist.xquery.DynamicNameCheck;
import org.exist.xquery.DynamicTypeCheck;
import org.exist.xquery.Expression;
import org.exist.xquery.ExpressionVisitor;
import org.exist.xquery.ForExpr;
import org.exist.xquery.Function;
import org.exist.xquery.GeneralComparison;
import org.exist.xquery.LetExpr;
import org.exist.xquery.LocationStep;
import org.exist.xquery.OpAnd;
import org.exist.xquery.OpOr;
import org.exist.xquery.PathExpr;
import org.exist.xquery.Predicate;
import org.exist.xquery.Union;
import org.exist.xquery.UntypedValueCheck;
import org.exist.xquery.UserDefinedFunction;
import org.exist.xquery.functions.ExtFulltext;

public class BasicExpressionVisitor
implements ExpressionVisitor {
    public void visit(Expression expression) {
        this.processWrappers(expression);
    }

    public void visitCastExpr(CastExpression expression) {
    }

    public void visitFtExpression(ExtFulltext fulltext) {
    }

    public void visitPathExpr(PathExpr expression) {
        if (expression.getLength() == 1) {
            Expression next = expression.getExpression(0);
            next.accept(this);
        }
    }

    public void visitGeneralComparison(GeneralComparison comparison) {
    }

    public void visitUnionExpr(Union union) {
    }

    public void visitAndExpr(OpAnd and) {
    }

    public void visitOrExpr(OpOr or) {
    }

    public void visitLocationStep(LocationStep locationStep) {
    }

    public void visitPredicate(Predicate predicate) {
    }

    protected void processWrappers(Expression expr) {
        if (expr instanceof Atomize || expr instanceof DynamicCardinalityCheck || expr instanceof DynamicNameCheck || expr instanceof DynamicTypeCheck || expr instanceof UntypedValueCheck) {
            expr.accept(this);
        }
    }

    public static LocationStep findFirstStep(Expression expr) {
        if (expr instanceof LocationStep) {
            return (LocationStep)expr;
        }
        FirstStepVisitor visitor = new FirstStepVisitor();
        expr.accept(visitor);
        return visitor.firstStep;
    }

    public static List findLocationSteps(Expression expr) {
        final ArrayList<Expression> steps = new ArrayList<Expression>(5);
        if (expr instanceof LocationStep) {
            steps.add(expr);
            return steps;
        }
        expr.accept(new BasicExpressionVisitor(){

            public void visitPathExpr(PathExpr expression) {
                for (int i = 0; i < expression.getLength(); ++i) {
                    Expression next = expression.getExpression(i);
                    next.accept(this);
                }
            }

            public void visitLocationStep(LocationStep locationStep) {
                steps.add(locationStep);
            }
        });
        return steps;
    }

    public void visitForExpression(ForExpr forExpr) {
    }

    public void visitLetExpression(LetExpr letExpr) {
    }

    public void visitBuiltinFunction(Function function) {
    }

    public void visitUserFunction(UserDefinedFunction function) {
    }

    public void visitConditional(ConditionalExpression conditional) {
    }

    public static class FirstStepVisitor
    extends BasicExpressionVisitor {
        private LocationStep firstStep = null;

        public LocationStep getFirstStep() {
            return this.firstStep;
        }

        public void visitLocationStep(LocationStep locationStep) {
            this.firstStep = locationStep;
        }
    }
}

