/*
 * Decompiled with CFR 0.152.
 */
package org.exist.xmldb;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Date;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.exist.security.Permission;
import org.exist.util.MimeType;
import org.exist.xmldb.EXistResource;
import org.exist.xmldb.RemoteCollection;
import org.exist.xmldb.XmldbURI;
import org.w3c.dom.DocumentType;
import org.xml.sax.ext.LexicalHandler;
import org.xmldb.api.base.Collection;
import org.xmldb.api.base.XMLDBException;
import org.xmldb.api.modules.BinaryResource;

public class RemoteBinaryResource
implements BinaryResource,
EXistResource {
    private XmldbURI path;
    private String mimeType = MimeType.BINARY_TYPE.getName();
    private RemoteCollection parent;
    private byte[] data = null;
    private Permission permissions = null;
    private int contentLen = 0;
    protected Date dateCreated = null;
    protected Date dateModified = null;

    public RemoteBinaryResource(RemoteCollection parent, XmldbURI documentName) throws XMLDBException {
        this.parent = parent;
        this.path = documentName.numSegments() > 1 ? documentName : parent.getPathURI().append(documentName);
    }

    public Collection getParentCollection() throws XMLDBException {
        return this.parent;
    }

    public String getId() throws XMLDBException {
        return this.path.lastSegment().toString();
    }

    public String getResourceType() throws XMLDBException {
        return "BinaryResource";
    }

    public Object getContent() throws XMLDBException {
        if (this.data != null) {
            return this.data;
        }
        Vector<String> params = new Vector<String>();
        params.addElement(this.path.toString());
        try {
            this.data = (byte[])this.parent.getClient().execute("getBinaryResource", params);
        }
        catch (XmlRpcException e) {
            throw new XMLDBException(301, e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, e.getMessage(), (Throwable)e);
        }
        return this.data;
    }

    public void setContent(Object obj) throws XMLDBException {
        if (obj instanceof File) {
            this.readFile((File)obj);
        } else if (obj instanceof byte[]) {
            this.data = (byte[])obj;
        } else if (obj instanceof String) {
            this.data = ((String)obj).getBytes();
        } else {
            throw new XMLDBException(1, "don't know how to handle value of type " + obj.getClass().getName());
        }
    }

    private void readFile(File file) throws XMLDBException {
        try {
            FileInputStream is = new FileInputStream(file);
            ByteArrayOutputStream bos = new ByteArrayOutputStream(2048);
            byte[] temp = new byte[1024];
            int count = 0;
            while ((count = is.read(temp)) > -1) {
                bos.write(temp, 0, count);
            }
            this.data = bos.toByteArray();
        }
        catch (FileNotFoundException e) {
            throw new XMLDBException(1, "file " + file.getAbsolutePath() + " could not be found", (Throwable)e);
        }
        catch (IOException e) {
            throw new XMLDBException(1, "IO exception while reading file " + file.getAbsolutePath(), (Throwable)e);
        }
    }

    public Date getCreationTime() throws XMLDBException {
        return this.dateCreated;
    }

    public Date getLastModificationTime() throws XMLDBException {
        return this.dateModified;
    }

    public void setPermissions(Permission perms) {
        this.permissions = perms;
    }

    public Permission getPermissions() {
        return this.permissions;
    }

    public void setContentLength(int len) {
        this.contentLen = len;
    }

    public int getContentLength() throws XMLDBException {
        return this.contentLen;
    }

    public void setLexicalHandler(LexicalHandler handler) {
    }

    public void setMimeType(String mime) {
        this.mimeType = mime;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public DocumentType getDocType() throws XMLDBException {
        return null;
    }

    public void setDocType(DocumentType doctype) throws XMLDBException {
    }

    protected void setDateCreated(Date dateCreated) {
        this.dateCreated = dateCreated;
    }

    protected void setDateModified(Date dateModified) {
        this.dateModified = dateModified;
    }
}

