/*
 * Decompiled with CFR 0.152.
 */
package org.exist.util.hashtable;

import java.util.Iterator;
import org.exist.util.hashtable.AbstractHashtable;

public class Object2LongHashMap
extends AbstractHashtable {
    protected Object[] keys;
    protected long[] values;

    public Object2LongHashMap() {
        this.keys = new Object[this.tabSize];
        this.values = new long[this.tabSize];
    }

    public Object2LongHashMap(int iSize) {
        super(iSize);
        this.keys = new Object[this.tabSize];
        this.values = new long[this.tabSize];
    }

    public void put(Object key, long value) {
        try {
            this.insert(key, value);
        }
        catch (AbstractHashtable.HashtableOverflowException e) {
            Object[] copyKeys = this.keys;
            long[] copyValues = this.values;
            this.tabSize = (int)Object2LongHashMap.nextPrime(this.tabSize + this.tabSize / 2);
            this.keys = new Object[this.tabSize];
            this.values = new long[this.tabSize];
            this.items = 0;
            for (int k = 0; k < copyValues.length; ++k) {
                if (copyKeys[k] == null || copyKeys[k] == REMOVED) continue;
                this.put(copyKeys[k], copyValues[k]);
            }
            this.put(key, value);
        }
    }

    public long get(Object key) {
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1L;
        }
        if (this.keys[idx].equals(key)) {
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1L;
            }
            if (this.keys[idx] == REMOVED || !this.keys[idx].equals(key)) continue;
            return this.values[idx];
        }
        return -1L;
    }

    public boolean containsKey(Object key) {
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return false;
        }
        if (this.keys[idx].equals(key)) {
            return true;
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return false;
            }
            if (!this.keys[idx].equals(key)) continue;
            return true;
        }
        return false;
    }

    public long remove(Object key) {
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        if (this.keys[idx] == null) {
            return -1L;
        }
        if (this.keys[idx].equals(key)) {
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        int rehashVal = this.rehash(idx);
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == null) {
                return -1L;
            }
            if (!this.keys[idx].equals(key)) continue;
            this.keys[idx] = REMOVED;
            --this.items;
            return this.values[idx];
        }
        return -1L;
    }

    public Iterator iterator() {
        return new Object2LongIterator(0);
    }

    public Iterator valueIterator() {
        return new Object2LongIterator(1);
    }

    public Iterator stableIterator() {
        return new Object2LongStableIterator(0);
    }

    protected void insert(Object key, long value) throws AbstractHashtable.HashtableOverflowException {
        if (key == null) {
            throw new IllegalArgumentException("Illegal value: null");
        }
        int idx = Object2LongHashMap.hash(key) % this.tabSize;
        if (idx < 0) {
            idx *= -1;
        }
        int bucket = -1;
        if (this.keys[idx] == null) {
            this.keys[idx] = key;
            this.values[idx] = value;
            ++this.items;
            return;
        }
        if (this.keys[idx] == REMOVED) {
            bucket = idx;
        } else if (this.keys[idx].equals(key)) {
            this.values[idx] = value;
            return;
        }
        int rehashVal = this.rehash(idx);
        int rehashCnt = 1;
        for (int i = 0; i < this.tabSize; ++i) {
            if (this.keys[idx = (idx + rehashVal) % this.tabSize] == REMOVED) {
                bucket = idx;
            } else {
                if (this.keys[idx] == null) {
                    if (bucket > -1) {
                        idx = bucket;
                    }
                    this.keys[idx] = key;
                    this.values[idx] = value;
                    ++this.items;
                    return;
                }
                if (this.keys[idx].equals(key)) {
                    this.values[idx] = value;
                    return;
                }
            }
            ++rehashCnt;
        }
        if (bucket > -1) {
            this.keys[bucket] = key;
            this.values[bucket] = value;
            ++this.items;
            return;
        }
        throw new AbstractHashtable.HashtableOverflowException();
    }

    protected int rehash(int iVal) {
        int retVal = (iVal + iVal / 2) % this.tabSize;
        if (retVal == 0) {
            retVal = 1;
        }
        return retVal;
    }

    protected static final int hash(Object o) {
        return o.hashCode();
    }

    protected class Object2LongStableIterator
    extends AbstractHashtable.HashtableIterator {
        Object[] mKeys;
        long[] mValues;
        int idx;

        public Object2LongStableIterator(int type) {
            super(type);
            this.mKeys = null;
            this.mValues = null;
            this.idx = 0;
            this.mKeys = new Object[Object2LongHashMap.this.tabSize];
            System.arraycopy(Object2LongHashMap.this.keys, 0, this.mKeys, 0, Object2LongHashMap.this.tabSize);
            this.mValues = new long[Object2LongHashMap.this.tabSize];
            System.arraycopy(Object2LongHashMap.this.values, 0, this.mValues, 0, Object2LongHashMap.this.tabSize);
        }

        public boolean hasNext() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return false;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return null;
            }
            while (this.mKeys[this.idx] == null || this.mKeys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return new Long(this.mValues[this.idx++]);
            }
            return this.mKeys[this.idx++];
        }
    }

    protected class Object2LongIterator
    extends AbstractHashtable.HashtableIterator {
        int idx;

        public Object2LongIterator(int type) {
            super(type);
            this.idx = 0;
        }

        public boolean hasNext() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return false;
            }
            while (Object2LongHashMap.this.keys[this.idx] == null || Object2LongHashMap.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return false;
            }
            return true;
        }

        public Object next() {
            if (this.idx == Object2LongHashMap.this.tabSize) {
                return null;
            }
            while (Object2LongHashMap.this.keys[this.idx] == null || Object2LongHashMap.this.keys[this.idx] == AbstractHashtable.REMOVED) {
                ++this.idx;
                if (this.idx != Object2LongHashMap.this.tabSize) continue;
                return null;
            }
            if (this.returnType == 1) {
                return new Long(Object2LongHashMap.this.values[this.idx++]);
            }
            return Object2LongHashMap.this.keys[this.idx++];
        }
    }
}

