/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.lock;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.exist.storage.lock.Lock;
import org.exist.storage.lock.LockInfo;
import org.exist.storage.lock.MultiReadReentrantLock;
import org.exist.storage.lock.ReentrantReadWriteLock;
import org.exist.storage.lock.WaitingThread;

public class DeadlockDetection {
    private static final Object latch = new Object();
    private static final Map waitForResource = new HashMap();
    private static final Map waitForCollection = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addResourceWaiter(Thread thread, WaitingThread waiter) {
        Object object = latch;
        synchronized (object) {
            waitForResource.put(thread, waiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock clearResourceWaiter(Thread thread) {
        Object object = latch;
        synchronized (object) {
            WaitingThread waiter = (WaitingThread)waitForResource.remove(thread);
            if (waiter != null) {
                return waiter.getLock();
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaitingThread getResourceWaiter(Thread thread) {
        Object object = latch;
        synchronized (object) {
            return (WaitingThread)waitForResource.get(thread);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WaitingThread deadlockCheckResource(Thread threadA, Thread threadB) {
        Object object = latch;
        synchronized (object) {
            WaitingThread waitingThread = (WaitingThread)waitForResource.get(threadB);
            if (waitingThread != null) {
                return waitingThread.getLock().hasLock(threadA) ? waitingThread : null;
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isBlockedBy(Thread threadA, Thread threadB) {
        Object object = latch;
        synchronized (object) {
            WaitingThread waitingThread = (WaitingThread)waitForResource.get(threadB);
            if (waitingThread != null) {
                return waitingThread.getLock().hasLock(threadA);
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean wouldDeadlock(Thread waiter, Thread owner, List waiters) {
        Object object = latch;
        synchronized (object) {
            WaitingThread wt = (WaitingThread)waitForResource.get(owner);
            if (wt != null) {
                if (waiters.contains(wt)) {
                    return false;
                }
                waiters.add(wt);
                Lock l = wt.getLock();
                Thread t = ((MultiReadReentrantLock)l).getWriteLockedThread();
                if (t == owner) {
                    return false;
                }
                if (t != null) {
                    if (t == waiter) {
                        return true;
                    }
                    return DeadlockDetection.wouldDeadlock(waiter, t, waiters);
                }
                return false;
            }
            Lock l = (Lock)waitForCollection.get(owner);
            if (l != null) {
                Thread t = ((ReentrantReadWriteLock)l).getOwner();
                if (t == owner) {
                    return false;
                }
                if (t != null) {
                    if (t == waiter) {
                        return true;
                    }
                    return DeadlockDetection.wouldDeadlock(waiter, t, waiters);
                }
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addCollectionWaiter(Thread waiter, Lock lock) {
        Object object = latch;
        synchronized (object) {
            waitForCollection.put(waiter, lock);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock clearCollectionWaiter(Thread waiter) {
        Object object = latch;
        synchronized (object) {
            return (Lock)waitForCollection.remove(waiter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Lock isWaitingFor(Thread waiter) {
        Object object = latch;
        synchronized (object) {
            return (Lock)waitForCollection.get(waiter);
        }
    }

    public static Map getWaitingThreads() {
        HashMap<String, LockInfo> table = new HashMap<String, LockInfo>();
        Iterator<Object> i = waitForResource.values().iterator();
        while (i.hasNext()) {
            WaitingThread waitingThread = (WaitingThread)i.next();
            table.put(waitingThread.getThread().getName(), waitingThread.getLock().getLockInfo());
        }
        i = waitForCollection.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = (Map.Entry)i.next();
            Thread thread = (Thread)entry.getKey();
            table.put(thread.getName(), ((Lock)entry.getValue()).getLockInfo());
        }
        return table;
    }

    public static void debug(String name, LockInfo info) {
        StringWriter sout = new StringWriter();
        PrintWriter writer = new PrintWriter(sout);
        DeadlockDetection.debug(writer, name, info);
        writer.flush();
        writer.close();
        System.out.println(sout.toString());
    }

    public static void debug(PrintWriter writer, String name, LockInfo info) {
        writer.println("THREAD: " + name);
        if (info != null) {
            writer.println("Lock type: " + info.getLockType());
            writer.println("Lock mode: " + info.getLockMode());
            writer.println("Lock id: " + info.getId());
            writer.println("Held by: " + DeadlockDetection.arrayToString(info.getOwners()));
            writer.println("Read locks: " + DeadlockDetection.arrayToString(info.getReadLocks()));
            writer.println("Wait for read: " + DeadlockDetection.arrayToString(info.getWaitingForRead()));
            writer.println("Wait for write: " + DeadlockDetection.arrayToString(info.getWaitingForWrite()));
        }
    }

    public static void debug() {
        StringWriter sout = new StringWriter();
        PrintWriter writer = new PrintWriter(sout);
        Map threads = DeadlockDetection.getWaitingThreads();
        Iterator i = threads.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            DeadlockDetection.debug(writer, entry.getKey().toString(), (LockInfo)entry.getValue());
        }
        writer.close();
        System.out.println(sout.toString());
    }

    private static String arrayToString(Object[] a) {
        if (a == null) {
            return "null";
        }
        if (a.length == 0) {
            return "[]";
        }
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < a.length; ++i) {
            if (i == 0) {
                buf.append('[');
            } else {
                buf.append(", ");
            }
            buf.append(a[i] == null ? "null" : a[i].toString());
        }
        buf.append("]");
        return buf.toString();
    }
}

