/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.index;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.index.AbstractBFileLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class OverflowModifiedLoggable
extends AbstractBFileLoggable {
    protected long pageNum;
    protected long lastInChain;
    protected int length;
    protected int oldLength;

    public OverflowModifiedLoggable(byte fileId, Txn transaction, long pageNum, int length, int oldLength, long lastInChain) {
        super((byte)55, fileId, transaction);
        this.pageNum = pageNum;
        this.length = length;
        this.oldLength = oldLength;
        this.lastInChain = lastInChain;
    }

    public OverflowModifiedLoggable(DBBroker broker, long transactionId) {
        super(broker, transactionId);
    }

    public void write(ByteBuffer out) {
        super.write(out);
        out.putInt((int)this.pageNum);
        out.putInt(this.length);
        out.putInt(this.oldLength);
        out.putInt((int)this.lastInChain);
    }

    public void read(ByteBuffer in) {
        super.read(in);
        this.pageNum = in.getInt();
        this.length = in.getInt();
        this.oldLength = in.getInt();
        this.lastInChain = in.getInt();
    }

    public int getLogSize() {
        return super.getLogSize() + 16;
    }

    public void redo() throws LogException {
        this.getIndexFile().redoModifiedOverflow(this);
    }

    public void undo() throws LogException {
        this.getIndexFile().undoModifiedOverflow(this);
    }

    public String dump() {
        return super.dump() + " - update overflow page " + this.pageNum;
    }
}

