/*
 * Decompiled with CFR 0.152.
 */
package org.exist.storage.dom;

import java.nio.ByteBuffer;
import org.exist.storage.DBBroker;
import org.exist.storage.NativeBroker;
import org.exist.storage.dom.DOMFile;
import org.exist.storage.journal.AbstractLoggable;
import org.exist.storage.journal.LogException;
import org.exist.storage.txn.Txn;

public class AddValueLoggable
extends AbstractLoggable {
    protected DOMFile domDb;
    protected long pageNum;
    protected short tid;
    protected byte[] value;

    public AddValueLoggable() {
        super((byte)17, 0L);
    }

    public AddValueLoggable(Txn transaction, long pageNum, short tid, byte[] value) {
        this(17, transaction, pageNum, tid, value);
    }

    protected AddValueLoggable(byte id, Txn transaction, long pageNum, short tid, byte[] value) {
        super(id, transaction.getId());
        this.pageNum = pageNum;
        this.tid = tid;
        this.value = value;
    }

    public AddValueLoggable(DBBroker broker, long transactionId) {
        this(17, broker, transactionId);
    }

    protected AddValueLoggable(byte id, DBBroker broker, long transactionId) {
        super(id, transactionId);
        this.domDb = ((NativeBroker)broker).getDOMFile();
    }

    public void clear(Txn transaction, long pageNum, short tid, byte[] value) {
        super.clear(transaction.getId());
        this.pageNum = pageNum;
        this.tid = tid;
        this.value = value;
    }

    public void write(ByteBuffer out) {
        out.putInt((int)this.pageNum);
        out.putShort(this.tid);
        out.putShort((short)this.value.length);
        out.put(this.value);
    }

    public void read(ByteBuffer in) {
        this.pageNum = in.getInt();
        this.tid = in.getShort();
        this.value = new byte[in.getShort()];
        in.get(this.value);
    }

    public int getLogSize() {
        return 8 + this.value.length;
    }

    public void redo() throws LogException {
        this.domDb.redoAddValue(this);
    }

    public void undo() throws LogException {
        this.domDb.undoAddValue(this);
    }

    public String dump() {
        return super.dump() + " - added value; tid = " + this.tid + " to page " + this.pageNum;
    }
}

