/*
 * Decompiled with CFR 0.152.
 */
package org.exist.scheduler;

import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Vector;
import org.apache.log4j.Logger;
import org.exist.EXistException;
import org.exist.scheduler.JobDescription;
import org.exist.scheduler.ScheduledJobInfo;
import org.exist.scheduler.SystemTaskJob;
import org.exist.scheduler.UserJob;
import org.exist.scheduler.UserXQueryJob;
import org.exist.security.User;
import org.exist.storage.BrokerPool;
import org.exist.storage.SystemTask;
import org.exist.util.Configuration;
import org.quartz.CronTrigger;
import org.quartz.Job;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.JobExecutionContext;
import org.quartz.SchedulerException;
import org.quartz.SimpleTrigger;
import org.quartz.Trigger;
import org.quartz.impl.StdSchedulerFactory;
import org.quartz.spi.TriggerFiredBundle;

public class Scheduler {
    public static final String CONFIGURATION_ELEMENT_NAME = "scheduler";
    public static final String CONFIGURATION_JOB_ELEMENT_NAME = "job";
    public static final String JOB_TYPE_ATTRIBUTE = "type";
    public static final String JOB_CLASS_ATTRIBUTE = "class";
    public static final String JOB_XQUERY_ATTRIBUTE = "xquery";
    public static final String JOB_CRON_TRIGGER_ATTRIBUTE = "cron-trigger";
    public static final String JOB_PERIOD_ATTRIBUTE = "period";
    public static final String JOB_DELAY_ATTRIBUTE = "delay";
    public static final String JOB_REPEAT_ATTRIBUTE = "repeat";
    public static final String CONFIGURATION_JOB_PARAMETER_ELEMENT_NAME = "parameter";
    public static final String PROPERTY_SCHEDULER_JOBS = "scheduler.jobs";
    public static final String JOB_TYPE_USER = "user";
    public static final String JOB_TYPE_STARTUP = "startup";
    public static final String JOB_TYPE_SYSTEM = "system";
    private org.quartz.Scheduler scheduler = null;
    private Vector startupJobs = new Vector();
    private BrokerPool brokerpool = null;
    private Configuration config = null;
    private static final Logger LOG = Logger.getLogger((Class)Scheduler.class);

    public Scheduler(BrokerPool brokerpool, Configuration config) throws EXistException {
        this.brokerpool = brokerpool;
        this.config = config;
        try {
            InputStream is = Scheduler.class.getResourceAsStream("quartz.properties");
            Properties properties = new Properties();
            try {
                properties.load(is);
            }
            catch (IOException e) {
                throw new EXistException("Failed to load scheduler settings from org/exist/scheduler/quartz.properties");
            }
            StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(properties);
            this.scheduler = schedulerFactory.getScheduler();
        }
        catch (SchedulerException se) {
            throw new EXistException("Unable to create Scheduler", se);
        }
    }

    public void run() {
        try {
            this.setupConfiguredJobs();
            this.executeStartupJobs();
            this.scheduler.start();
        }
        catch (SchedulerException se) {
            LOG.error((Object)se);
        }
    }

    public void shutdown(boolean waitForJobsToComplete) {
        try {
            this.scheduler.shutdown(waitForJobsToComplete);
        }
        catch (SchedulerException se) {
            LOG.warn((Object)se);
        }
    }

    public boolean isShutdown() {
        try {
            return this.scheduler.isShutdown();
        }
        catch (SchedulerException se) {
            LOG.warn((Object)se);
            return false;
        }
    }

    private void createStartupJob(UserJob job, Properties params) {
        JobDetail jobDetail = new JobDetail(job.getName(), job.getGroup(), job.getClass());
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        this.setupJobDataMap(job, jobDataMap, params);
        SimpleTrigger trig = new SimpleTrigger();
        trig.setJobDataMap(jobDataMap);
        JobExecutionContext jec = new JobExecutionContext(null, new TriggerFiredBundle(jobDetail, (Trigger)trig, null, false, null, null, null, null), (Job)job);
        this.startupJobs.add(jec);
    }

    public void executeStartupJobs() {
        Iterator itStartupJob = this.startupJobs.iterator();
        while (itStartupJob.hasNext()) {
            JobExecutionContext jec = (JobExecutionContext)itStartupJob.next();
            Job j = jec.getJobInstance();
            if (LOG.isInfoEnabled()) {
                LOG.info((Object)("Running startup job '" + jec.getJobDetail().getName() + "'"));
            }
            try {
                j.execute(jec);
            }
            catch (SchedulerException se) {
                LOG.error((Object)("Unable to run startup job '" + jec.getJobDetail().getName() + "'"), (Throwable)se);
            }
        }
    }

    public boolean createPeriodicJob(long period, JobDescription job, long delay) {
        return this.createPeriodicJob(period, job, delay, null, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public boolean createPeriodicJob(long period, JobDescription job, long delay, Properties params) {
        return this.createPeriodicJob(period, job, delay, params, SimpleTrigger.REPEAT_INDEFINITELY);
    }

    public boolean createPeriodicJob(long period, JobDescription job, long delay, Properties params, int repeatCount) {
        JobDetail jobDetail = new JobDetail(job.getName(), job.getGroup(), job.getClass());
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        this.setupJobDataMap(job, jobDataMap, params);
        SimpleTrigger trigger = new SimpleTrigger();
        trigger.setRepeatInterval(period);
        trigger.setRepeatCount(repeatCount);
        if (delay <= 0L) {
            trigger.setStartTime(new Date());
        } else {
            Calendar start = Calendar.getInstance();
            start.add(14, (int)delay);
            trigger.setStartTime(start.getTime());
        }
        trigger.setName(job.getName() + " Trigger");
        try {
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (SchedulerException se) {
            LOG.error((Object)("Failed to schedule periodic job '" + job.getName() + "'"), (Throwable)se);
            return false;
        }
        return true;
    }

    public boolean createCronJob(String cronExpression, JobDescription job) {
        return this.createCronJob(cronExpression, job, null);
    }

    public boolean createCronJob(String cronExpression, JobDescription job, Properties params) {
        JobDetail jobDetail = new JobDetail(job.getName(), job.getGroup(), job.getClass());
        JobDataMap jobDataMap = jobDetail.getJobDataMap();
        this.setupJobDataMap(job, jobDataMap, params);
        try {
            CronTrigger trigger = new CronTrigger(job.getName() + " Trigger", job.getGroup(), cronExpression);
            this.scheduler.scheduleJob(jobDetail, (Trigger)trigger);
        }
        catch (ParseException pe) {
            LOG.error((Object)("Failed to schedule cron job '" + job.getName() + "'"), (Throwable)pe);
            return false;
        }
        catch (SchedulerException se) {
            LOG.error((Object)("Failed to schedule cron job '" + job.getName() + "'"), (Throwable)se);
            return false;
        }
        return true;
    }

    public boolean deleteJob(String jobName, String jobGroup) {
        try {
            return this.scheduler.deleteJob(jobName, jobGroup);
        }
        catch (SchedulerException se) {
            LOG.error((Object)("Failed to delete job '" + jobName + "'"), (Throwable)se);
            return false;
        }
    }

    public boolean pauseJob(String jobName, String jobGroup) {
        try {
            this.scheduler.pauseJob(jobName, jobGroup);
            return true;
        }
        catch (SchedulerException se) {
            LOG.error((Object)("Failed to pause job '" + jobName + "'"), (Throwable)se);
            return false;
        }
    }

    public boolean resumeJob(String jobName, String jobGroup) {
        try {
            this.scheduler.resumeJob(jobName, jobGroup);
            return true;
        }
        catch (SchedulerException se) {
            LOG.error((Object)("Failed to resume job '" + jobName + "'"), (Throwable)se);
            return false;
        }
    }

    public String[] getJobGroupNames() {
        try {
            return this.scheduler.getJobGroupNames();
        }
        catch (SchedulerException se) {
            LOG.error((Object)"Failed to get job group names", (Throwable)se);
            return null;
        }
    }

    public ScheduledJobInfo[] getScheduledJobs() {
        ArrayList<ScheduledJobInfo> jobs = new ArrayList<ScheduledJobInfo>();
        try {
            String[] trigGroups = this.scheduler.getTriggerGroupNames();
            for (int tg = 0; tg < trigGroups.length; ++tg) {
                String[] trigNames = this.scheduler.getTriggerNames(trigGroups[tg]);
                for (int tn = 0; tn < trigNames.length; ++tn) {
                    jobs.add(new ScheduledJobInfo(this.scheduler, this.scheduler.getTrigger(trigNames[tn], trigGroups[tg])));
                }
            }
        }
        catch (SchedulerException se) {
            LOG.error((Object)"Failed to get scheduled jobs", (Throwable)se);
            return null;
        }
        Object[] oJobsArray = jobs.toArray();
        ScheduledJobInfo[] jobsArray = new ScheduledJobInfo[oJobsArray.length];
        System.arraycopy(oJobsArray, 0, jobsArray, 0, oJobsArray.length);
        return jobsArray;
    }

    public ScheduledJobInfo[] getExecutingJobs() {
        List executingJobs = null;
        try {
            executingJobs = this.scheduler.getCurrentlyExecutingJobs();
        }
        catch (SchedulerException se) {
            LOG.error((Object)"Failed to get executing jobs", (Throwable)se);
            return null;
        }
        ScheduledJobInfo[] jobs = new ScheduledJobInfo[executingJobs.size()];
        for (int i = 0; i < executingJobs.size(); ++i) {
            JobExecutionContext jec = (JobExecutionContext)executingJobs.get(i);
            jobs[i] = new ScheduledJobInfo(this.scheduler, jec.getTrigger());
        }
        return jobs;
    }

    public void setupConfiguredJobs() {
        Configuration.JobConfig[] jobList = (Configuration.JobConfig[])this.config.getProperty(PROPERTY_SCHEDULER_JOBS);
        if (jobList == null) {
            return;
        }
        for (int i = 0; i < jobList.length; ++i) {
            Configuration.JobConfig jobConfig = jobList[i];
            JobDescription job = null;
            if (jobConfig.getResourceName().startsWith("/db/")) {
                if (jobConfig.getType().equals(JOB_TYPE_SYSTEM)) {
                    LOG.error((Object)"System jobs may only be written in Java");
                } else {
                    User guestUser = this.brokerpool.getSecurityManager().getUser("guest");
                    job = new UserXQueryJob(jobConfig.getResourceName(), guestUser);
                }
            } else {
                try {
                    Class<?> jobClass = Class.forName(jobConfig.getResourceName());
                    Object jobObject = jobClass.newInstance();
                    if (jobConfig.getType().equals(JOB_TYPE_SYSTEM)) {
                        if (jobObject instanceof SystemTask) {
                            SystemTask task = (SystemTask)jobObject;
                            task.configure(this.config, jobConfig.getParameters());
                            job = new SystemTaskJob(task);
                        } else {
                            LOG.error((Object)"System jobs must extend SystemTask");
                        }
                    } else {
                        job = (JobDescription)jobObject;
                    }
                }
                catch (Exception e) {
                    LOG.error((Object)("Unable to schedule '" + jobConfig.getType() + "' job " + jobConfig.getResourceName()), (Throwable)e);
                }
            }
            if (job == null) continue;
            if (jobConfig.getType().equals(JOB_TYPE_STARTUP)) {
                this.createStartupJob((UserJob)job, jobConfig.getParameters());
                continue;
            }
            if (jobConfig.getSchedule().indexOf(32) > -1) {
                this.createCronJob(jobConfig.getSchedule(), job, jobConfig.getParameters());
                continue;
            }
            this.createPeriodicJob(Long.parseLong(jobConfig.getSchedule()), job, jobConfig.getDelay(), jobConfig.getParameters(), jobConfig.getRepeat());
        }
    }

    private void setupJobDataMap(JobDescription job, JobDataMap jobDataMap, Properties params) {
        jobDataMap.put((Object)"brokerpool", (Object)this.brokerpool);
        if (job instanceof SystemTaskJob) {
            jobDataMap.put((Object)"systemtask", (Object)((SystemTaskJob)job).getSystemTask());
        }
        if (job instanceof UserXQueryJob) {
            jobDataMap.put("xqueryresource", ((UserXQueryJob)job).getXQueryResource());
            jobDataMap.put((Object)JOB_TYPE_USER, (Object)((UserXQueryJob)job).getUser());
        }
        if (params != null) {
            jobDataMap.put((Object)"params", (Object)params);
        }
    }
}

